/*
 * Decompiled with CFR 0.152.
 */
package jams.worldwind.ui.model;

import gov.nasa.worldwind.render.AbstractSurfaceShape;
import jams.worldwind.data.shapefile.JamsShapeAttributes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShapefileAttributesModel
extends DefaultTableModel {
    private static final Logger logger = LoggerFactory.getLogger(ShapefileAttributesModel.class);
    private final List<?> theObjects;

    public ShapefileAttributesModel(List<?> polyList) {
        this.theObjects = new ArrayList(polyList);
        this.fillTablewithData();
    }

    private void fillTablewithData() {
        this.setColumnIdentifiers();
        this.addRows();
    }

    private void setColumnIdentifiers() {
        super.addColumn("PROPERTIES");
        AbstractSurfaceShape s = (AbstractSurfaceShape)this.theObjects.get(0);
        JamsShapeAttributes sattr = (JamsShapeAttributes)s.getAttributes();
        Set d = sattr.getShapeFileRecord().getAttributes().getEntries();
        Iterator<?> iterator = this.theObjects.iterator();
        if (iterator.hasNext()) {
            Object o = iterator.next();
            for (Map.Entry e : d) {
                super.addColumn(e.getKey());
            }
        }
    }

    private void addRows() {
        for (Object o : this.theObjects) {
            AbstractSurfaceShape s = (AbstractSurfaceShape)o;
            JamsShapeAttributes sattr = (JamsShapeAttributes)s.getAttributes();
            Set d = sattr.getShapeFileRecord().getAttributes().getEntries();
            int columnCount = d.size() + 1;
            Vector<Object> v = new Vector<Object>(columnCount);
            boolean count = false;
            v.add(s);
            for (Map.Entry e : d) {
                v.add(e.getValue());
            }
            super.addRow(v);
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 0;
    }

    public Class getColumnClass(int columnIndex) {
        Object o = this.getValueAt(0, columnIndex);
        if (o != null) {
            return o.getClass();
        }
        return Object.class;
    }
}

