/*
 * Decompiled with CFR 0.152.
 */
package jams.worldwind.test;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericPropertyCellEditor
implements TableCellEditor {
    private static final Logger logger = LoggerFactory.getLogger(GenericPropertyCellEditor.class);
    private JTextField textField = new JTextField();
    private PropertyEditor pe;
    private Object oValue;
    private List lListeners = new ArrayList();

    public GenericPropertyCellEditor(PropertyEditor pe) {
        this.pe = pe;
        if (pe.supportsCustomEditor()) {
            pe.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    GenericPropertyCellEditor.this.oValue = evt.getNewValue();
                    GenericPropertyCellEditor.this.notifyListeners(true);
                }
            });
        } else {
            this.textField = new JTextField();
            this.textField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GenericPropertyCellEditor.this.stopCellEditing();
                }
            });
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.oValue = value;
        this.pe.setValue(value);
        if (this.pe.supportsCustomEditor()) {
            return this.pe.getCustomEditor();
        }
        this.textField.setText(this.pe.getAsText());
        return this.textField;
    }

    @Override
    public Object getCellEditorValue() {
        return this.oValue;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        boolean bSuccess = true;
        if (this.pe.supportsCustomEditor()) {
            this.oValue = this.pe.getValue();
        } else {
            try {
                this.pe.setAsText(this.textField.getText());
                this.oValue = this.pe.getValue();
            }
            catch (Exception e) {
                bSuccess = false;
                logger.error("Bad value: " + this.textField.getText() + " Exception: " + e.toString());
                this.textField.requestFocus();
            }
        }
        this.notifyListeners(true);
        return bSuccess;
    }

    @Override
    public void cancelCellEditing() {
        this.notifyListeners(false);
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.lListeners.add(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.lListeners.remove(l);
    }

    private void notifyListeners(boolean bStop) {
        for (int i = 0; i < this.lListeners.size(); ++i) {
            if (bStop) {
                ((CellEditorListener)this.lListeners.get(i)).editingStopped(null);
                continue;
            }
            ((CellEditorListener)this.lListeners.get(i)).editingCanceled(null);
        }
    }
}

