/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.awt.Color;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.geotools.filter.Filters;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Font;
import org.geotools.styling.Graphic;
import org.geotools.styling.Halo;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.UserLayer;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.Expression;

public class SLD {
    public static final int NOTFOUND = -1;
    public static final StyleBuilder builder = new StyleBuilder();
    public static final double ALIGN_LEFT = 1.0;
    public static final double ALIGN_CENTER = 0.5;
    public static final double ALIGN_RIGHT = 0.0;
    public static final double ALIGN_BOTTOM = 1.0;
    public static final double ALIGN_MIDDLE = 0.5;
    public static final double ALIGN_TOP = 0.0;

    public static Color lineColor(LineSymbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        Stroke stroke = symbolizer.getStroke();
        return SLD.strokeColor(stroke);
    }

    public static Color strokeColor(Stroke stroke) {
        return SLD.color(stroke);
    }

    public static Color color(Stroke stroke) {
        if (stroke == null) {
            return null;
        }
        return SLD.color(stroke.getColor());
    }

    public static Color color(Fill fill) {
        if (fill == null) {
            return null;
        }
        return SLD.color(fill.getColor());
    }

    public static void setLineColour(Style style, Color colour) {
        if (style == null) {
            return;
        }
        SLD.setLineColour(SLD.lineSymbolizer(style), colour);
    }

    public static void setLineColour(LineSymbolizer symbolizer, Color colour) {
        if (symbolizer == null) {
            return;
        }
        Stroke stroke = symbolizer.getStroke();
        if (stroke == null) {
            stroke = builder.createStroke(colour);
            symbolizer.setStroke(stroke);
        }
        if (colour != null) {
            stroke.setColor(builder.colorExpression(colour));
        }
    }

    public static Color color(LineSymbolizer symbolizer) {
        return SLD.lineColor(symbolizer);
    }

    public static int lineWidth(LineSymbolizer symbolizer) {
        if (symbolizer == null) {
            return -1;
        }
        Stroke stroke = symbolizer.getStroke();
        return SLD.width(stroke);
    }

    public static int width(Stroke stroke) {
        if (stroke == null) {
            return -1;
        }
        return SLD.intValue(stroke.getWidth());
    }

    public static int size(Mark mark) {
        if (mark == null) {
            return -1;
        }
        return SLD.intValue(mark.getSize());
    }

    public static int width(LineSymbolizer symbolizer) {
        return SLD.lineWidth(symbolizer);
    }

    public static double lineOpacity(LineSymbolizer symbolizer) {
        if (symbolizer == null) {
            return Double.NaN;
        }
        Stroke stroke = symbolizer.getStroke();
        return SLD.opacity(stroke);
    }

    public static double opacity(Stroke stroke) {
        if (stroke == null) {
            return Double.NaN;
        }
        return SLD.opacity(stroke.getOpacity());
    }

    public static double opacity(RasterSymbolizer rasterSymbolizer) {
        if (rasterSymbolizer == null) {
            return 1.0;
        }
        return SLD.opacity(rasterSymbolizer.getOpacity());
    }

    private static double opacity(Expression opacity) {
        if (opacity == null) {
            return 1.0;
        }
        Double numeric = (Double)opacity.evaluate(null, Double.class);
        return numeric;
    }

    public static String lineLinejoin(LineSymbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        Stroke stroke = symbolizer.getStroke();
        if (stroke == null) {
            return null;
        }
        Expression linejoinExp = stroke.getLineJoin();
        return linejoinExp.toString();
    }

    public static String lineLinecap(LineSymbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        Stroke stroke = symbolizer.getStroke();
        if (stroke == null) {
            return null;
        }
        Expression linecapExp = stroke.getLineCap();
        return linecapExp.toString();
    }

    public static float[] lineDash(LineSymbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        Stroke stroke = symbolizer.getStroke();
        if (stroke == null) {
            return null;
        }
        float[] linedash = stroke.getDashArray();
        return linedash;
    }

    public static URL pointGraphic(Style style) {
        PointSymbolizer point = SLD.pointSymbolizer(style);
        if (point == null) {
            return null;
        }
        Graphic graphic = point.getGraphic();
        if (graphic == null) {
            return null;
        }
        ExternalGraphic[] graphicList = graphic.getExternalGraphics();
        for (int i = 0; i < graphicList.length; ++i) {
            ExternalGraphic externalGraphic = graphicList[i];
            if (externalGraphic == null) continue;
            try {
                URL location = externalGraphic.getLocation();
                if (location == null) continue;
                return location;
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        return null;
    }

    public static Mark pointMark(Style style) {
        if (style == null) {
            return null;
        }
        return SLD.mark(SLD.pointSymbolizer(style));
    }

    public static Mark mark(PointSymbolizer sym) {
        return SLD.mark(SLD.graphic(sym));
    }

    public static Mark mark(Graphic graphic) {
        if (graphic == null) {
            return null;
        }
        return graphic.getMarks() != null && graphic.getMarks().length > 0 ? graphic.getMarks()[0] : null;
    }

    public static Graphic graphic(PointSymbolizer sym) {
        if (sym == null) {
            return null;
        }
        return sym.getGraphic();
    }

    public static int pointSize(PointSymbolizer symbolizer) {
        if (symbolizer == null) {
            return -1;
        }
        Graphic g = symbolizer.getGraphic();
        if (g == null) {
            return -1;
        }
        Expression exp = g.getSize();
        int size = SLD.intValue(exp);
        return size;
    }

    public static String pointWellKnownName(PointSymbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        Graphic g = symbolizer.getGraphic();
        if (g == null) {
            return null;
        }
        Mark[] markList = g.getMarks();
        for (int i = 0; i < markList.length; ++i) {
            String string;
            Mark mark = markList[i];
            if (mark == null || (string = SLD.wellKnownName(mark)) == null) continue;
            return string;
        }
        return null;
    }

    public static String wellKnownName(Mark mark) {
        if (mark == null) {
            return null;
        }
        Expression exp = mark.getWellKnownName();
        if (exp == null) {
            return null;
        }
        String string = SLD.stringValue(exp);
        return string;
    }

    public static Color pointColor(PointSymbolizer symbolizer) {
        return SLD.color(symbolizer);
    }

    public static void setPointColour(Style style, Color colour) {
        if (style == null) {
            return;
        }
        SLD.setPointColour(SLD.pointSymbolizer(style), colour);
    }

    public static void setPointColour(PointSymbolizer symbolizer, Color colour) {
        if (symbolizer == null) {
            return;
        }
        Graphic graphic = symbolizer.getGraphic();
        if (graphic == null) {
            graphic = builder.createGraphic();
        }
        Mark[] markList = graphic.getMarks();
        for (int i = 0; i < markList.length; ++i) {
            Fill fill;
            Mark mark = markList[i];
            if (mark == null) continue;
            Stroke stroke = mark.getStroke();
            if (stroke == null) {
                stroke = builder.createStroke(Color.BLACK);
                mark.setStroke(stroke);
            }
            if (colour == null || (fill = mark.getFill()) == null) continue;
            fill.setColor(builder.colorExpression(colour));
        }
    }

    public static Color color(PointSymbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        Graphic graphic = symbolizer.getGraphic();
        if (graphic == null) {
            return null;
        }
        Mark[] markList = graphic.getMarks();
        for (int i = 0; i < markList.length; ++i) {
            Color colour;
            Stroke stroke;
            Mark mark = markList[i];
            if (mark == null || (stroke = mark.getStroke()) == null || (colour = SLD.color(stroke.getColor())) == null) continue;
            return colour;
        }
        return null;
    }

    public static int pointWidth(PointSymbolizer symbolizer) {
        if (symbolizer == null) {
            return -1;
        }
        Graphic g = symbolizer.getGraphic();
        if (g == null) {
            return -1;
        }
        Mark[] markList = g.getMarks();
        for (int i = 0; i < markList.length; ++i) {
            int width;
            Expression exp;
            Stroke stroke;
            Mark mark = markList[i];
            if (mark == null || (stroke = mark.getStroke()) == null || (exp = stroke.getWidth()) == null || (width = SLD.intValue(exp)) == -1) continue;
            return width;
        }
        return -1;
    }

    public static double pointBorderOpacity(PointSymbolizer symbolizer) {
        if (symbolizer == null) {
            return Double.NaN;
        }
        Graphic graphic = symbolizer.getGraphic();
        if (graphic == null) {
            return Double.NaN;
        }
        Mark[] markList = graphic.getMarks();
        for (int i = 0; i < markList.length; ++i) {
            Stroke stroke;
            Mark mark = markList[i];
            if (mark == null || (stroke = mark.getStroke()) == null) continue;
            Expression opacityExp = stroke.getOpacity();
            return Double.parseDouble(opacityExp.toString());
        }
        return Double.NaN;
    }

    public static double pointOpacity(PointSymbolizer symbolizer) {
        if (symbolizer == null) {
            return Double.NaN;
        }
        Graphic graphic = symbolizer.getGraphic();
        if (graphic == null) {
            return Double.NaN;
        }
        Mark[] markList = graphic.getMarks();
        for (int i = 0; i < markList.length; ++i) {
            Expression expr;
            Fill fill;
            Mark mark = markList[i];
            if (mark == null || (fill = mark.getFill()) == null || (expr = fill.getOpacity()) == null) continue;
            return SLD.opacity(expr);
        }
        return Double.NaN;
    }

    public static Color pointFill(PointSymbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        Graphic graphic = symbolizer.getGraphic();
        if (graphic == null) {
            return null;
        }
        Mark[] markList = graphic.getMarks();
        for (int i = 0; i < markList.length; ++i) {
            Color colour;
            Fill fill;
            Mark mark = markList[i];
            if (mark == null || (fill = mark.getFill()) == null || (colour = SLD.color(fill.getColor())) == null) continue;
            return colour;
        }
        return null;
    }

    public static int polyWidth(PolygonSymbolizer symbolizer) {
        if (symbolizer == null) {
            return -1;
        }
        Stroke stroke = symbolizer.getStroke();
        if (stroke == null) {
            return -1;
        }
        int width = SLD.intValue(stroke.getWidth());
        return width;
    }

    public static Color polyColor(PolygonSymbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        Stroke stroke = symbolizer.getStroke();
        if (stroke == null) {
            return null;
        }
        Color colour = SLD.color(stroke.getColor());
        if (colour != null) {
            return colour;
        }
        return null;
    }

    public static void setPolyColour(Style style, Color colour) {
        if (style == null) {
            return;
        }
        SLD.setPolyColour(SLD.polySymbolizer(style), colour);
    }

    public static void setPolyColour(PolygonSymbolizer symbolizer, Color colour) {
        if (symbolizer == null) {
            return;
        }
        Stroke stroke = symbolizer.getStroke();
        if (stroke == null) {
            stroke = builder.createStroke(colour);
            symbolizer.setStroke(stroke);
        }
        if (colour != null) {
            stroke.setColor(builder.colorExpression(colour));
            Fill fill = symbolizer.getFill();
            if (fill != null) {
                fill.setColor(builder.colorExpression(colour));
            }
        }
    }

    public static Color polyFill(PolygonSymbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        Fill fill = symbolizer.getFill();
        if (fill == null) {
            return null;
        }
        Color colour = SLD.color(fill.getColor());
        if (colour != null) {
            return colour;
        }
        return null;
    }

    public static double polyBorderOpacity(PolygonSymbolizer symbolizer) {
        if (symbolizer == null) {
            return Double.NaN;
        }
        Stroke stroke = symbolizer.getStroke();
        if (stroke == null) {
            return Double.NaN;
        }
        Expression opacityExp = stroke.getOpacity();
        double opacity = Double.parseDouble(opacityExp.toString());
        return opacity;
    }

    public static double polyFillOpacity(PolygonSymbolizer symbolizer) {
        if (symbolizer == null) {
            return Double.NaN;
        }
        Fill fill = symbolizer.getFill();
        return SLD.opacity(fill);
    }

    public static double opacity(Fill fill) {
        Expression opacityExp;
        if (fill == null) {
            fill = Fill.DEFAULT;
        }
        if ((opacityExp = fill.getOpacity()) == null) {
            opacityExp = Fill.DEFAULT.getOpacity();
        }
        double opacity = Filters.asDouble(opacityExp);
        return opacity;
    }

    public static double rasterOpacity(RasterSymbolizer symbolizer) {
        if (symbolizer == null) {
            return Double.NaN;
        }
        return SLD.doubleValue(symbolizer.getOpacity());
    }

    public static double rasterOpacity(Style style) {
        return SLD.rasterOpacity(SLD.rasterSymbolizer(style));
    }

    public static TextSymbolizer textSymbolizer(FeatureTypeStyle fts) {
        return (TextSymbolizer)SLD.symbolizer(fts, TextSymbolizer.class);
    }

    public static TextSymbolizer textSymbolizer(Style style) {
        return (TextSymbolizer)SLD.symbolizer(style, TextSymbolizer.class);
    }

    public static Expression textLabel(TextSymbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        Expression exp = symbolizer.getLabel();
        if (exp == null) {
            return null;
        }
        return exp;
    }

    public static String textLabelString(TextSymbolizer sym) {
        Expression exp = SLD.textLabel(sym);
        return exp == null ? null : exp.toString();
    }

    public static Color textFontFill(TextSymbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        Fill fill = symbolizer.getFill();
        if (fill == null) {
            return null;
        }
        Color colour = SLD.color(fill.getColor());
        if (colour != null) {
            return colour;
        }
        return null;
    }

    public static Color textHaloFill(TextSymbolizer symbolizer) {
        Halo halo = symbolizer.getHalo();
        if (halo == null) {
            return null;
        }
        Fill fill = halo.getFill();
        if (fill == null) {
            return null;
        }
        Color colour = SLD.color(fill.getColor());
        if (colour != null) {
            return colour;
        }
        return null;
    }

    public static int textHaloWidth(TextSymbolizer symbolizer) {
        Halo halo = symbolizer.getHalo();
        if (halo == null) {
            return 0;
        }
        Expression exp = halo.getRadius();
        if (exp == null) {
            return 0;
        }
        int width = (int)Float.parseFloat(exp.toString());
        if (width != 0) {
            return width;
        }
        return 0;
    }

    public static double textHaloOpacity(TextSymbolizer symbolizer) {
        if (symbolizer == null) {
            return Double.NaN;
        }
        Halo halo = symbolizer.getHalo();
        if (halo == null) {
            return Double.NaN;
        }
        Fill fill = halo.getFill();
        if (fill == null) {
            return Double.NaN;
        }
        Expression expr = fill.getOpacity();
        if (expr == null) {
            return Double.NaN;
        }
        Double numeric = (Double)expr.evaluate(null, Double.class);
        if (numeric == null) {
            return Double.NaN;
        }
        return numeric;
    }

    public static Color color(Expression expr) {
        if (expr == null) {
            return null;
        }
        return (Color)expr.evaluate(null, Color.class);
    }

    public static int intValue(Expression expr) {
        return Filters.asInt(expr);
    }

    public static String stringValue(Expression expr) {
        return Filters.asString(expr);
    }

    public static double doubleValue(Expression expr) {
        return Filters.asDouble(expr);
    }

    public static RasterSymbolizer rasterSymbolizer(FeatureTypeStyle fts) {
        return (RasterSymbolizer)SLD.symbolizer(fts, RasterSymbolizer.class);
    }

    public static RasterSymbolizer rasterSymbolizer(Style style) {
        return (RasterSymbolizer)SLD.symbolizer(style, RasterSymbolizer.class);
    }

    public static LineSymbolizer lineSymbolizer(FeatureTypeStyle fts) {
        return (LineSymbolizer)SLD.symbolizer(fts, LineSymbolizer.class);
    }

    public static LineSymbolizer lineSymbolizer(Style style) {
        return (LineSymbolizer)SLD.symbolizer(style, LineSymbolizer.class);
    }

    public static Stroke stroke(LineSymbolizer sym) {
        if (sym == null) {
            return null;
        }
        return sym.getStroke();
    }

    public static Stroke stroke(PolygonSymbolizer sym) {
        if (sym == null) {
            return null;
        }
        return sym.getStroke();
    }

    public static Stroke stroke(PointSymbolizer sym) {
        Mark mark = SLD.mark(sym);
        return mark == null ? null : mark.getStroke();
    }

    public static Fill fill(PolygonSymbolizer sym) {
        if (sym == null) {
            return null;
        }
        return sym.getFill();
    }

    public static Fill fill(PointSymbolizer sym) {
        Mark mark = SLD.mark(sym);
        return mark == null ? null : mark.getFill();
    }

    public static PointSymbolizer pointSymbolizer(FeatureTypeStyle fts) {
        return (PointSymbolizer)SLD.symbolizer(fts, PointSymbolizer.class);
    }

    public static PointSymbolizer pointSymbolizer(Style style) {
        return (PointSymbolizer)SLD.symbolizer(style, PointSymbolizer.class);
    }

    public static PolygonSymbolizer polySymbolizer(FeatureTypeStyle fts) {
        return (PolygonSymbolizer)SLD.symbolizer(fts, PolygonSymbolizer.class);
    }

    public static PolygonSymbolizer polySymbolizer(Style style) {
        return (PolygonSymbolizer)SLD.symbolizer(style, PolygonSymbolizer.class);
    }

    public static FeatureTypeStyle featureTypeStyle(Style style, SimpleFeatureType type) {
        if (style == null) {
            return null;
        }
        if (type == null || type.getTypeName() == null) {
            return null;
        }
        FeatureTypeStyle[] styles = style.getFeatureTypeStyles();
        if (styles == null) {
            return null;
        }
        for (int i = 0; i < styles.length; ++i) {
            FeatureTypeStyle ftStyle = styles[i];
            if (!type.getTypeName().equals(ftStyle.getName())) continue;
            return ftStyle;
        }
        return null;
    }

    public static Style matchingStyle(Style[] styles, SimpleFeatureType schema) {
        if (styles == null || styles.length == 0) {
            return null;
        }
        for (int i = 0; i < styles.length; ++i) {
            Style style = styles[i];
            if (SLD.featureTypeStyle(style, schema) == null) continue;
            return style;
        }
        return null;
    }

    protected static Symbolizer symbolizer(Style style, Class SYMBOLIZER) {
        if (style == null) {
            return null;
        }
        FeatureTypeStyle[] ftStyleList = style.getFeatureTypeStyles();
        if (ftStyleList == null) {
            return null;
        }
        for (int i = 0; i < ftStyleList.length; ++i) {
            FeatureTypeStyle ftStyle = ftStyleList[i];
            Symbolizer result = SLD.symbolizer(ftStyle, SYMBOLIZER);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected static Symbolizer symbolizer(FeatureTypeStyle fts, Class SYMBOLIZER) {
        if (fts == null) {
            return null;
        }
        Rule[] ruleList = fts.getRules();
        if (ruleList == null) {
            return null;
        }
        for (int j = 0; j < ruleList.length; ++j) {
            Rule rule = ruleList[j];
            Symbolizer[] symbolizerList = rule.getSymbolizers();
            if (symbolizerList == null) continue;
            for (int k = 0; k < symbolizerList.length; ++k) {
                Symbolizer symbolizer = symbolizerList[k];
                if (symbolizer == null || !SYMBOLIZER.isInstance(symbolizer)) continue;
                return symbolizer;
            }
        }
        return null;
    }

    public static String colorToHex(Color c) {
        return "#" + Integer.toHexString(c.getRGB() & 0xFFFFFF);
    }

    public static Style[] styles(StyledLayerDescriptor sld) {
        StyledLayer[] layers = sld.getStyledLayers();
        ArrayList styles = new ArrayList();
        for (int i = 0; i < layers.length; ++i) {
            StyledLayer layer;
            if (layers[i] instanceof UserLayer) {
                layer = (UserLayer)layers[i];
                styles.addAll(SLD.toList(layer.getUserStyles()));
                continue;
            }
            if (!(layers[i] instanceof NamedLayer)) continue;
            layer = (NamedLayer)layers[i];
            styles.addAll(SLD.toList(layer.getStyles()));
        }
        return styles.toArray(new Style[styles.size()]);
    }

    public static FeatureTypeStyle[] featureTypeStyles(StyledLayerDescriptor sld) {
        Style[] style = SLD.styles(sld);
        ArrayList fts = new ArrayList();
        for (int i = 0; i < style.length; ++i) {
            fts.addAll(SLD.toList(style[i].getFeatureTypeStyles()));
        }
        return fts.toArray(new FeatureTypeStyle[fts.size()]);
    }

    public static FeatureTypeStyle featureTypeStyle(StyledLayerDescriptor sld, SimpleFeatureType type) {
        Style[] styles = SLD.styles(sld);
        for (int i = 0; i < styles.length; ++i) {
            FeatureTypeStyle[] fts = styles[i].getFeatureTypeStyles();
            for (int j = 0; j < fts.length; ++j) {
                if (!type.getTypeName().equals(fts[j].getName())) continue;
                return fts[j];
            }
        }
        return null;
    }

    private static List toList(Object[] array) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length; ++i) {
            list.add(array[i]);
        }
        return list;
    }

    public static Style defaultStyle(StyledLayerDescriptor sld) {
        Style[] style = SLD.styles(sld);
        for (int i = 0; i < style.length; ++i) {
            if (!style[i].isDefault()) continue;
            return style[i];
        }
        if (style.length == 0) {
            return null;
        }
        return style[0];
    }

    public static Filter[] filters(Rule[] rule) {
        Filter[] filter = new Filter[rule.length];
        for (int i = 0; i < rule.length; ++i) {
            filter[i] = rule[0].getFilter();
        }
        return filter;
    }

    public static Filter[] filters(Style style) {
        Rule[] rule = SLD.rules(style);
        return SLD.filters(rule);
    }

    public static Rule[] rules(Style style) {
        HashSet<Rule> ruleSet = new HashSet<Rule>();
        FeatureTypeStyle[] fts = style.getFeatureTypeStyles();
        for (int i = 0; i < fts.length; ++i) {
            Rule[] ftsRules = fts[i].getRules();
            for (int j = 0; j < ftsRules.length; ++j) {
                ruleSet.add(ftsRules[j]);
            }
        }
        if (ruleSet.size() > 0) {
            return SLD.toRuleArray(ruleSet.toArray());
        }
        return new Rule[0];
    }

    public static Symbolizer[] symbolizers(Style style) {
        HashSet<Symbolizer> symbolizers = new HashSet<Symbolizer>();
        Rule[] rule = SLD.rules(style);
        for (int i = 0; i < rule.length; ++i) {
            Symbolizer[] symb = rule[i].getSymbolizers();
            for (int j = 0; j < symb.length; ++j) {
                symbolizers.add(symb[j]);
            }
        }
        if (symbolizers.size() > 0) {
            return SLD.toSymbolizerArray(symbolizers.toArray());
        }
        return new Symbolizer[0];
    }

    public static Symbolizer[] symbolizers(Rule rule) {
        HashSet<Symbolizer> symbolizers = new HashSet<Symbolizer>();
        Symbolizer[] symb = rule.getSymbolizers();
        for (int j = 0; j < symb.length; ++j) {
            symbolizers.add(symb[j]);
        }
        if (symbolizers.size() > 0) {
            return SLD.toSymbolizerArray(symbolizers.toArray());
        }
        return new Symbolizer[0];
    }

    public static String[] colors(Style style) {
        HashSet<String> colorSet = new HashSet<String>();
        Rule[] rule = SLD.rules(style);
        for (int i = 0; i < rule.length; ++i) {
            String[] color = SLD.colors(rule[i]);
            for (int j = 0; j < color.length; ++j) {
                colorSet.add(color[j]);
            }
        }
        if (colorSet.size() > 0) {
            return SLD.toStringArray(colorSet.toArray());
        }
        return new String[0];
    }

    public static String[] colors(Rule rule) {
        HashSet<String> colorSet = new HashSet<String>();
        Symbolizer[] symbolizer = rule.getSymbolizers();
        for (int i = 0; i < symbolizer.length; ++i) {
            Symbolizer symb;
            if (symbolizer[i] instanceof PolygonSymbolizer) {
                symb = (PolygonSymbolizer)symbolizer[i];
                colorSet.add(symb.getFill().getColor().toString());
                continue;
            }
            if (symbolizer[i] instanceof LineSymbolizer) {
                symb = (LineSymbolizer)symbolizer[i];
                colorSet.add(symb.getStroke().getColor().toString());
                continue;
            }
            if (!(symbolizer[i] instanceof PointSymbolizer)) continue;
            symb = (PointSymbolizer)symbolizer[i];
            colorSet.add(symb.getGraphic().getMarks()[0].getFill().getColor().toString());
        }
        if (colorSet.size() > 0) {
            return SLD.toStringArray(colorSet.toArray());
        }
        return new String[0];
    }

    private static String[] toStringArray(Object[] object) {
        String[] result = new String[object.length];
        for (int i = 0; i < object.length; ++i) {
            result[i] = (String)object[i];
        }
        return result;
    }

    private static Rule[] toRuleArray(Object[] object) {
        Rule[] result = new Rule[object.length];
        for (int i = 0; i < object.length; ++i) {
            result[i] = (Rule)object[i];
        }
        return result;
    }

    private static Symbolizer[] toSymbolizerArray(Object[] object) {
        Symbolizer[] result = new Symbolizer[object.length];
        for (int i = 0; i < object.length; ++i) {
            result[i] = (Symbolizer)object[i];
        }
        return result;
    }

    public static String toHTMLColor(Color color) {
        String red = "0" + Integer.toHexString(color.getRed());
        red = red.substring(red.length() - 2);
        String grn = "0" + Integer.toHexString(color.getGreen());
        grn = grn.substring(grn.length() - 2);
        String blu = "0" + Integer.toHexString(color.getBlue());
        blu = blu.substring(blu.length() - 2);
        return ("#" + red + grn + blu).toUpperCase();
    }

    public static Color toColor(String htmlColor) {
        return new Color(Integer.parseInt(htmlColor.substring(1), 16));
    }

    public static Font font(TextSymbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        Font[] font = symbolizer.getFonts();
        if (font == null || font[0] == null) {
            return null;
        }
        return font[0];
    }

    public static Style getDefaultStyle(StyledLayerDescriptor sld) {
        Style[] styles = SLD.styles(sld);
        for (int i = 0; i < styles.length; ++i) {
            if (!styles[i].isDefault()) continue;
            return styles[i];
        }
        return styles[0];
    }

    public static boolean isSemanticTypeMatch(FeatureTypeStyle fts, String regex) {
        String[] identifiers = fts.getSemanticTypeIdentifiers();
        for (int i = 0; i < identifiers.length; ++i) {
            if (!identifiers[i].matches(regex)) continue;
            return true;
        }
        return false;
    }

    public static double minScale(FeatureTypeStyle fts) {
        if (fts == null || fts.getRules().length == 0) {
            return 0.0;
        }
        Rule r = fts.getRules()[0];
        return r.getMinScaleDenominator();
    }

    public static double maxScale(FeatureTypeStyle fts) {
        if (fts == null || fts.getRules().length == 0) {
            return Double.NaN;
        }
        Rule r = fts.getRules()[0];
        return r.getMaxScaleDenominator();
    }

    public static PointPlacement getPlacement(double horizAlign, double vertAlign, double rotation) {
        return builder.createPointPlacement(horizAlign, vertAlign, rotation);
    }
}

