/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.ChannelSelectionImpl;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapImpl;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.ContrastEnhancementImpl;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.OverlapBehavior;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.ShadedRelief;
import org.geotools.styling.ShadedReliefImpl;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.Symbolizer;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;

public class RasterSymbolizerImpl
implements RasterSymbolizer {
    private FilterFactory filterFactory;
    private ChannelSelection channelSelection = new ChannelSelectionImpl();
    private ColorMap colorMap = new ColorMapImpl();
    private ContrastEnhancement contrastEnhancement = new ContrastEnhancementImpl();
    private ShadedRelief shadedRelief = new ShadedReliefImpl();
    private String geometryName = "raster";
    private Symbolizer symbolizer;
    private Expression opacity;
    private Expression overlap;

    public RasterSymbolizerImpl() {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
    }

    public RasterSymbolizerImpl(FilterFactory factory) {
        this.filterFactory = factory;
        this.opacity = this.filterFactory.literal(1.0);
        this.overlap = this.filterFactory.literal((Object)OverlapBehavior.RANDOM);
    }

    public int hashcode() {
        int key = 0;
        key = this.channelSelection.hashCode();
        key = key * 13 + this.colorMap.hashCode();
        key = key * 13 + this.contrastEnhancement.hashCode();
        key = key * 13 + this.shadedRelief.hashCode();
        key = key * 13 + this.opacity.hashCode();
        key = key * 13 + this.overlap.hashCode();
        key = key * 13 + this.geometryName.hashCode();
        return key;
    }

    public ChannelSelection getChannelSelection() {
        return this.channelSelection;
    }

    public ColorMap getColorMap() {
        return this.colorMap;
    }

    public ContrastEnhancement getContrastEnhancement() {
        return this.contrastEnhancement;
    }

    public String getGeometryPropertyName() {
        return this.geometryName;
    }

    public Symbolizer getImageOutline() {
        return this.symbolizer;
    }

    public Expression getOpacity() {
        return this.opacity;
    }

    public Expression getOverlap() {
        return this.overlap;
    }

    public ShadedRelief getShadedRelief() {
        return this.shadedRelief;
    }

    public void setChannelSelection(ChannelSelection channel) {
        if (this.channelSelection == channel) {
            return;
        }
        this.channelSelection = channel;
    }

    public void setColorMap(ColorMap colorMap) {
        if (this.colorMap == colorMap) {
            return;
        }
        this.colorMap = colorMap;
    }

    public void setContrastEnhancement(ContrastEnhancement contrastEnhancement) {
        if (this.contrastEnhancement == contrastEnhancement) {
            return;
        }
        this.contrastEnhancement = contrastEnhancement;
    }

    public void setGeometryPropertyName(String geometryName) {
        if (this.geometryName == geometryName) {
            return;
        }
        this.geometryName = geometryName;
    }

    public void setImageOutline(Symbolizer symbolizer) {
        if (symbolizer == null) {
            this.symbolizer = null;
        } else if (symbolizer instanceof LineSymbolizer || symbolizer instanceof PolygonSymbolizer) {
            if (this.symbolizer == symbolizer) {
                return;
            }
            this.symbolizer = symbolizer;
        } else {
            throw new IllegalArgumentException("Only a line or polygon symbolizer may be used to outline a raster");
        }
    }

    public void setOpacity(Expression opacity) {
        if (this.opacity == opacity) {
            return;
        }
        this.opacity = opacity;
    }

    public void setOverlap(Expression overlap) {
        if (this.overlap == overlap) {
            return;
        }
        this.overlap = overlap;
    }

    public void setShadedRelief(ShadedRelief shadedRelief) {
        if (this.shadedRelief == shadedRelief) {
            return;
        }
        this.shadedRelief = shadedRelief;
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        Object clone;
        try {
            clone = super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return clone;
    }
}

