/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import java.util.ArrayList;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.Or;

public class SimplifyingFilterVisitor
extends DuplicatingFilterVisitor {
    public Object visit(And filter, Object extraData) {
        ArrayList<Filter> newChildren = new ArrayList<Filter>(filter.getChildren().size());
        for (Filter child : filter.getChildren()) {
            Filter cloned = (Filter)child.accept((FilterVisitor)this, extraData);
            if (cloned == Filter.EXCLUDE) {
                return Filter.EXCLUDE;
            }
            if (cloned == Filter.INCLUDE) continue;
            newChildren.add(cloned);
        }
        if (newChildren.size() == 0) {
            return Filter.INCLUDE;
        }
        if (newChildren.size() == 1) {
            return newChildren.get(0);
        }
        return this.getFactory(extraData).and(newChildren);
    }

    public Object visit(Or filter, Object extraData) {
        ArrayList<Filter> newChildren = new ArrayList<Filter>(filter.getChildren().size());
        for (Filter child : filter.getChildren()) {
            Filter cloned = (Filter)child.accept((FilterVisitor)this, extraData);
            if (cloned == Filter.INCLUDE) {
                return Filter.INCLUDE;
            }
            if (cloned == Filter.EXCLUDE) continue;
            newChildren.add(cloned);
        }
        if (newChildren.size() == 0) {
            return Filter.EXCLUDE;
        }
        if (newChildren.size() == 1) {
            return newChildren.get(0);
        }
        return this.getFactory(extraData).or(newChildren);
    }

    public Object visit(Id filter, Object extraData) {
        if (filter.getIDs().size() == 0) {
            return Filter.EXCLUDE;
        }
        return super.visit(filter, extraData);
    }
}

