/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.resources.Classes;
import org.geotools.resources.Utilities;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyType;
import org.opengis.filter.Filter;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyTypeImpl
implements PropertyType {
    private static final List<Filter> NO_RESTRICTIONS = Collections.emptyList();
    protected final Name name;
    protected final Class<?> binding;
    protected final boolean isAbstract;
    protected final PropertyType superType;
    protected final List<Filter> restrictions;
    protected final InternationalString description;
    protected final Map<Object, Object> userData;

    public PropertyTypeImpl(Name name, Class<?> binding, boolean isAbstract, List<Filter> restrictions, PropertyType superType, InternationalString description) {
        if (name == null) {
            throw new NullPointerException("Name is required for PropertyType");
        }
        if (binding == null) {
            if (superType != null && superType.getBinding() != null) {
                throw new NullPointerException("Binding to a Java class, did you mean to bind to " + superType.getBinding());
            }
            throw new NullPointerException("Binding to a Java class is required");
        }
        this.name = name;
        this.binding = binding;
        this.isAbstract = isAbstract;
        this.restrictions = restrictions == null ? NO_RESTRICTIONS : Collections.unmodifiableList(restrictions);
        this.superType = superType;
        this.description = description;
        this.userData = new HashMap<Object, Object>();
    }

    public Name getName() {
        return this.name;
    }

    public Class<?> getBinding() {
        return this.binding;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public List<Filter> getRestrictions() {
        return this.restrictions;
    }

    public PropertyType getSuper() {
        return this.superType;
    }

    public InternationalString getDescription() {
        return this.description;
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.getBinding().hashCode() ^ (this.getDescription() != null ? this.getDescription().hashCode() : 17);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PropertyType)) {
            return false;
        }
        PropertyType prop = (PropertyType)other;
        if (!Utilities.equals((Object)this.name, (Object)prop.getName())) {
            return false;
        }
        if (!Utilities.equals(this.binding, (Object)prop.getBinding())) {
            return false;
        }
        if (this.isAbstract != prop.isAbstract()) {
            return false;
        }
        if (!this.equals(this.getRestrictions(), prop.getRestrictions())) {
            return false;
        }
        if (!Utilities.equals((Object)this.superType, (Object)prop.getSuper())) {
            return false;
        }
        return Utilities.equals((Object)this.description, (Object)prop.getDescription());
    }

    private boolean equals(List object1, List object2) {
        if (object1 == object2 || object1 != null && ((Object)object1).equals(object2)) {
            return true;
        }
        if (object1 == null && object2.size() == 0) {
            return true;
        }
        return object2 == null && object1.size() == 0;
    }

    public Map<Object, Object> getUserData() {
        return this.userData;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(Classes.getShortClassName((Object)this));
        sb.append(" ");
        sb.append(this.getName());
        if (this.isAbstract()) {
            sb.append(" abstract");
        }
        if (this.superType != null) {
            sb.append(" extends ");
            sb.append(this.superType.getName().getLocalPart());
        }
        if (this.binding != null) {
            sb.append("<");
            sb.append(Classes.getShortName(this.binding));
            sb.append(">");
        }
        if (this.description != null) {
            sb.append("\n\tdescription=");
            sb.append((CharSequence)this.description);
        }
        if (this.restrictions != null && !this.restrictions.isEmpty()) {
            sb.append("\nrestrictions=");
            boolean first = true;
            for (Filter filter : this.restrictions) {
                if (first) {
                    first = false;
                } else {
                    sb.append(" AND ");
                }
                sb.append(filter);
            }
        }
        return sb.toString();
    }
}

