/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import thredds.catalog.DataFormatType;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvDocumentation;
import thredds.catalog.InvMetadata;
import thredds.catalog.InvProperty;
import thredds.catalog.parser.jdom.InvCatalogFactory10;
import ucar.nc2.Attribute;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.units.SimpleUnit;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public class ThreddsMetadata {
    protected boolean inherited;
    protected List<Source> creators = new ArrayList<Source>();
    protected List<Contributor> contributors = new ArrayList<Contributor>();
    protected List<DateType> dates = new ArrayList<DateType>();
    protected List<InvDocumentation> docs = new ArrayList<InvDocumentation>();
    protected List<Vocab> keywords = new ArrayList<Vocab>();
    protected List<InvMetadata> metadata = new ArrayList<InvMetadata>();
    protected List<Vocab> projects = new ArrayList<Vocab>();
    protected List<InvProperty> properties = new ArrayList<InvProperty>();
    protected List<Source> publishers = new ArrayList<Source>();
    protected List<Variables> variables = new ArrayList<Variables>();
    protected GeospatialCoverage gc;
    protected DateRange timeCoverage;
    protected String authorityName;
    protected String serviceName;
    protected FeatureType dataType;
    protected DataFormatType dataFormat;
    protected double dataSize = 0.0;
    private volatile int hashCode = 0;

    public ThreddsMetadata(boolean inherited) {
        this.inherited = inherited;
    }

    public ThreddsMetadata(ThreddsMetadata from) {
        this.inherited = from.inherited;
        this.add(from, true);
    }

    public void add(ThreddsMetadata tmd, boolean includeInherited) {
        this.creators.addAll(tmd.getCreators());
        this.contributors.addAll(tmd.getContributors());
        this.dates.addAll(tmd.getDates());
        this.docs.addAll(tmd.getDocumentation());
        this.keywords.addAll(tmd.getKeywords());
        this.projects.addAll(tmd.getProjects());
        this.properties.addAll(tmd.getProperties());
        this.publishers.addAll(tmd.getPublishers());
        this.variables.addAll(tmd.getVariables());
        if (includeInherited) {
            this.metadata.addAll(tmd.getMetadata());
        } else {
            for (InvMetadata mdata : tmd.getMetadata()) {
                if (mdata.isInherited()) continue;
                this.metadata.add(mdata);
            }
        }
        if (this.gc == null) {
            this.gc = tmd.getGeospatialCoverage();
        }
        if (this.timeCoverage == null) {
            this.timeCoverage = tmd.getTimeCoverage();
        }
        if (this.serviceName == null) {
            this.serviceName = tmd.getServiceName();
        }
        if (this.dataType == null) {
            this.dataType = tmd.getDataType();
        }
        if (this.dataSize == 0.0) {
            this.dataSize = tmd.getDataSize();
        }
        if (this.dataFormat == null) {
            this.dataFormat = tmd.getDataFormatType();
        }
        if (this.authorityName == null) {
            this.authorityName = tmd.getAuthority();
        }
    }

    public void addCreator(Source c) {
        if (c != null) {
            this.creators.add(c);
        }
    }

    public List<Source> getCreators() {
        return this.creators;
    }

    public void setCreators(List<Source> creators) {
        this.creators = creators;
    }

    public void addContributor(Contributor c) {
        if (c != null) {
            this.contributors.add(c);
        }
    }

    public List<Contributor> getContributors() {
        return this.contributors;
    }

    public void setContributors(List<Contributor> contributors) {
        this.contributors = contributors;
    }

    public void addDate(DateType d) {
        if (d != null) {
            this.dates.add(d);
        }
    }

    public List<DateType> getDates() {
        return this.dates;
    }

    public void addDocumentation(InvDocumentation d) {
        if (d != null) {
            this.docs.add(d);
        }
    }

    public List<InvDocumentation> getDocumentation() {
        return this.docs;
    }

    public void addKeyword(Vocab keyword) {
        if (keyword != null) {
            this.keywords.add(keyword);
        }
    }

    public List<Vocab> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(List<Vocab> keywords) {
        this.keywords = keywords;
    }

    public void addMetadata(InvMetadata m) {
        if (m != null) {
            this.metadata.add(m);
        }
    }

    public void removeMetadata(InvMetadata m) {
        this.metadata.remove(m);
    }

    public List<InvMetadata> getMetadata() {
        return this.metadata;
    }

    public void addProject(Vocab project) {
        if (project != null) {
            this.projects.add(project);
        }
    }

    public List<Vocab> getProjects() {
        return this.projects;
    }

    public void setProjects(List<Vocab> projects) {
        this.projects = projects;
    }

    public void addProperty(InvProperty p) {
        if (p != null) {
            this.properties.add(p);
        }
    }

    public List<InvProperty> getProperties() {
        return this.properties;
    }

    public void addPublisher(Source p) {
        if (p != null) {
            this.publishers.add(p);
        }
    }

    public List<Source> getPublishers() {
        return this.publishers;
    }

    public void setPublishers(List<Source> publishers) {
        this.publishers = publishers;
    }

    public void addVariables(Variables vs) {
        if (vs != null) {
            this.variables.add(vs);
        }
    }

    public List<Variables> getVariables() {
        return this.variables;
    }

    public void setGeospatialCoverage(GeospatialCoverage gc) {
        this.gc = gc;
    }

    public GeospatialCoverage getGeospatialCoverage() {
        return this.gc;
    }

    public void setTimeCoverage(DateRange tc) {
        this.timeCoverage = tc;
    }

    public DateRange getTimeCoverage() {
        return this.timeCoverage;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public void setInherited(boolean inherited) {
        this.inherited = inherited;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public FeatureType getDataType() {
        return this.dataType;
    }

    public void setDataType(FeatureType dataType) {
        this.dataType = dataType;
    }

    public DataFormatType getDataFormatType() {
        return this.dataFormat;
    }

    public void setDataFormatType(DataFormatType dataFormat) {
        this.dataFormat = dataFormat;
    }

    public String getAuthority() {
        return this.authorityName;
    }

    public void setAuthority(String authorityName) {
        this.authorityName = authorityName;
    }

    public String getDocumentation(String type) {
        for (InvDocumentation doc : this.getDocumentation()) {
            String dtype = doc.getType();
            if (dtype == null || !dtype.equalsIgnoreCase(type)) continue;
            return doc.getInlineContent();
        }
        return null;
    }

    public String getHistory() {
        return this.getDocumentation("history");
    }

    public void setHistory(String history) {
        this.addDocumentation("history", history);
    }

    public String getProcessing() {
        return this.getDocumentation("processing_level");
    }

    public void setProcessing(String processing) {
        this.addDocumentation("processing_level", processing);
    }

    public String getRights() {
        return this.getDocumentation("rights");
    }

    public void setRights(String rights) {
        this.addDocumentation("rights", rights);
    }

    public String getSummary() {
        return this.getDocumentation("summary");
    }

    public void setSummary(String summary) {
        this.addDocumentation("summary", summary);
    }

    public double getDataSize() {
        return this.dataSize;
    }

    public void setDataSize(double size) {
        this.dataSize = size;
    }

    public boolean hasDataSize() {
        return this.dataSize != 0.0 && !Double.isNaN(this.dataSize);
    }

    public void addDocumentation(String type, String content) {
        if (content == null) {
            this.removeDocumentation(type);
            return;
        }
        content = content.trim();
        for (InvDocumentation doc : this.getDocumentation()) {
            String dtype = doc.getType();
            if (dtype == null || !dtype.equalsIgnoreCase(type)) continue;
            doc.setInlineContent(content);
            return;
        }
        if (content.length() > 0) {
            this.addDocumentation(new InvDocumentation(null, null, null, type, content));
        }
    }

    public void removeDocumentation(String type) {
        Iterator<InvDocumentation> iter = this.docs.iterator();
        while (iter.hasNext()) {
            InvDocumentation doc = iter.next();
            String dtype = doc.getType();
            if (dtype == null || !dtype.equalsIgnoreCase(type)) continue;
            iter.remove();
        }
    }

    String dump(int n) {
        String indent;
        StringBuilder buff = new StringBuilder(100);
        if (this.docs.size() > 0) {
            indent = InvDatasetImpl.indent(n + 2);
            buff.append(indent);
            buff.append("Docs:\n");
            for (InvDocumentation doc : this.docs) {
                buff.append(InvDatasetImpl.indent(n + 4)).append(doc).append("\n");
            }
        }
        if (this.metadata.size() > 0) {
            indent = InvDatasetImpl.indent(n + 2);
            buff.append(indent);
            buff.append("Metadata:\n");
            for (InvMetadata m : this.metadata) {
                buff.append(InvDatasetImpl.indent(n + 4)).append(m).append("\n");
            }
        }
        if (this.properties.size() > 0) {
            indent = InvDatasetImpl.indent(n + 2);
            buff.append(indent);
            buff.append("Properties:\n");
            for (InvProperty p : this.properties) {
                buff.append(InvDatasetImpl.indent(n + 4)).append(p).append("\n");
            }
        }
        return buff.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ThreddsMetadata)) {
            return false;
        }
        return o.hashCode() == this.hashCode();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + (this.inherited ? 1 : 0);
            result = 29 * result + (this.creators != null ? this.creators.hashCode() : 0);
            result = 29 * result + (this.contributors != null ? this.contributors.hashCode() : 0);
            result = 29 * result + (this.dates != null ? this.dates.hashCode() : 0);
            result = 29 * result + (this.docs != null ? this.docs.hashCode() : 0);
            result = 29 * result + (this.keywords != null ? this.keywords.hashCode() : 0);
            result = 29 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
            result = 29 * result + (this.projects != null ? this.projects.hashCode() : 0);
            result = 29 * result + (this.properties != null ? this.properties.hashCode() : 0);
            result = 29 * result + (this.publishers != null ? this.publishers.hashCode() : 0);
            result = 29 * result + (this.variables != null ? this.variables.hashCode() : 0);
            result = 29 * result + (this.gc != null ? this.gc.hashCode() : 0);
            result = 29 * result + (this.timeCoverage != null ? this.timeCoverage.hashCode() : 0);
            result = 29 * result + (this.authorityName != null ? this.authorityName.hashCode() : 0);
            result = 29 * result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
            result = 29 * result + (this.dataType != null ? this.dataType.hashCode() : 0);
            result = 29 * result + (this.dataFormat != null ? this.dataFormat.hashCode() : 0);
            long temp = this.dataSize != 0.0 ? Double.doubleToLongBits(this.dataSize) : 0L;
            this.hashCode = result = 29 * result + (int)(temp ^ temp >>> 32);
        }
        return this.hashCode;
    }

    public static void main(String[] args) throws IOException {
        GeospatialCoverage gc = new GeospatialCoverage();
        LatLonRect bb = new LatLonRect();
        gc.setBoundingBox(bb);
        gc.toXML(System.out);
    }

    public static class Variables {
        private String vocabulary;
        private String vocabHref;
        private String mapHref;
        private URI vocabUri;
        private URI mapUri;
        private List<Variable> variables = new ArrayList<Variable>();
        private boolean isInit = false;
        private volatile int hashCode = 0;

        public Variables(String vocab) {
            this.vocabulary = vocab;
        }

        public Variables(String vocab, String vocabHref, URI vocabUri, String mapHref, URI mapUri) {
            this.vocabulary = vocab;
            this.vocabHref = vocabHref;
            this.vocabUri = vocabUri;
            this.mapHref = mapHref;
            this.mapUri = mapUri;
        }

        public String getVocabulary() {
            return this.vocabulary;
        }

        public String getVocabHref() {
            return this.vocabHref;
        }

        public URI getVocabUri() {
            return this.vocabUri;
        }

        public URI getMapUri() {
            return this.mapUri;
        }

        public String getMapHref() {
            return this.mapHref;
        }

        public void addVariable(Variable v) {
            this.variables.add(v);
        }

        public List<Variable> getVariableList() {
            this.init();
            return this.variables;
        }

        public void sort() {
            Collections.sort(this.variables);
        }

        private void init() {
            if (this.isInit || this.mapUri != null) {
                return;
            }
            this.isInit = true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Variables)) {
                return false;
            }
            return o.hashCode() == this.hashCode();
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = 17;
                if (null != this.getVocabulary()) {
                    result = 37 * result + this.getVocabulary().hashCode();
                }
                if (null != this.getVocabUri()) {
                    result = 37 * result + this.getVocabUri().hashCode();
                }
                if (null != this.getMapUri()) {
                    result = 37 * result + this.getMapUri().hashCode();
                }
                if (null != this.getVariableList()) {
                    result = 37 * result + this.getVariableList().hashCode();
                }
                this.hashCode = result;
            }
            return this.hashCode;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Variables");
            sb.append(" [").append(this.getVocabulary() != null ? this.getVocabulary() : "").append("]");
            if (this.mapUri != null) {
                sb.append("map [").append(this.mapUri.toString()).append("]");
            } else {
                for (Variable v : this.variables) {
                    sb.append(" ").append(v.toString());
                }
            }
            return sb.toString();
        }
    }

    public static class Variable
    implements Comparable {
        private String name;
        private String desc;
        private String vocabulary_name;
        private String units;
        private String id;
        private volatile int hashCode = 0;

        public Variable() {
            this.name = "";
            this.desc = "";
            this.vocabulary_name = "";
            this.units = "";
            this.id = "";
        }

        public Variable(String name, String desc, String vocabulary_name, String units, String id) {
            this.name = name;
            this.desc = desc;
            this.vocabulary_name = vocabulary_name;
            this.units = units;
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.desc;
        }

        public void setDescription(String desc) {
            this.desc = desc;
        }

        public String getVocabularyName() {
            return this.vocabulary_name;
        }

        public void setVocabularyName(String vocabulary_name) {
            this.vocabulary_name = vocabulary_name;
        }

        public String getVocabularyId() {
            return this.id;
        }

        public void setVocabularyId(String id) {
            this.id = id;
        }

        public void setVocabularyId(Attribute id) {
            if (id == null) {
                return;
            }
            StringBuilder sbuff = new StringBuilder();
            for (int i = 0; i < id.getLength(); ++i) {
                if (i > 0) {
                    sbuff.append(",");
                }
                sbuff.append(id.getNumericValue(i));
            }
            this.id = sbuff.toString();
        }

        public String getUnits() {
            return this.units;
        }

        public void setUnits(String units) {
            this.units = units;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Variable)) {
                return false;
            }
            return o.hashCode() == this.hashCode();
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = 17;
                if (null != this.getName()) {
                    result = 37 * result + this.getName().hashCode();
                }
                if (null != this.getDescription()) {
                    result = 37 * result + this.getDescription().hashCode();
                }
                if (null != this.getVocabularyName()) {
                    result = 37 * result + this.getVocabularyName().hashCode();
                }
                if (null != this.getUnits()) {
                    result = 37 * result + this.getUnits().hashCode();
                }
                this.hashCode = result;
            }
            return this.hashCode;
        }

        public String toString() {
            return "Variable [" + this.name + "]";
        }

        public int compareTo(Object o) {
            Variable ov = (Variable)o;
            return this.name.compareTo(ov.name);
        }

        public static String hiddenProperties() {
            return "nameVocab";
        }

        public static String editableProperties() {
            return "name description units vocabularyName";
        }
    }

    public static class Range {
        private double start;
        private double size;
        private double resolution;
        private String units;
        private volatile int hashCode = 0;

        public Range(double start, double size, double resolution, String units) {
            this.start = start;
            this.size = size;
            this.resolution = resolution;
            this.units = units;
        }

        public Range(Range from) {
            this.start = from.start;
            this.size = from.size;
            this.resolution = from.resolution;
            this.units = from.units;
        }

        public double getStart() {
            return this.start;
        }

        public double getSize() {
            return this.size;
        }

        public double getResolution() {
            return this.resolution;
        }

        public String getUnits() {
            return this.units;
        }

        public boolean hasResolution() {
            return this.resolution != 0.0 && !Double.isNaN(this.resolution);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Range)) {
                return false;
            }
            return o.hashCode() == this.hashCode();
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = 17;
                if (null != this.getUnits()) {
                    result = 37 * result + this.getUnits().hashCode();
                }
                result = 37 * result + (int)(this.getStart() * 1000.0);
                result = 37 * result + (int)(this.getSize() * 1000.0);
                if (this.hasResolution()) {
                    result = 37 * result + (int)(this.getResolution() * 1000.0);
                }
                this.hashCode = result;
            }
            return this.hashCode;
        }
    }

    public static class GeospatialCoverage {
        private static Range defaultEastwest = new Range(0.0, 0.0, Double.NaN, "degrees_east");
        private static Range defaultNorthsouth = new Range(0.0, 0.0, Double.NaN, "degrees_north");
        private static Range defaultUpdown = new Range(0.0, 0.0, Double.NaN, "km");
        private static GeospatialCoverage empty = new GeospatialCoverage();
        private Range eastwest;
        private Range northsouth;
        private Range updown;
        private boolean isGlobal = false;
        private String zpositive = "up";
        private List<Vocab> names = new ArrayList<Vocab>();
        private volatile int hashCode = 0;

        public GeospatialCoverage() {
        }

        public GeospatialCoverage(Range eastwest, Range northsouth, Range updown, List<Vocab> names, String zpositive) {
            this.eastwest = eastwest;
            this.northsouth = northsouth;
            this.updown = updown;
            if (names != null) {
                this.names = new ArrayList<Vocab>(names);
            }
            if (zpositive != null) {
                this.zpositive = zpositive;
            }
            if (names != null) {
                for (Vocab name : names) {
                    String elem = name.getText();
                    if (!elem.equalsIgnoreCase("global")) continue;
                    this.isGlobal = true;
                }
            }
        }

        public boolean isEmpty() {
            return this.equals(empty);
        }

        public Range getEastWestRange() {
            return this.eastwest;
        }

        public Range getNorthSouthRange() {
            return this.northsouth;
        }

        public Range getUpDownRange() {
            return this.updown;
        }

        public List<Vocab> getNames() {
            return this.names;
        }

        public String getZPositive() {
            return this.zpositive;
        }

        public void setZPositive(String positive) {
            this.zpositive = positive;
            this.hashCode = 0;
        }

        public boolean getZPositiveUp() {
            return this.zpositive.equalsIgnoreCase("up");
        }

        public void setZPositiveUp(boolean positive) {
            this.zpositive = positive ? "up" : "down";
            this.hashCode = 0;
        }

        public boolean isValid() {
            return this.isGlobal || this.eastwest != null && this.northsouth != null;
        }

        public boolean isGlobal() {
            return this.isGlobal;
        }

        public void setGlobal(boolean isGlobal) {
            this.isGlobal = isGlobal;
            this.hashCode = 0;
        }

        public double getLatStart() {
            return this.northsouth == null ? Double.NaN : this.northsouth.start;
        }

        public void setLatStart(double start) {
            if (this.northsouth == null) {
                this.northsouth = new Range(defaultNorthsouth);
            }
            this.northsouth.start = start;
            this.hashCode = 0;
        }

        public double getLatExtent() {
            return this.northsouth == null ? Double.NaN : this.northsouth.size;
        }

        public void setLatExtent(double size) {
            if (this.northsouth == null) {
                this.northsouth = new Range(defaultNorthsouth);
            }
            this.northsouth.size = size;
            this.hashCode = 0;
        }

        public double getLatResolution() {
            return this.northsouth == null ? Double.NaN : this.northsouth.resolution;
        }

        public void setLatResolution(double resolution) {
            if (this.northsouth == null) {
                this.northsouth = new Range(defaultNorthsouth);
            }
            this.northsouth.resolution = resolution;
            this.hashCode = 0;
        }

        public String getLatUnits() {
            return this.northsouth == null ? null : this.northsouth.units;
        }

        public void setLatUnits(String units) {
            if (this.northsouth == null) {
                this.northsouth = new Range(defaultNorthsouth);
            }
            this.northsouth.units = units;
            this.hashCode = 0;
        }

        public double getLatNorth() {
            return Math.max(this.northsouth.start, this.northsouth.start + this.northsouth.size);
        }

        public double getLatSouth() {
            return Math.min(this.northsouth.start, this.northsouth.start + this.northsouth.size);
        }

        public double getLonStart() {
            return this.eastwest == null ? Double.NaN : this.eastwest.start;
        }

        public void setLonStart(double start) {
            if (this.eastwest == null) {
                this.eastwest = new Range(defaultEastwest);
            }
            this.eastwest.start = start;
            this.hashCode = 0;
        }

        public double getLonExtent() {
            return this.eastwest == null ? Double.NaN : this.eastwest.size;
        }

        public void setLonExtent(double size) {
            if (this.eastwest == null) {
                this.eastwest = new Range(defaultEastwest);
            }
            this.eastwest.size = size;
            this.hashCode = 0;
        }

        public double getLonResolution() {
            return this.eastwest == null ? Double.NaN : this.eastwest.resolution;
        }

        public void setLonResolution(double resolution) {
            if (this.eastwest == null) {
                this.eastwest = new Range(defaultEastwest);
            }
            this.eastwest.resolution = resolution;
            this.hashCode = 0;
        }

        public String getLonUnits() {
            return this.eastwest == null ? null : this.eastwest.units;
        }

        public void setLonUnits(String units) {
            if (this.eastwest == null) {
                this.eastwest = new Range(defaultEastwest);
            }
            this.eastwest.units = units;
            this.hashCode = 0;
        }

        public double getLonEast() {
            if (this.eastwest == null) {
                return Double.NaN;
            }
            return Math.max(this.eastwest.start, this.eastwest.start + this.eastwest.size);
        }

        public double getLonWest() {
            if (this.eastwest == null) {
                return Double.NaN;
            }
            return Math.min(this.eastwest.start, this.eastwest.start + this.eastwest.size);
        }

        public double getHeightStart() {
            return this.updown == null ? 0.0 : this.updown.start;
        }

        public void setHeightStart(double start) {
            if (this.updown == null) {
                this.updown = new Range(defaultUpdown);
            }
            this.updown.start = start;
            this.hashCode = 0;
        }

        public double getHeightExtent() {
            return this.updown == null ? 0.0 : this.updown.size;
        }

        public void setHeightExtent(double size) {
            if (this.updown == null) {
                this.updown = new Range(defaultUpdown);
            }
            this.updown.size = size;
            this.hashCode = 0;
        }

        public double getHeightResolution() {
            return this.updown == null ? 0.0 : this.updown.resolution;
        }

        public void setHeightResolution(double resolution) {
            if (this.updown == null) {
                this.updown = new Range(defaultUpdown);
            }
            this.updown.resolution = resolution;
            this.hashCode = 0;
        }

        public String getHeightUnits() {
            return this.updown == null ? null : this.updown.units;
        }

        public void setHeightUnits(String units) {
            if (this.updown == null) {
                this.updown = new Range(defaultUpdown);
            }
            this.updown.units = units;
            this.hashCode = 0;
        }

        public LatLonRect getBoundingBox() {
            return this.isGlobal ? new LatLonRect() : new LatLonRect(new LatLonPointImpl(this.getLatStart(), this.getLonStart()), this.getLatExtent(), this.getLonExtent());
        }

        public void setBoundingBox(LatLonRect bb) {
            LatLonPointImpl llpt = bb.getLowerLeftPoint();
            LatLonPointImpl urpt = bb.getUpperRightPoint();
            double height = urpt.getLatitude() - llpt.getLatitude();
            this.eastwest = new Range(llpt.getLongitude(), bb.getWidth(), 0.0, "degrees_east");
            this.northsouth = new Range(llpt.getLatitude(), height, 0.0, "degrees_north");
        }

        public void setVertical(CoordinateAxis1D vaxis) {
            int n = (int)vaxis.getSize();
            double size = vaxis.getCoordValue(n - 1) - vaxis.getCoordValue(0);
            double resolution = vaxis.getIncrement();
            String units = vaxis.getUnitsString();
            this.updown = new Range(vaxis.getCoordValue(0), size, resolution, units);
            if (units != null) {
                this.setZPositiveUp(SimpleUnit.isCompatible("m", units));
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GeospatialCoverage)) {
                return false;
            }
            return o.hashCode() == this.hashCode();
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = 17;
                if (null != this.getEastWestRange()) {
                    result = 37 * result + this.getEastWestRange().hashCode();
                }
                if (null != this.getNorthSouthRange()) {
                    result = 37 * result + this.getNorthSouthRange().hashCode();
                }
                if (null != this.getUpDownRange()) {
                    result = 37 * result + this.getUpDownRange().hashCode();
                }
                if (null != this.getNames()) {
                    result = 37 * result + this.getNames().hashCode();
                }
                if (null != this.getZPositive()) {
                    result = 2 * result + this.getZPositive().hashCode();
                }
                this.hashCode = result = 2 * result + (this.isGlobal() ? 1 : 0);
            }
            return this.hashCode;
        }

        public void toXML(OutputStream out) throws IOException {
            InvCatalogFactory10 converter = new InvCatalogFactory10();
            Element elem = converter.writeGeospatialCoverage(this);
            XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
            fmt.output(elem, out);
        }
    }

    public static class Vocab {
        private String text;
        private String vocabulary;
        private volatile int hashCode = 0;

        public Vocab() {
        }

        public Vocab(String text, String vocabulary) {
            this.text = text;
            this.vocabulary = vocabulary;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
            this.hashCode = 0;
        }

        public String getVocabulary() {
            return this.vocabulary;
        }

        public void setVocabulary(String vocabulary) {
            this.vocabulary = vocabulary;
            this.hashCode = 0;
        }

        public static String editableProperties() {
            return "text vocabulary";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Vocab)) {
                return false;
            }
            return o.hashCode() == this.hashCode();
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = 17;
                if (null != this.getText()) {
                    result = 37 * result + this.getText().hashCode();
                }
                if (null != this.getVocabulary()) {
                    result = 37 * result + this.getVocabulary().hashCode();
                }
                this.hashCode = result;
            }
            return this.hashCode;
        }
    }

    public static class Source {
        private Vocab name;
        private Vocab long_name;
        private String url;
        private String email;
        private volatile int hashCode = 0;

        public Source() {
            this.name = new Vocab();
            this.long_name = new Vocab();
        }

        public Source(Vocab name, String url, String email) {
            this.name = name;
            this.url = url;
            this.email = email;
        }

        public Vocab getNameVocab() {
            return this.name;
        }

        public String getName() {
            return this.name.getText();
        }

        public void setName(String name) {
            this.name.setText(name);
            this.hashCode = 0;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
            this.hashCode = 0;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
            this.hashCode = 0;
        }

        public String getVocabulary() {
            return this.name.getVocabulary();
        }

        public void setVocabulary(String vocabulary) {
            this.name.setVocabulary(vocabulary);
            this.long_name.setVocabulary(vocabulary);
            this.hashCode = 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Source)) {
                return false;
            }
            return o.hashCode() == this.hashCode();
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = 17;
                result = 37 * result + this.getName().hashCode();
                if (null != this.getVocabulary()) {
                    result = 37 * result + this.getVocabulary().hashCode();
                }
                if (null != this.getUrl()) {
                    result = 37 * result + this.getUrl().hashCode();
                }
                if (null != this.getEmail()) {
                    result = 37 * result + this.getEmail().hashCode();
                }
                this.hashCode = result;
            }
            return this.hashCode;
        }

        public static String hiddenProperties() {
            return "nameVocab";
        }

        public static String editableProperties() {
            return "name email url vocabulary";
        }
    }

    public static class Contributor {
        private String name;
        private String role;
        private volatile int hashCode = 0;

        public Contributor() {
        }

        public Contributor(String name, String role) {
            this.name = name;
            this.role = role;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            this.hashCode = 0;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
            this.hashCode = 0;
        }

        public static String editableProperties() {
            return "role name";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Contributor)) {
                return false;
            }
            return o.hashCode() == this.hashCode();
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = 17;
                result = 37 * result + this.getName().hashCode();
                if (null != this.getRole()) {
                    result = 37 * result + this.getRole().hashCode();
                }
                this.hashCode = result;
            }
            return this.hashCode;
        }
    }
}

