/*
 * Decompiled with CFR 0.152.
 */
package ccindex.explorer.tree;

import ccindex.explorer.JAMSExplorer;
import ccindex.explorer.tree.DSTreeNode;
import ccindex.explorer.tree.FileObject;
import ccindex.explorer.tree.JAMSTree;
import jams.JAMS;
import jams.gui.WorkerDlg;
import jams.workspace.stores.InputDataStore;
import jams.workspace.stores.J2KTSDataStore;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class DSTree
extends JAMSTree {
    private static final String ROOT_NAME = JAMS.i18n("DATENSPEICHER");
    private static final String INPUT_NAME = JAMS.i18n("EINGABEDATEN");
    private static final String OUTPUT_NAME = JAMS.i18n("AUSGABEDATEN");
    private JPopupMenu popupDS;
    private JPopupMenu popupDir;
    private NodeObservable nodeObservable = new NodeObservable();
    private JAMSExplorer explorer;

    public DSTree(JAMSExplorer explorer) {
        this.explorer = explorer;
        this.setEditable(false);
        JMenuItem detailItem = new JMenuItem(JAMS.i18n("ZEIGE_DATEN"));
        detailItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSTree.this.displayDSData();
            }
        });
        JMenuItem deleteFileItem = new JMenuItem(JAMS.i18n("DELETE"));
        deleteFileItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        deleteFileItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSTree.this.deleteDSFile();
            }
        });
        JMenuItem deleteDirItem = new JMenuItem(JAMS.i18n("DELETE"));
        deleteDirItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        deleteDirItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSTree.this.deleteDSDir();
            }
        });
        this.popupDS = new JPopupMenu();
        this.popupDS.add(detailItem);
        this.popupDS.add(deleteFileItem);
        this.popupDir = new JPopupMenu();
        this.popupDir.add(deleteDirItem);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.getButton() == 3) {
                    DSTree.this.showPopup(evt);
                }
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() >= 2) {
                    DSTree.this.displayDSData();
                }
            }
        });
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (DSTree.this.getSelectionPath() != null) {
                    DSTree.this.nodeObservable.setNode((DSTreeNode)DSTree.this.getLastSelectedPathComponent());
                } else {
                    DSTree.this.nodeObservable.setNode(null);
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 116) {
                    DSTree.this.update();
                }
            }
        });
        this.setVisible(false);
    }

    private DSTreeNode createInputNode() {
        DSTreeNode inputRoot = new DSTreeNode((Object)INPUT_NAME, 1);
        Set<String> inIDs = this.explorer.getWorkspace().getInputDataStoreIDs();
        List<String> inIDList = this.explorer.getWorkspace().getSortedInputDataStoreIDs();
        for (String id : inIDList) {
            DSTreeNode dsNode = new DSTreeNode((Object)id, 3);
            inputRoot.add(dsNode);
        }
        return inputRoot;
    }

    private DSTreeNode createSubOutputNode(TreeMap<String, DSTreeNode> pathNodeMap, File dir) {
        if (dir.isDirectory()) {
            DSTreeNode outputDataStoreNode = new DSTreeNode((Object)new FileObject(dir), 5);
            for (File file : dir.listFiles()) {
                DSTreeNode subNode = this.createSubOutputNode(pathNodeMap, file);
                if (subNode == null) continue;
                outputDataStoreNode.add(subNode);
            }
            return outputDataStoreNode;
        }
        FileObject fileObject = new FileObject(dir);
        if (!fileObject.isValid()) {
            return null;
        }
        FileObject[] subFileObjects = fileObject.getSubDataStores();
        DSTreeNode outputDataStoreNode = null;
        if (subFileObjects.length == 0) {
            outputDataStoreNode = new DSTreeNode((Object)fileObject, 4);
        } else {
            outputDataStoreNode = new DSTreeNode((Object)fileObject, 5);
            for (FileObject subFileObject : subFileObjects) {
                DSTreeNode subOutputDataStoreNode = new DSTreeNode((Object)subFileObject, 4);
                if (subOutputDataStoreNode == null) continue;
                outputDataStoreNode.add(subOutputDataStoreNode);
            }
        }
        return outputDataStoreNode;
    }

    private DSTreeNode createOutputNode() {
        DSTreeNode outputRoot = new DSTreeNode((Object)OUTPUT_NAME, 2);
        File[] outputDirs = this.explorer.getWorkspace().getOutputDataDirectories();
        TreeMap<String, DSTreeNode> pathNodeMap = new TreeMap<String, DSTreeNode>();
        for (File dir : outputDirs) {
            outputRoot.add(this.createSubOutputNode(pathNodeMap, dir));
        }
        return outputRoot;
    }

    private boolean isNodeSuitableForEnsemble(DSTreeNode node) {
        switch (node.getType()) {
            case 5: {
                return false;
            }
            case 3: {
                return false;
            }
        }
        return true;
    }

    private void displayDSData() {
        WorkerDlg dlg = new WorkerDlg((Window)this.explorer.getExplorerFrame(), JAMS.i18n("Opening_Datastore"));
        dlg.setInderminate(true);
        dlg.setModal(false);
        dlg.setTask(new Runnable(){

            @Override
            public void run() {
                DSTree.this.explorer.getDisplayManager().displayDS((DSTreeNode)DSTree.this.getLastSelectedPathComponent());
            }
        });
        dlg.execute();
    }

    private void deleteDSFile() {
        this.explorer.getDisplayManager().deleteDS((DSTreeNode)this.getLastSelectedPathComponent());
    }

    private void deleteDSDir() {
        this.explorer.getDisplayManager().deleteDS((DSTreeNode)this.getLastSelectedPathComponent());
    }

    private void showPopup(MouseEvent evt) {
        TreePath p = this.getClosestPathForLocation(evt.getX(), evt.getY());
        this.setSelectionPath(p);
        DSTreeNode node = (DSTreeNode)this.getLastSelectedPathComponent();
        if (node != null && (node.getType() == 3 || node.getType() == 4)) {
            if (node != null && node.getType() == 3) {
                InputDataStore store = this.explorer.getWorkspace().getInputDataStore(node.toString());
                if (!(store instanceof J2KTSDataStore)) {
                    this.popupDS.show(this, evt.getX(), evt.getY());
                }
            } else {
                this.popupDS.show(this, evt.getX(), evt.getY());
            }
        }
        if (node != null && node.getType() == 5) {
            this.popupDir.show(this, evt.getX(), evt.getY());
        }
    }

    public void update() {
        this.setVisible(false);
        DSTreeNode root = this.createIOTree();
        this.setModel(new DefaultTreeModel(root));
        this.expandAll();
        this.setVisible(true);
    }

    private DSTreeNode createIOTree() {
        DSTreeNode root = new DSTreeNode((Object)ROOT_NAME, 0);
        DSTreeNode inputRoot = this.createInputNode();
        DSTreeNode outputRoot = this.createOutputNode();
        root.add(inputRoot);
        root.add(outputRoot);
        return root;
    }

    public void addObserver(Observer o) {
        this.nodeObservable.addObserver(o);
    }

    private class NodeObservable
    extends Observable {
        DSTreeNode node;

        private NodeObservable() {
        }

        public void setNode(DSTreeNode node) {
            this.node = node;
            this.setChanged();
            this.notifyObservers();
        }

        @Override
        public void notifyObservers(Object arg) {
            super.notifyObservers(this.node);
        }
    }
}

