/*
 * Decompiled with CFR 0.152.
 */
package ccindex.explorer.spreadsheet;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.java2d.ps.EPSDocumentGraphics2D;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;

public class JAMSStackedPlot {
    JFreeChart chart;
    ChartPanel chartpanel;
    String title;

    public JAMSStackedPlot(XYPlot[] xyplots, int[] weights, DateAxis timeAxis, String title) {
        int no_of_plots = xyplots.length;
        this.title = title;
        CombinedDomainXYPlot parentplot = new CombinedDomainXYPlot((ValueAxis)timeAxis);
        parentplot.setGap(10.0);
        for (int i = 0; i < no_of_plots; ++i) {
            parentplot.add(xyplots[i], weights[i]);
        }
        parentplot.setOrientation(PlotOrientation.VERTICAL);
        this.chart = new JFreeChart(this.title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)parentplot, true);
        this.chartpanel = new ChartPanel(this.chart, true, true, true, false, true);
        this.chartpanel.setBackground(Color.WHITE);
    }

    public ChartPanel getChartPanel() {
        return this.chartpanel;
    }

    public void saveAsEPS(File outfile) {
        try {
            FileOutputStream out = new FileOutputStream(outfile);
            EPSDocumentGraphics2D g2d = new EPSDocumentGraphics2D(false);
            g2d.setGraphicContext(new GraphicContext());
            int width = 600;
            int height = 400;
            g2d.setupDocument((OutputStream)out, width, height);
            this.chart.draw((Graphics2D)g2d, (Rectangle2D)new Rectangle(width, height));
            g2d.finish();
            out.flush();
            ((OutputStream)out).close();
        }
        catch (IOException fnfe) {
            fnfe.printStackTrace();
        }
    }

    public void setTitle(String title) {
        this.title = title;
        this.chart.setTitle(title);
    }
}

