/*
 * Decompiled with CFR 0.152.
 */
package ccindex.explorer.gui;

import ccindex.explorer.JAMSExplorer;
import ccindex.explorer.gui.DSPanel;
import ccindex.explorer.gui.EnsembleTimeSeriesPanel;
import ccindex.explorer.gui.SimpleDSPanel;
import ccindex.explorer.gui.TimeSpaceDSPanel;
import ccindex.explorer.spreadsheet.JAMSSpreadSheet;
import jams.JAMSException;
import jams.JAMSLogging;
import jams.workspace.dsproc.AbstractDataStoreProcessor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class OutputDSPanel
extends JPanel {
    private JAMSSpreadSheet spreadsheet;

    public OutputDSPanel(JAMSExplorer explorer, File file, String id) {
        this.setLayout(new BorderLayout());
        JAMSLogging.registerLogger(JAMSLogging.LogOption.Show, Logger.getLogger(OutputDSPanel.class.getName()));
        this.spreadsheet = new JAMSSpreadSheet(explorer);
        this.spreadsheet.init();
        this.spreadsheet.setAsOutputSheet();
        this.spreadsheet.setID(id);
        this.setName(file.getName());
        DSPanel tsp = null;
        switch (AbstractDataStoreProcessor.getDataStoreType(file)) {
            case Unsupported: {
                Logger.getLogger(OutputDSPanel.class.getName()).log(Level.WARNING, "Unsupported datastore");
                break;
            }
            case TimeDataSerie: {
                tsp = new EnsembleTimeSeriesPanel();
                break;
            }
            case SpatioTemporal: {
                tsp = new TimeSpaceDSPanel();
                break;
            }
            case DataSerie1D: {
                tsp = new SimpleDSPanel();
                break;
            }
            case Timeserie: {
                tsp = new SimpleDSPanel();
                break;
            }
            default: {
                Logger.getLogger(OutputDSPanel.class.getName()).log(Level.WARNING, "Unsupported datastore");
            }
        }
        if (tsp == null) {
            throw new JAMSException("Unsupported datastore");
        }
        tsp.setExplorer(explorer);
        tsp.setOutputSpreadSheet(this.spreadsheet);
        tsp.createProc(file);
        JSplitPane split = new JSplitPane(0);
        split.add(tsp);
        split.add(this.spreadsheet);
        split.setDividerLocation(300);
        this.add((Component)split, "Center");
    }

    public JAMSSpreadSheet getSpreadsheet() {
        return this.spreadsheet;
    }
}

