/*
 * Decompiled with CFR 0.152.
 */
package ccindex.explorer.gui;

import ccindex.explorer.gui.CancelableSwingWorker;
import ccindex.explorer.gui.DSPanel;
import jams.JAMS;
import jams.data.Attribute;
import jams.data.JAMSCalendar;
import jams.gui.tools.GUIHelper;
import jams.workspace.dsproc.AbstractDataStoreProcessor;
import jams.workspace.dsproc.DataMatrix;
import jams.workspace.dsproc.DataStoreProcessor;
import jams.workspace.dsproc.EnsembleTimeSeriesProcessor;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class EnsembleTimeSeriesPanel
extends DSPanel {
    private static final Dimension ACTION_BUTTON_DIM = new Dimension(150, 25);
    private static final Dimension LIST_DIMENSION = new Dimension(150, 250);
    private EnsembleTimeSeriesProcessor proc;
    private GridBagLayout mainLayout;
    private JList modelRunList;
    private JList timeList;
    private JList monthList;
    private JList yearList;
    private JTextField timeField;
    private JPanel aggregationPanel;
    private GridBagLayout aggregationLayout;
    private Action[] actions = new Action[]{new AbstractAction(JAMS.i18n("TIME_STEP")){

        @Override
        public void actionPerformed(ActionEvent e) {
            EnsembleTimeSeriesPanel.this.showTimeStep();
        }
    }, new AbstractAction(JAMS.i18n("TEMP._MEAN")){

        @Override
        public void actionPerformed(ActionEvent e) {
            EnsembleTimeSeriesPanel.this.showTempMean();
        }
    }, new AbstractAction(JAMS.i18n("MODEL_RUN")){

        @Override
        public void actionPerformed(ActionEvent e) {
            EnsembleTimeSeriesPanel.this.showModelRun();
        }
    }, new AbstractAction(JAMS.i18n("ENSEMBLE_MEAN")){

        @Override
        public void actionPerformed(ActionEvent e) {
            EnsembleTimeSeriesPanel.this.showModelRun();
        }
    }, new AbstractAction(JAMS.i18n("MONTHLY_MEAN")){

        @Override
        public void actionPerformed(ActionEvent e) {
            EnsembleTimeSeriesPanel.this.showMonthlyMean();
        }
    }, new AbstractAction(JAMS.i18n("YEARLY_MEAN")){

        @Override
        public void actionPerformed(ActionEvent e) {
            EnsembleTimeSeriesPanel.this.showYearlyMean();
        }
    }, new AbstractAction(JAMS.i18n("CROSSPRODUCT")){

        @Override
        public void actionPerformed(ActionEvent e) {
            EnsembleTimeSeriesPanel.this.showCrossProduct();
        }
    }};
    private Action timePoint = this.actions[0];
    private Action timeMean = this.actions[1];
    private Action modelRun = this.actions[2];
    private Action modelRunMean = this.actions[3];
    private Action monthMean = this.actions[4];
    private Action yearMean = this.actions[5];
    private Action crossProduct = this.actions[6];
    private Action cacheReset = new AbstractAction(JAMS.i18n("RESET_CACHES")){

        @Override
        public void actionPerformed(ActionEvent e) {
            EnsembleTimeSeriesPanel.this.resetCaches();
        }
    };
    private Action indexReset = new AbstractAction(JAMS.i18n("RELOAD_INDEX")){

        @Override
        public void actionPerformed(ActionEvent e) {
            EnsembleTimeSeriesPanel.this.resetIndex();
        }
    };
    private Action freeTempMean = new AbstractAction(JAMS.i18n("TEMP._MEAN_(FILTER)")){

        @Override
        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog(EnsembleTimeSeriesPanel.this.parent, JAMS.i18n("ACTION_UNSUPPORTED!"));
        }
    };

    public EnsembleTimeSeriesPanel() {
        this.init();
    }

    private void init() {
        JButton button;
        for (Action a : this.actions) {
            a.setEnabled(false);
        }
        this.freeTempMean.setEnabled(false);
        this.cacheReset.setEnabled(false);
        this.indexReset.setEnabled(false);
        this.mainLayout = new GridBagLayout();
        this.setLayout(this.mainLayout);
        this.modelRunList = new JList();
        JScrollPane modelRunListScroll = new JScrollPane(this.modelRunList);
        modelRunListScroll.setPreferredSize(new Dimension(EnsembleTimeSeriesPanel.LIST_DIMENSION.width - 100, EnsembleTimeSeriesPanel.LIST_DIMENSION.height));
        this.modelRunList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (EnsembleTimeSeriesPanel.this.modelRunList.getSelectedValues().length == 1) {
                        EnsembleTimeSeriesPanel.this.modelRun.setEnabled(true);
                        EnsembleTimeSeriesPanel.this.modelRunMean.setEnabled(false);
                        if (EnsembleTimeSeriesPanel.this.timeList.getSelectedValues().length > 0) {
                            EnsembleTimeSeriesPanel.this.crossProduct.setEnabled(true);
                        }
                    } else if (EnsembleTimeSeriesPanel.this.modelRunList.getSelectedValues().length > 1) {
                        EnsembleTimeSeriesPanel.this.modelRun.setEnabled(false);
                        EnsembleTimeSeriesPanel.this.modelRunMean.setEnabled(true);
                        if (EnsembleTimeSeriesPanel.this.timeList.getSelectedValues().length > 0) {
                            EnsembleTimeSeriesPanel.this.crossProduct.setEnabled(true);
                        }
                    } else {
                        EnsembleTimeSeriesPanel.this.modelRun.setEnabled(false);
                        EnsembleTimeSeriesPanel.this.modelRunMean.setEnabled(false);
                        EnsembleTimeSeriesPanel.this.crossProduct.setEnabled(false);
                    }
                }
            }
        });
        this.timeList = new JList();
        JScrollPane timeListScroll = new JScrollPane(this.timeList);
        timeListScroll.setPreferredSize(LIST_DIMENSION);
        this.timeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (EnsembleTimeSeriesPanel.this.timeList.getSelectedValues().length == 1) {
                        EnsembleTimeSeriesPanel.this.timePoint.setEnabled(true);
                        EnsembleTimeSeriesPanel.this.timeMean.setEnabled(false);
                        if (EnsembleTimeSeriesPanel.this.modelRunList.getSelectedValues().length > 0) {
                            EnsembleTimeSeriesPanel.this.crossProduct.setEnabled(true);
                        }
                    } else if (EnsembleTimeSeriesPanel.this.timeList.getSelectedValues().length > 1) {
                        EnsembleTimeSeriesPanel.this.timePoint.setEnabled(false);
                        EnsembleTimeSeriesPanel.this.timeMean.setEnabled(true);
                        if (EnsembleTimeSeriesPanel.this.modelRunList.getSelectedValues().length > 0) {
                            EnsembleTimeSeriesPanel.this.crossProduct.setEnabled(true);
                        }
                    } else {
                        EnsembleTimeSeriesPanel.this.timePoint.setEnabled(false);
                        EnsembleTimeSeriesPanel.this.timeMean.setEnabled(false);
                        EnsembleTimeSeriesPanel.this.crossProduct.setEnabled(false);
                    }
                }
            }
        });
        this.monthList = new JList();
        this.monthList.setSelectionMode(0);
        JScrollPane monthListScroll = new JScrollPane(this.monthList);
        monthListScroll.setPreferredSize(new Dimension(EnsembleTimeSeriesPanel.LIST_DIMENSION.width - 100, EnsembleTimeSeriesPanel.LIST_DIMENSION.height));
        this.monthList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (EnsembleTimeSeriesPanel.this.monthList.getSelectedValues().length == 1) {
                        EnsembleTimeSeriesPanel.this.monthMean.setEnabled(true);
                    } else {
                        EnsembleTimeSeriesPanel.this.monthMean.setEnabled(false);
                    }
                }
            }
        });
        this.yearList = new JList();
        this.yearList.setSelectionMode(0);
        JScrollPane yearListScroll = new JScrollPane(this.yearList);
        yearListScroll.setPreferredSize(new Dimension(EnsembleTimeSeriesPanel.LIST_DIMENSION.width - 100, EnsembleTimeSeriesPanel.LIST_DIMENSION.height));
        this.yearList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (EnsembleTimeSeriesPanel.this.yearList.getSelectedValues().length == 1) {
                        EnsembleTimeSeriesPanel.this.yearMean.setEnabled(true);
                    } else {
                        EnsembleTimeSeriesPanel.this.yearMean.setEnabled(false);
                    }
                }
            }
        });
        GUIHelper.addGBComponent(this, this.mainLayout, new JLabel(JAMS.i18n("ATTRIBUTE/AGGREGATION:")), 0, 10, 1, 1, 0.0, 0.0);
        this.aggregationLayout = new GridBagLayout();
        this.aggregationPanel = new JPanel();
        this.aggregationPanel.setLayout(this.aggregationLayout);
        JScrollPane aggregationScroll = new JScrollPane(this.aggregationPanel);
        aggregationScroll.setPreferredSize(new Dimension(EnsembleTimeSeriesPanel.LIST_DIMENSION.width + 100, EnsembleTimeSeriesPanel.LIST_DIMENSION.height));
        GUIHelper.addGBComponent(this, this.mainLayout, aggregationScroll, 0, 20, 1, 1, 0.0, 0.0);
        GUIHelper.addGBComponent(this, this.mainLayout, new JLabel(JAMS.i18n("TIME_STEPS:")), 10, 10, 1, 1, 0.0, 0.0);
        GUIHelper.addGBComponent(this, this.mainLayout, timeListScroll, 10, 20, 1, 1, 0.0, 0.0);
        GUIHelper.addGBComponent(this, this.mainLayout, new JLabel(JAMS.i18n("MODEL_RUNS:")), 20, 10, 1, 1, 0.0, 0.0);
        GUIHelper.addGBComponent(this, this.mainLayout, modelRunListScroll, 20, 20, 1, 1, 0.0, 0.0);
        JPanel buttonPanelA = new JPanel();
        buttonPanelA.setPreferredSize(LIST_DIMENSION);
        for (int i = 0; i <= 3; ++i) {
            Action a = this.actions[i];
            button = new JButton(a);
            button.setPreferredSize(ACTION_BUTTON_DIM);
            buttonPanelA.add(button);
        }
        buttonPanelA.add(new JButton(this.crossProduct){
            {
                this.setPreferredSize(ACTION_BUTTON_DIM);
            }
        });
        JPanel filterPanel = new JPanel();
        filterPanel.setPreferredSize(new Dimension(EnsembleTimeSeriesPanel.LIST_DIMENSION.width, EnsembleTimeSeriesPanel.LIST_DIMENSION.height - 150));
        filterPanel.setBorder(BorderFactory.createEtchedBorder());
        filterPanel.add(new JLabel(JAMS.i18n("TIME_FILTER:")));
        this.timeField = new JTextField();
        this.timeField.setEnabled(false);
        this.timeField.setToolTipText(JAMS.i18n("DATE_EXPRESSION_IN_SQL_SYNTAX,_E.G._1992-11-%_FOR_ALL_NOVEMBER_VALUES_IN_1992"));
        this.timeField.setPreferredSize(new Dimension(EnsembleTimeSeriesPanel.ACTION_BUTTON_DIM.width - 20, this.timeField.getPreferredSize().height));
        this.timeField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            private void update() {
                EnsembleTimeSeriesPanel.this.toggleFreeTempMeanButton();
            }
        });
        filterPanel.add(this.timeField);
        button = new JButton(this.freeTempMean);
        button.setPreferredSize(new Dimension(EnsembleTimeSeriesPanel.ACTION_BUTTON_DIM.width - 20, EnsembleTimeSeriesPanel.ACTION_BUTTON_DIM.height));
        filterPanel.add(button);
        buttonPanelA.add(filterPanel);
        GUIHelper.addGBComponent(this, this.mainLayout, buttonPanelA, 40, 20, 1, 1, 0.0, 0.0);
        GUIHelper.addGBComponent(this, this.mainLayout, new JLabel(JAMS.i18n("MONTHS:")), 60, 10, 1, 1, 0.0, 0.0);
        GUIHelper.addGBComponent(this, this.mainLayout, monthListScroll, 60, 20, 1, 1, 0.0, 0.0);
        GUIHelper.addGBComponent(this, this.mainLayout, new JLabel(JAMS.i18n("YEARS:")), 70, 10, 1, 1, 0.0, 0.0);
        GUIHelper.addGBComponent(this, this.mainLayout, yearListScroll, 70, 20, 1, 1, 0.0, 0.0);
        JPanel buttonPanelB = new JPanel();
        buttonPanelB.setPreferredSize(LIST_DIMENSION);
        for (int i = 4; i < this.actions.length - 1; ++i) {
            Action a = this.actions[i];
            button = new JButton(a);
            button.setPreferredSize(ACTION_BUTTON_DIM);
            buttonPanelB.add(button);
        }
        buttonPanelB.add(new JPanel());
        button = new JButton(this.cacheReset);
        button.setPreferredSize(ACTION_BUTTON_DIM);
        buttonPanelB.add(button);
        button = new JButton(this.indexReset);
        button.setPreferredSize(ACTION_BUTTON_DIM);
        buttonPanelB.add(button);
        GUIHelper.addGBComponent(this, this.mainLayout, buttonPanelB, 80, 20, 1, 1, 0.0, 0.0);
    }

    public EnsembleTimeSeriesProcessor getProc() {
        return this.proc;
    }

    private void createDB() {
        this.workerDlg.setInderminate(false);
        this.workerDlg.setTask(new CancelableSwingWorker(){

            @Override
            public int cancel() {
                EnsembleTimeSeriesPanel.this.dsdb.cancelCreateIndex();
                return -1;
            }

            public Object doInBackground() {
                try {
                    EnsembleTimeSeriesPanel.this.dsdb.createDB();
                }
                catch (IOException ex) {
                    Logger.getLogger(EnsembleTimeSeriesPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (SQLException ex) {
                    Logger.getLogger(EnsembleTimeSeriesPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ClassNotFoundException ex) {
                    Logger.getLogger(EnsembleTimeSeriesPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                return null;
            }
        });
        try {
            if (!this.dsdb.existsH2DB()) {
                this.workerDlg.execute();
            }
            if (!this.dsdb.existsH2DB()) {
                this.clearPanel();
                Logger.getLogger(EnsembleTimeSeriesPanel.class.getName()).log(Level.WARNING, JAMS.i18n("CREATION_CANCELED"));
            }
            if (!this.dsdb.isEnsembleTimeSeriesDatastore()) {
                Logger.getLogger(EnsembleTimeSeriesPanel.class.getName()).log(Level.WARNING, JAMS.i18n("WRONG_DATASTORE!"));
            }
            this.setEnsembleTsProc(new EnsembleTimeSeriesProcessor(this.dsdb));
        }
        catch (SQLException sQLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void resetIndex() {
        try {
            this.dsdb.clearDB();
        }
        catch (SQLException ex) {
            Logger.getLogger(EnsembleTimeSeriesPanel.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
        this.createDB();
    }

    @Override
    public void createProc(File file) {
        this.workerDlg.setTitle(this.workerDlg.getTitle() + " [" + file.getName() + "]");
        this.dsdb = new DataStoreProcessor(file);
        this.dsdb.addImportProgressObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                EnsembleTimeSeriesPanel.this.workerDlg.setProgress(Integer.parseInt(arg.toString()));
            }
        });
        this.createDB();
        this.outputDSFile = file;
    }

    private void setEnsembleTsProc(EnsembleTimeSeriesProcessor ensembleTsProc) throws SQLException, IOException {
        this.proc = ensembleTsProc;
        this.timeList.setModel(new AbstractListModel(){
            Attribute.Calendar[] dates;
            {
                this.dates = EnsembleTimeSeriesPanel.this.getProc().getTimeSteps();
            }

            @Override
            public int getSize() {
                if (this.dates == null) {
                    return 0;
                }
                return this.dates.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.dates[i];
            }
        });
        this.modelRunList.setModel(new AbstractListModel(){
            long[] ids_int;
            Long[] ids;
            {
                this.ids_int = EnsembleTimeSeriesPanel.this.getProc().getModelRuns();
                this.ids = new Long[this.ids_int.length];
                for (int i = 0; i < this.ids_int.length; ++i) {
                    this.ids[i] = new Long(this.ids_int[i]);
                }
            }

            @Override
            public int getSize() {
                return this.ids.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.ids[i];
            }
        });
        this.yearList.setModel(new AbstractListModel(){
            int[] years;
            {
                this.years = EnsembleTimeSeriesPanel.this.getProc().getYears();
            }

            @Override
            public int getSize() {
                return this.years.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.years[i];
            }
        });
        this.monthList.setModel(new AbstractListModel(){
            int[] months = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};

            @Override
            public int getSize() {
                return this.months.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.months[i];
            }
        });
        JLabel label = new JLabel(JAMS.i18n("AREA_ATTRIBUTE"));
        label.setHorizontalAlignment(2);
        GUIHelper.addGBComponent(this.aggregationPanel, this.aggregationLayout, label, 5, 0, 1, 1, 0.0, 0.0);
        ArrayList<AbstractDataStoreProcessor.AttributeData> attribs = this.getProc().getDataStoreProcessor().getAttributes();
        label = new JLabel(JAMS.i18n("AGGREGATION_WEIGHT"));
        label.setHorizontalAlignment(0);
        GUIHelper.addGBComponent(this.aggregationPanel, this.aggregationLayout, label, 10, 3, 3, 1, 0.0, 0.0);
        label = new JLabel("1");
        label.setHorizontalAlignment(0);
        GUIHelper.addGBComponent(this.aggregationPanel, this.aggregationLayout, label, 10, 5, 1, 1, 0.0, 0.0);
        label = new JLabel("a/A");
        label.setHorizontalAlignment(0);
        GUIHelper.addGBComponent(this.aggregationPanel, this.aggregationLayout, label, 11, 5, 1, 1, 0.0, 0.0);
        label = new JLabel("l->mm");
        label.setHorizontalAlignment(2);
        GUIHelper.addGBComponent(this.aggregationPanel, this.aggregationLayout, label, 12, 5, 1, 1, 0.0, 0.0);
        int i = 0;
        ArrayList<JCheckBox> allChecks = new ArrayList<JCheckBox>();
        for (AbstractDataStoreProcessor.AttributeData attributeData : attribs) {
            DSPanel.AttribCheckBox attribCheck = new DSPanel.AttribCheckBox(attributeData, attributeData.getName());
            attribCheck.setSelected(attributeData.isSelected());
            attribCheck.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DSPanel.AttribCheckBox thisCheck = (DSPanel.AttribCheckBox)e.getSource();
                    if (!thisCheck.isSelected() && EnsembleTimeSeriesPanel.this.attribCombo.getSelectedItem().toString().equals(thisCheck.getText())) {
                        EnsembleTimeSeriesPanel.this.attribCombo.setSelectedIndex(0);
                        GUIHelper.showInfoDlg(EnsembleTimeSeriesPanel.this.parent, JAMS.i18n("AREA_ATTRIBUTE_HAS_BEEN_RESET!"), JAMS.i18n("INFO"));
                    }
                    thisCheck.attrib.setSelected(thisCheck.isSelected());
                }
            });
            allChecks.add(attribCheck);
            GUIHelper.addGBComponent(this.aggregationPanel, this.aggregationLayout, attribCheck, 5, i + 10, 1, 1, 0.0, 0.0);
            DSPanel.AttribRadioButton button1 = new DSPanel.AttribRadioButton(attributeData, 1);
            DSPanel.AttribRadioButton button2 = new DSPanel.AttribRadioButton(attributeData, 2);
            button1.setSelected(true);
            ItemListener attribRadioButtonListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 2) {
                        return;
                    }
                    DSPanel.AttribRadioButton thisButton = (DSPanel.AttribRadioButton)e.getSource();
                    thisButton.attrib.setAggregationType(thisButton.processingType);
                    EnsembleTimeSeriesPanel.this.setCheckBox(thisButton.attrib.getName());
                }
            };
            button1.addItemListener(attribRadioButtonListener);
            button2.addItemListener(attribRadioButtonListener);
            ButtonGroup bGroup = new ButtonGroup();
            bGroup.add(button1);
            bGroup.add(button2);
            GUIHelper.addGBComponent(this.aggregationPanel, this.aggregationLayout, button1, 10, i + 10, 1, 1, 0.0, 0.0);
            GUIHelper.addGBComponent(this.aggregationPanel, this.aggregationLayout, button2, 11, i + 10, 1, 1, 0.0, 0.0);
            ++i;
        }
        String[] attribNames = new String[attribs.size() + 1];
        attribNames[0] = JAMS.i18n("[CHOOSE]");
        i = 1;
        for (AbstractDataStoreProcessor.AttributeData attrib : attribs) {
            attribNames[i++] = attrib.getName();
        }
        this.attribCombo = new DSPanel.AttribComboBox(allChecks);
        this.attribCombo.setModel(new DefaultComboBoxModel<String>(attribNames));
        this.attribCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DSPanel.AttribComboBox thisCombo = (DSPanel.AttribComboBox)e.getSource();
                EnsembleTimeSeriesPanel.this.setCheckBox(thisCombo.getSelectedItem().toString());
            }
        });
        GUIHelper.addGBComponent(this.aggregationPanel, this.aggregationLayout, this.attribCombo, 10, 0, 5, 1, 0.0, 0.0);
        DSPanel.GroupCheckBox groupCheckBox = new DSPanel.GroupCheckBox(JAMS.i18n("ALL_ON/OFF"), allChecks);
        groupCheckBox.setSelected(false);
        GUIHelper.addGBComponent(this.aggregationPanel, this.aggregationLayout, groupCheckBox, 5, 3, 1, 1, 0.0, 0.0);
        groupCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DSPanel.GroupCheckBox thisCheck = (DSPanel.GroupCheckBox)e.getSource();
                boolean selected = thisCheck.isSelected();
                ArrayList<JCheckBox> allChecks = thisCheck.checkBoxList;
                for (JCheckBox checkBox : allChecks) {
                    checkBox.setSelected(selected);
                }
            }
        });
        this.aggregationPanel.updateUI();
        this.cacheReset.setEnabled(true);
        this.timeField.setEnabled(true);
        this.indexReset.setEnabled(true);
        this.proc.addProcessingProgressObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                EnsembleTimeSeriesPanel.this.workerDlg.setProgress(Integer.parseInt(arg.toString()));
            }
        });
    }

    private boolean setCheckBox(String theLabel) {
        for (JCheckBox check : this.attribCombo.checkBoxList) {
            if (!theLabel.equals(check.getText())) continue;
            check.setSelected(true);
            return true;
        }
        return false;
    }

    private void clearPanel() {
        this.timeList.setEnabled(false);
        this.modelRunList.setEnabled(false);
        this.yearList.setEnabled(false);
        this.monthList.setEnabled(false);
        this.cacheReset.setEnabled(false);
        this.timeField.setEnabled(false);
        this.indexReset.setEnabled(false);
    }

    private void showTimeStep() {
        if (this.timeList.getSelectedValues().length == 0 || this.timeList.getSelectedValues().length > 1) {
            return;
        }
        this.workerDlg.setInderminate(true);
        this.workerDlg.setTask(new SwingWorker<Object, Void>(){
            DataMatrix m = null;

            @Override
            public Object doInBackground() {
                JAMSCalendar date = (JAMSCalendar)EnsembleTimeSeriesPanel.this.timeList.getSelectedValue();
                if (date == null) {
                    return this.m;
                }
                try {
                    this.m = EnsembleTimeSeriesPanel.this.getProc().getTemporalData(date);
                }
                catch (SQLException sQLException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return this.m;
            }

            @Override
            public void done() {
                EnsembleTimeSeriesPanel.this.loadData(this.m, false);
            }
        });
        this.workerDlg.execute();
    }

    private void showMonthlyMean() {
        if (this.monthList.getSelectedValues().length == 0) {
            return;
        }
        this.workerDlg.setInderminate(false);
        this.workerDlg.setProgress(0);
        this.workerDlg.setTask(new CancelableSwingWorker(){
            DataMatrix m;

            public Object doInBackground() {
                try {
                    int month = (Integer)EnsembleTimeSeriesPanel.this.monthList.getSelectedValue();
                    EnsembleTimeSeriesPanel.this.workerDlg.setInderminate(true);
                    if (!EnsembleTimeSeriesPanel.this.proc.isMonthlyMeanExisiting()) {
                        EnsembleTimeSeriesPanel.this.proc.calcMonthlyMean();
                    }
                    this.m = EnsembleTimeSeriesPanel.this.proc.getMonthlyMean(month);
                }
                catch (SQLException ex) {
                    Logger.getLogger(EnsembleTimeSeriesPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(EnsembleTimeSeriesPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                return null;
            }

            @Override
            public void done() {
                EnsembleTimeSeriesPanel.this.loadData(this.m, false);
            }

            @Override
            public int cancel() {
                EnsembleTimeSeriesPanel.this.proc.sendAbortOperation();
                return 0;
            }
        });
        this.workerDlg.execute();
    }

    private void showYearlyMean() {
        if (this.yearList.getSelectedValues().length == 0) {
            return;
        }
        this.workerDlg.setInderminate(false);
        this.workerDlg.setProgress(0);
        this.workerDlg.setTask(new CancelableSwingWorker(){
            DataMatrix m;

            public Object doInBackground() {
                try {
                    int year = (Integer)EnsembleTimeSeriesPanel.this.yearList.getSelectedValue();
                    this.m = EnsembleTimeSeriesPanel.this.proc.getYearlyMean(year);
                    EnsembleTimeSeriesPanel.this.workerDlg.setInderminate(true);
                }
                catch (SQLException ex) {
                    Logger.getLogger(EnsembleTimeSeriesPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(EnsembleTimeSeriesPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                return null;
            }

            @Override
            public void done() {
                EnsembleTimeSeriesPanel.this.loadData(this.m, false);
            }

            @Override
            public int cancel() {
                EnsembleTimeSeriesPanel.this.proc.sendAbortOperation();
                return 0;
            }
        });
        this.workerDlg.execute();
    }

    private void showTempMean() {
        if (this.timeList.getSelectedValues().length == 0) {
            return;
        }
        this.workerDlg.setInderminate(false);
        this.workerDlg.setProgress(0);
        this.workerDlg.setTask(new CancelableSwingWorker(){
            DataMatrix m = null;

            public Object doInBackground() {
                try {
                    Object[] objects = EnsembleTimeSeriesPanel.this.timeList.getSelectedValues();
                    ArrayList<JAMSCalendar> dateList = new ArrayList<JAMSCalendar>();
                    for (Object o : objects) {
                        dateList.add((JAMSCalendar)o);
                    }
                    JAMSCalendar[] dates = dateList.toArray(new JAMSCalendar[dateList.size()]);
                    this.m = EnsembleTimeSeriesPanel.this.proc.getTemporalMean(dates);
                }
                catch (SQLException ex) {
                    Logger.getLogger(EnsembleTimeSeriesPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(EnsembleTimeSeriesPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                return null;
            }

            @Override
            public void done() {
                EnsembleTimeSeriesPanel.this.loadData(this.m, false);
            }

            @Override
            public int cancel() {
                EnsembleTimeSeriesPanel.this.proc.sendAbortOperation();
                return 0;
            }
        });
        this.workerDlg.execute();
    }

    private void showModelRun() {
        if (this.modelRunList.getSelectedValues().length == 0) {
            return;
        }
        this.workerDlg.setInderminate(false);
        this.workerDlg.setProgress(0);
        this.workerDlg.setTask(new CancelableSwingWorker(){
            DataMatrix m = null;

            public Object doInBackground() {
                try {
                    Object[] objects = EnsembleTimeSeriesPanel.this.modelRunList.getSelectedValues();
                    long[] ids = new long[objects.length];
                    int c = 0;
                    for (Object o : objects) {
                        ids[c++] = (Long)o;
                    }
                    this.m = EnsembleTimeSeriesPanel.this.proc.getEnsembleMean(ids);
                }
                catch (SQLException sQLException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }

            @Override
            public void done() {
                EnsembleTimeSeriesPanel.this.loadData(this.m, true);
            }

            @Override
            public int cancel() {
                EnsembleTimeSeriesPanel.this.getProc().sendAbortOperation();
                return 0;
            }
        });
        this.workerDlg.execute();
    }

    private void showCrossProduct() {
        this.workerDlg.setInderminate(false);
        this.workerDlg.setProgress(0);
        this.workerDlg.setTask(new CancelableSwingWorker(){
            DataMatrix m;

            public Object doInBackground() {
                try {
                    Object[] objects1 = EnsembleTimeSeriesPanel.this.modelRunList.getSelectedValues();
                    long[] ids1 = new long[objects1.length];
                    for (int c = 0; c < ids1.length; ++c) {
                        ids1[c] = (Long)objects1[c];
                    }
                    Object[] objects2 = EnsembleTimeSeriesPanel.this.timeList.getSelectedValues();
                    String[] ids2 = new String[objects2.length];
                    for (int c = 0; c < ids2.length; ++c) {
                        ids2[c] = ((JAMSCalendar)objects2[c]).toString();
                    }
                    this.m = EnsembleTimeSeriesPanel.this.proc.getCrossProduct(ids1, ids2);
                }
                catch (SQLException ex) {
                    Logger.getLogger(EnsembleTimeSeriesPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(EnsembleTimeSeriesPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                return null;
            }

            @Override
            public void done() {
                EnsembleTimeSeriesPanel.this.loadData(this.m, true);
            }

            @Override
            public int cancel() {
                EnsembleTimeSeriesPanel.this.getProc().sendAbortOperation();
                return 0;
            }
        });
        this.workerDlg.execute();
    }

    private void toggleFreeTempMeanButton() {
        String filter = this.timeField.getText();
        if (!filter.contains("%") && !filter.contains("?")) {
            this.freeTempMean.setEnabled(false);
        } else {
            this.freeTempMean.setEnabled(true);
        }
    }

    private void resetCaches() {
        try {
            this.getProc().deleteCache();
        }
        catch (SQLException ex) {
            Logger.getLogger(EnsembleTimeSeriesPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

