/*
 * Decompiled with CFR 0.152.
 */
package ccindex.explorer.ensembles.implementation;

import ccindex.explorer.ensembles.api.Model;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.xml.bind.annotation.XmlTransient;

public abstract class AbstractModel<T extends Model>
implements Model<T> {
    private HashMap<String, String> propertyMap = new HashMap();
    transient ArrayList<Model.ModelDataChangeListener> listeners = new ArrayList();
    int id;

    public AbstractModel(int id) {
        this.setID(id);
    }

    @Override
    public void addModelDataChangeListener(Model.ModelDataChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeModelDataChangeListener(Model.ModelDataChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void removeAllModelDataChangeListener() {
        this.listeners.clear();
    }

    public AbstractModel(AbstractModel m) {
        this.propertyMap.putAll(m.propertyMap);
    }

    @Override
    @XmlTransient
    public Set<String> getProperties() {
        return this.getPropertyMap().keySet();
    }

    @Override
    public String getProperty(String key) {
        return this.getPropertyMap().get(key);
    }

    @Override
    public void setProperty(String key, String value) {
        this.getPropertyMap().put(key, value);
        for (Model.ModelDataChangeListener listener : this.listeners) {
            listener.changed(this, key);
        }
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public void setID(int id) {
        this.id = id;
    }

    public HashMap<String, String> getPropertyMap() {
        return this.propertyMap;
    }

    public void setPropertyMap(HashMap<String, String> propertyMap) {
        this.propertyMap = propertyMap;
    }
}

