/*
 * Decompiled with CFR 0.152.
 */
package ccindex.explorer.ensembles.implementation;

import ccindex.explorer.ensembles.api.Ensemble;
import ccindex.explorer.ensembles.api.Model;
import ccindex.explorer.ensembles.implementation.ClimateModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class AbstractEnsemble<T extends Model<T>>
implements Ensemble<T> {
    @XmlElement(type=ClimateModel.class)
    List<T> modelSet = null;
    @XmlElement
    String name;

    public AbstractEnsemble() {
        this("");
    }

    public AbstractEnsemble(String name) {
        this.name = name;
        this.modelSet = new ArrayList<T>();
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setModelSet(List<T> modelSet) {
        this.modelSet = modelSet;
    }

    public List<T> getModelSet() {
        return this.modelSet;
    }

    public boolean isIDValid(int id) {
        for (Model m : this.modelSet) {
            if (m.getID() != id) continue;
            return false;
        }
        return true;
    }

    @Override
    public T addModel(T m) {
        this.modelSet.add(m);
        int id = 0;
        while (!this.isIDValid(id)) {
            ++id;
        }
        m.setID(id);
        return m;
    }

    @Override
    public T removeModel(T m) {
        this.modelSet.remove(m);
        return m;
    }

    @Override
    public T deleteModel(T m) throws IOException {
        m.delete();
        return this.removeModel(m);
    }

    @Override
    public T getModel(int index) {
        return (T)((Model)this.modelSet.get(index));
    }

    @Override
    public int getSize() {
        return this.modelSet.size();
    }

    @Override
    public int getID(Model m) {
        for (int i = 0; i < this.modelSet.size(); ++i) {
            if (!((Model)this.modelSet.get(i)).equals(m)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public T duplicateModel(T m) {
        return this.addModel(m.copy());
    }

    @Override
    public Iterator<T> iterator() {
        return this.modelSet.iterator();
    }
}

