/*
 * Decompiled with CFR 0.152.
 */
package ccindex.explorer.ensembles.gui;

import ccindex.explorer.ensembles.gui.EnsembleControlPanel;
import ccindex.explorer.ensembles.implementation.ClimateEnsemble;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class EnsembleTree
extends JTree {
    static final Logger logger = Logger.getLogger(EnsembleTree.class.getName());

    public EnsembleTree() {
        EnsembleControlPanel.registerLogHandler(logger);
        this.setCellRenderer(new CheckBoxNodeRenderer());
        EnsembleTreeEditor editor = new EnsembleTreeEditor(this);
        this.setCellEditor(editor);
        this.init();
    }

    private void init() {
        logger.entering(this.getClass().getName(), "init");
        this.setEditable(true);
        this.getSelectionModel().setSelectionMode(1);
        ((DefaultTreeCellRenderer)this.getCellRenderer()).setMinimumSize(new Dimension(300, 25));
        ((DefaultTreeCellRenderer)this.getCellRenderer()).setPreferredSize(new Dimension(300, 25));
        ((DefaultTreeCellRenderer)this.getCellRenderer()).setSize(300, 25);
        logger.exiting(this.getClass().getName(), "init");
    }

    public void expandAll() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
    }

    @Override
    public void setModel(TreeModel m) {
        logger.entering(this.getClass().getName(), "setModel");
        super.setModel(m);
        this.getModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                EnsembleTree.this.expandAll();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                EnsembleTree.this.expandAll();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                EnsembleTree.this.expandAll();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                EnsembleTree.this.expandAll();
            }
        });
        this.expandAll();
        logger.exiting(this.getClass().getName(), "setModel");
    }

    private static class EnsembleTreeEditor
    extends AbstractCellEditor
    implements TreeCellEditor {
        JTree tree;
        CheckBoxNodeRenderer renderer = new CheckBoxNodeRenderer();
        JComponent editedComponent;
        JCheckBox checkBox = CheckBoxNodeRenderer.access$000(this.renderer);
        JTextField textfield = new JTextField();

        public EnsembleTreeEditor(JTree tree) {
            this.tree = tree;
            this.checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    editedComponent = (JComponent)e.getSource();
                    this.stopCellEditing();
                }
            });
            this.textfield.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    editedComponent = (JComponent)e.getSource();
                    this.stopCellEditing();
                }
            });
            this.textfield.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    editedComponent = (JComponent)e.getSource();
                    this.stopCellEditing();
                }
            });
        }

        @Override
        public Object getCellEditorValue() {
            Object o;
            logger.entering(this.getClass().getName(), "getCellEditorValue");
            if (this.editedComponent == this.checkBox && (o = this.tree.getSelectionPath().getLastPathComponent()) instanceof ClimateEnsemble.OutputDirectoryTreeNode) {
                ClimateEnsemble.OutputDirectoryTreeNode outputDirNode = (ClimateEnsemble.OutputDirectoryTreeNode)o;
                outputDirNode.getModel().setOutputSelection(outputDirNode.getOutputDirectory(), this.checkBox.isSelected());
                return outputDirNode.getUserObject();
            }
            if (this.editedComponent == this.textfield && (o = this.tree.getSelectionPath().getLastPathComponent()) instanceof ClimateEnsemble.EnsembleTreeNode) {
                ClimateEnsemble.EnsembleTreeNode ensembleTreeNode = (ClimateEnsemble.EnsembleTreeNode)o;
                ensembleTreeNode.getEnsemble().setName(this.textfield.getText());
                return ensembleTreeNode.getUserObject();
            }
            logger.exiting(this.getClass().getName(), "getCellEditorValue");
            return null;
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
            if (value instanceof ClimateEnsemble.EnsembleTreeNode) {
                if ((value = ((ClimateEnsemble.EnsembleTreeNode)value).getEnsemble().getName()) != null) {
                    this.textfield.setText(value.toString());
                } else {
                    this.textfield.setText("");
                }
                return this.textfield;
            }
            if (value instanceof ClimateEnsemble.OutputDirectoryTreeNode) {
                ClimateEnsemble.OutputDirectoryTreeNode value2 = (ClimateEnsemble.OutputDirectoryTreeNode)value;
                this.checkBox.setText(value2.getOutputDirectory());
                this.checkBox.setSelected(value2.getModel().isOutputSelected(value2.getOutputDirectory()));
                return this.checkBox;
            }
            Component editor = this.renderer.getTreeCellRendererComponent(tree, value, true, expanded, leaf, row, true);
            return editor;
        }

        @Override
        public boolean isCellEditable(EventObject event) {
            boolean returnValue = false;
            if (event instanceof MouseEvent) {
                Object node;
                MouseEvent mouseEvent = (MouseEvent)event;
                TreePath path = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (path != null && (node = path.getLastPathComponent()) != null && node instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
                    returnValue = treeNode instanceof ClimateEnsemble.OutputDirectoryTreeNode;
                }
                if (!returnValue) {
                    returnValue = super.isCellEditable(event) && path.getLastPathComponent() instanceof ClimateEnsemble.EnsembleTreeNode;
                }
            }
            return returnValue;
        }
    }

    static class CheckBoxNodeRenderer
    extends DefaultTreeCellRenderer {
        private final JCheckBox checkBoxRenderer = new JCheckBox();
        Color selectionBorderColor;
        Color selectionForeground;
        Color selectionBackground;
        Color textForeground;
        Color textBackground;

        public CheckBoxNodeRenderer() {
            Boolean booleanValue;
            Font fontValue = UIManager.getFont("Tree.font");
            if (fontValue != null) {
                this.checkBoxRenderer.setFont(fontValue);
            }
            this.checkBoxRenderer.setFocusPainted((booleanValue = (Boolean)UIManager.get("Tree.drawsFocusBorderAroundIcon")) != null && booleanValue != false);
            this.selectionBorderColor = UIManager.getColor("Tree.selectionBorderColor");
            this.selectionForeground = UIManager.getColor("Tree.selectionForeground");
            this.selectionBackground = UIManager.getColor("Tree.selectionBackground");
            this.textForeground = UIManager.getColor("Tree.textForeground");
            this.textBackground = UIManager.getColor("Tree.textBackground");
            this.checkBoxRenderer.setBackground(this.textBackground);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component returnValue = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            returnValue.setForeground(Color.black);
            if (value instanceof ClimateEnsemble.OutputDirectoryTreeNode) {
                if (selected) {
                    this.checkBoxRenderer.setForeground(this.selectionForeground);
                    this.checkBoxRenderer.setBackground(this.selectionBackground);
                } else {
                    this.checkBoxRenderer.setForeground(this.textForeground);
                    this.checkBoxRenderer.setBackground(this.textBackground);
                }
                ClimateEnsemble.OutputDirectoryTreeNode node = (ClimateEnsemble.OutputDirectoryTreeNode)value;
                boolean nodeSelection = node.getModel().isOutputSelected(node.getOutputDirectory());
                String stringValue = tree.convertValueToText(value, selected, expanded, leaf, row, false);
                this.checkBoxRenderer.setText(stringValue);
                this.checkBoxRenderer.setSelected(nodeSelection);
                this.checkBoxRenderer.setEnabled(tree.isEnabled());
                returnValue = this.checkBoxRenderer;
            }
            return returnValue;
        }

        static /* synthetic */ JCheckBox access$000(CheckBoxNodeRenderer x0) {
            return x0.checkBoxRenderer;
        }
    }
}

