/*
 * Decompiled with CFR 0.152.
 */
package ccindex.explorer.ensembles.gui;

import ccindex.explorer.ensembles.gui.AbstractClimateDataTab;
import ccindex.explorer.ensembles.gui.EnsembleControlPanel;
import ccindex.explorer.ensembles.implementation.ClimateEnsemble;
import jams.aggregators.Aggregator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class ClimateDataAggregationTab
extends AbstractClimateDataTab {
    JTable table;
    Aggregator.AggregationMode mode;
    Double modeParameter;
    EnsembleControlPanel parent;
    static final Logger logger = Logger.getLogger(ClimateDataAggregationTab.class.getName());

    public ClimateDataAggregationTab(String name, Aggregator.AggregationMode mode, Double modeParameter, EnsembleControlPanel parent) {
        super(name);
        EnsembleControlPanel.registerLogHandler(logger);
        this.mode = mode;
        this.modeParameter = modeParameter;
        this.parent = parent;
        this.table = new JTable();
        JScrollPane pane = new JScrollPane(this.table, 20, 32);
        this.setLayout(new BorderLayout());
        this.add((Component)pane, "Center");
    }

    @Override
    public void calculate() {
        int i;
        ClimateEnsemble.ClimateDataSupplier<Double>[] data;
        logger.entering(this.getClass().getName(), "calculate()");
        this.isChanged = false;
        if (this.output == null) {
            this.table.setModel(new DefaultTableModel(1, 1));
        }
        if ((data = this.ensemble.aggregateEnsemble(this.output, this.mode, this.modeParameter, this.parent.getRefPeriod())) == null) {
            return;
        }
        int T = data.length;
        if (T == 0) {
            return;
        }
        int K = data[0].size();
        Object[] columnNames = new String[1 + K];
        columnNames[0] = "Date";
        for (int i2 = 0; i2 < K; ++i2) {
            columnNames[i2 + 1] = Long.toString(data[0].getEntityIDs()[i2]);
        }
        DefaultTableModel tableModel = new DefaultTableModel(columnNames, T){

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }

            public Class getColumnClass(int col) {
                return col == 0 ? String.class : Double.class;
            }
        };
        for (i = 0; i < T; ++i) {
            tableModel.setValueAt(data[i].getName(), i, 0);
        }
        this.table.setAutoResizeMode(0);
        for (i = 0; i < T; ++i) {
            for (int j = 0; j < K; ++j) {
                int id = (int)data[i].getEntityIDs()[j];
                tableModel.setValueAt(data[i].get(id), i, j + 1);
            }
        }
        this.table.setModel(tableModel);
        this.table.setDefaultRenderer(Double.TYPE, new DoubleRenderer());
        this.table.setDefaultRenderer(Double.class, new DoubleRenderer());
        Enumeration<TableColumn> e = this.table.getColumnModel().getColumns();
        if (e.hasMoreElements()) {
            TableColumn col = e.nextElement();
            col.setMinWidth(150);
        }
        while (e.hasMoreElements()) {
            TableColumn col = e.nextElement();
            col.setMinWidth(100);
        }
        logger.exiting(this.getClass().getName(), "calculate()");
    }

    public class DoubleRenderer
    extends DefaultTableCellRenderer {
        @Override
        public void setValue(Object value) {
            this.setText(value == null ? "" : String.format(Locale.ENGLISH, "%.2f", value));
        }
    }
}

