/*
 * Decompiled with CFR 0.152.
 */
package ccindex.explorer.ensembles.gui;

import ccindex.explorer.ensembles.gui.AbstractDataTab;
import ccindex.explorer.ensembles.gui.EnsembleControlPanel;
import ccindex.explorer.ensembles.implementation.ClimateEnsemble;
import ccindex.explorer.ensembles.implementation.ClimateModel;
import ccindex.explorer.gui.CancelableWorkerDlg;
import jams.gui.WorkerDlg;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.SwingWorker;

public abstract class AbstractClimateDataTab
extends AbstractDataTab {
    static final Logger logger = Logger.getLogger(AbstractClimateDataTab.class.getName());
    ClimateEnsemble ensemble;
    ClimateModel currentModel;
    String output;
    int n;
    static JFileChooser fileChooser = new JFileChooser();

    public AbstractClimateDataTab(String name) {
        super(name);
        EnsembleControlPanel.registerLogHandler(logger);
        this.n = 0;
    }

    public void setOutput(String output) {
        this.output = output;
        this.setChanged();
    }

    public void setClimateEnsemble(ClimateEnsemble ensemble) {
        this.ensemble = ensemble;
        this.n = ensemble.getSize();
        this.setChanged();
    }

    public ClimateEnsemble getClimateEnsemble() {
        return this.ensemble;
    }

    protected abstract void calculate();

    @Override
    public void refresh() {
        if (!this.isShowing() || !this.isChanged()) {
            return;
        }
        if (this.ensemble == null || this.output == null) {
            return;
        }
        CancelableWorkerDlg worker = new CancelableWorkerDlg(null, "I am busy");
        ((WorkerDlg)worker).setTask(new SwingWorker(){

            protected Object doInBackground() throws Exception {
                try {
                    AbstractClimateDataTab.this.calculate();
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, "Sorry, I am unable to refesh the climate data tab", t);
                }
                return null;
            }
        });
        worker.execute();
    }
}

