/*
 * Decompiled with CFR 0.152.
 */
package ccindex.explorer.dsproc;

import jams.JAMS;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.math.stat.StatUtils;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;

public class DataStatistic {
    private String name;
    private double[] data;
    double min;
    double max;
    double varianz;
    double stabw;
    double spannweite;
    double da;
    double deviation;
    double kurt;
    double skew;
    double mean;
    double sum;
    double median;
    double quartil1;
    double quartil3;

    public DataStatistic(String name, double[] data) {
        this.name = name;
        this.data = data;
        this.cleanData();
        this.init();
    }

    private void cleanData() {
        ArrayList<Double> cleanList = new ArrayList<Double>();
        for (double d : this.data) {
            if (Double.isNaN(d)) continue;
            cleanList.add(d);
        }
        this.data = new double[cleanList.size()];
        int i = 0;
        Iterator iterator = cleanList.iterator();
        while (iterator.hasNext()) {
            double d = (Double)iterator.next();
            this.data[i++] = d;
        }
    }

    private void init() {
        DescriptiveStatistics stats = new DescriptiveStatistics();
        for (int i = 0; i < this.data.length; ++i) {
            stats.addValue(this.data[i]);
        }
        this.min = StatUtils.min((double[])this.data);
        this.max = StatUtils.max((double[])this.data);
        this.mean = StatUtils.mean((double[])this.data);
        this.sum = StatUtils.sum((double[])this.data);
        this.median = StatUtils.percentile((double[])this.data, (double)50.0);
        this.quartil1 = StatUtils.percentile((double[])this.data, (double)25.0);
        this.quartil3 = StatUtils.percentile((double[])this.data, (double)75.0);
        this.varianz = StatUtils.variance((double[])this.data);
        this.stabw = Math.sqrt(this.varianz);
        this.spannweite = this.max - this.min;
        this.da = 0.0;
        double[] F = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            F[i] = Math.abs(this.data[i] - this.mean);
            this.da += F[i];
        }
        this.da /= (double)this.data.length;
        this.skew = stats.getSkewness();
        this.kurt = stats.getKurtosis();
        this.deviation = stats.getStandardDeviation();
    }

    public double getDa() {
        return this.da;
    }

    public double getKurt() {
        return this.kurt;
    }

    public double getMean() {
        return this.mean;
    }

    public double getSum() {
        return this.sum;
    }

    public double getMedian() {
        return this.median;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getQuartil3() {
        return this.quartil3;
    }

    public double getStabw() {
        return this.stabw;
    }

    public String getName() {
        return this.name;
    }

    public double getQuartil1() {
        return this.quartil1;
    }

    public double getSkew() {
        return this.skew;
    }

    public double getSpannweite() {
        return this.spannweite;
    }

    public double getVarianz() {
        return this.varianz;
    }

    public double getDeviation() {
        return this.deviation;
    }

    public HashMap<String, Double> getResult() {
        HashMap<String, Double> result = new HashMap<String, Double>();
        result.put(JAMS.i18n("MINIMUM"), this.getMin());
        result.put(JAMS.i18n("MAXIMUM"), this.getMax());
        result.put(JAMS.i18n("MITTELWERT"), this.getMean());
        result.put(JAMS.i18n("SUMME"), this.getSum());
        result.put(JAMS.i18n("UNTERES_QUARTIL_(Q.25)"), this.getQuartil1());
        result.put(JAMS.i18n("MITTLERES_QUARTIL_(MEDIAN)"), this.getMedian());
        result.put(JAMS.i18n("OBERES_QUARTIL_(Q.75)"), this.getQuartil3());
        result.put(JAMS.i18n("SPANNWEITE"), this.getSpannweite());
        result.put(JAMS.i18n("VARIANZ"), this.getVarianz());
        result.put(JAMS.i18n("STANDARDABWEICHUNG"), this.getDeviation());
        result.put(JAMS.i18n("SCHIEFE_(SKEWNESS)"), this.getSkew());
        result.put(JAMS.i18n("W\u00d6LBUNG_(KURTOSIS)"), this.getKurt());
        return result;
    }

    public String toString() {
        String newLine = "\n";
        String retString = "========================";
        retString = retString + JAMS.i18n("STATISTIK_VON_") + this.name + ":" + newLine;
        retString = retString + JAMS.i18n("MINIMUM____:") + this.getMin() + newLine;
        retString = retString + JAMS.i18n("MAXIMUM____:") + this.getMax() + newLine;
        retString = retString + JAMS.i18n("MITTEL_____:") + this.getMean() + newLine;
        retString = retString + JAMS.i18n("MEDIANWERT_:") + this.getMedian() + newLine;
        retString = retString + JAMS.i18n("SPANNWEITE_:") + this.getSpannweite() + newLine;
        retString = retString + JAMS.i18n("VARIANZ____:") + this.getVarianz() + newLine;
        return retString;
    }
}

