/*
 * Decompiled with CFR 0.152.
 */
package jams.gui.input;

import jams.gui.input.JCalendarPopup;
import jams.gui.input.JTimePopup;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class JTimeButton
extends JButton
implements PropertyChangeListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    public static final String LANGUAGE_PARAM = "language";
    protected String m_strTimeParam = "date";
    protected Date m_timeTarget = null;
    protected String m_strLanguage = null;

    public JTimeButton() {
        ClassLoader cl = this.getClass().getClassLoader();
        try {
            ImageIcon icon = new ImageIcon(cl.getResource("images/buttons/Time.gif"));
            this.setIcon(icon);
        }
        catch (Exception ex) {
            this.setText("change");
        }
        this.setMargin(JCalendarPopup.NO_INSETS);
        this.setOpaque(false);
        this.addActionListener(this);
    }

    public JTimeButton(Date timeTarget) {
        this();
        this.init(null, timeTarget, null);
    }

    public JTimeButton(String strDateParam, Date timeTarget) {
        this();
        this.init(strDateParam, timeTarget, null);
    }

    public JTimeButton(String strDateParam, Date timeTarget, String strLanguage) {
        this();
        this.init(strDateParam, timeTarget, strLanguage);
    }

    public void init(String strTimeParam, Date timeTarget, String strLanguage) {
        if (strTimeParam == null) {
            strTimeParam = "date";
        }
        this.m_strTimeParam = strTimeParam;
        this.m_timeTarget = timeTarget;
        this.m_strLanguage = strLanguage;
    }

    public void setTargetDate(Date timeTarget) {
        this.m_timeTarget = timeTarget;
    }

    public Date getTargetDate() {
        return this.m_timeTarget;
    }

    public String getDateParam() {
        return this.m_strTimeParam;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this) {
            Date dateTarget = this.getTargetDate();
            JTimePopup popup = JTimePopup.createTimePopup(this.getDateParam(), dateTarget, this, this.m_strLanguage);
            popup.addPropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        if (this.m_strTimeParam.equalsIgnoreCase(evt.getPropertyName()) && evt.getNewValue() instanceof Date) {
            this.m_timeTarget = (Date)evt.getNewValue();
        }
        if (LANGUAGE_PARAM.equalsIgnoreCase(evt.getPropertyName()) && evt.getNewValue() instanceof String) {
            this.m_strLanguage = (String)evt.getNewValue();
        }
    }
}

