/*
 * Decompiled with CFR 0.152.
 */
package jams.gui.input;

import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import jams.gui.input.BooleanInput;
import jams.gui.input.CalendarInput;
import jams.gui.input.FileInput;
import jams.gui.input.FloatInput;
import jams.gui.input.InputComponent;
import jams.gui.input.IntegerInput;
import jams.gui.input.TextInput;
import jams.gui.input.TimeintervalInput;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class InputComponentFactory {
    private static final int JCOMP_HEIGHT = 20;
    private static final int NUMBERINPUT_WIDTH = 100;
    private static final int TEXTINPUT_WIDTH = 250;
    private static final int FILEINPUT_WIDTH = 250;

    public static InputComponent createInputComponent(Class type) {
        return InputComponentFactory.createInputComponent(type, false);
    }

    public static InputComponent createInputComponent(Class type, boolean extEdit) {
        JComponent ic;
        if (type.isInterface()) {
            type = DefaultDataFactory.getDataFactory().getImplementingClass(type);
        }
        if (Attribute.FileName.class.isAssignableFrom(type)) {
            ic = new FileInput(false);
        } else if (Attribute.DirName.class.isAssignableFrom(type)) {
            ic = new FileInput(true);
        } else if (Attribute.Calendar.class.isAssignableFrom(type)) {
            ic = new CalendarInput();
        } else if (Attribute.TimeInterval.class.isAssignableFrom(type)) {
            ic = new TimeintervalInput(extEdit);
        } else if (Attribute.Boolean.class.isAssignableFrom(type)) {
            ic = new BooleanInput();
        } else if (Attribute.Integer.class.isAssignableFrom(type) || Attribute.Long.class.isAssignableFrom(type)) {
            ic = new IntegerInput();
            ic.getComponent().setPreferredSize(new Dimension(100, 20));
            ic.getComponent().setBorder(BorderFactory.createEtchedBorder());
        } else if (Attribute.Float.class.isAssignableFrom(type) || Attribute.Double.class.isAssignableFrom(type)) {
            ic = new FloatInput();
            ic.getComponent().setPreferredSize(new Dimension(100, 20));
            ic.getComponent().setBorder(BorderFactory.createEtchedBorder());
        } else {
            ic = new TextInput();
            ic.getComponent().setPreferredSize(new Dimension(250, 20));
            ic.getComponent().setBorder(BorderFactory.createEtchedBorder());
        }
        return ic;
    }
}

