/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc;

import java.util.Random;
import junit.framework.TestCase;
import ucar.nc2.TestAll;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.projection.AlbersEqualArea;
import ucar.unidata.geoloc.projection.FlatEarth;
import ucar.unidata.geoloc.projection.LambertAzimuthalEqualArea;
import ucar.unidata.geoloc.projection.LambertConformal;
import ucar.unidata.geoloc.projection.Mercator;
import ucar.unidata.geoloc.projection.Orthographic;
import ucar.unidata.geoloc.projection.RotatedPole;
import ucar.unidata.geoloc.projection.Stereographic;
import ucar.unidata.geoloc.projection.TransverseMercator;
import ucar.unidata.geoloc.projection.UtmProjection;
import ucar.unidata.geoloc.projection.VerticalPerspectiveView;
import ucar.unidata.geoloc.projection.proj4.AlbersEqualAreaEllipse;
import ucar.unidata.geoloc.projection.proj4.LambertConformalConicEllipse;
import ucar.unidata.geoloc.projection.sat.MSGnavigation;

public class TestProjections
extends TestCase {
    boolean show = false;
    int NTRIALS = 10000;
    double TOLERENCE = 1.0E-6;
    int count = 10;

    public TestProjections(String name) {
        super(name);
    }

    private void doOne(ProjectionImpl proj, double lat, double lon) {
        LatLonPointImpl startL = new LatLonPointImpl(lat, lon);
        ProjectionPoint p = proj.latLonToProj((LatLonPoint)startL);
        LatLonPointImpl endL = (LatLonPointImpl)proj.projToLatLon(p);
        System.out.println("start  = " + startL.toString(8));
        System.out.println("end  = " + endL.toString(8));
    }

    private void testProjection(ProjectionImpl proj) {
        Random r = new Random(((Object)((Object)this)).hashCode());
        LatLonPointImpl startL = new LatLonPointImpl();
        int countT1 = 0;
        for (int i = 0; i < this.NTRIALS; ++i) {
            LatLonPoint endL;
            startL.setLatitude(180.0 * (r.nextDouble() - 0.5));
            startL.setLongitude(360.0 * (r.nextDouble() - 0.5));
            ProjectionPoint p = proj.latLonToProj((LatLonPoint)startL);
            if (Double.isNaN(p.getX()) || Double.isNaN(p.getY()) || Double.isNaN((endL = proj.projToLatLon(p)).getLatitude()) || Double.isNaN(endL.getLongitude())) continue;
            assert (TestAll.closeEnough(startL.getLatitude(), endL.getLatitude(), 0.001)) : proj.getClass().getName() + " failedddddd start= " + startL + " end = " + endL + " diff = " + TestAll.howClose(startL.getLatitude(), endL.getLatitude());
            assert (TestAll.closeEnough(startL.getLongitude(), endL.getLongitude(), 0.001)) : proj.getClass().getName() + " failedddddd start= " + startL + " end = " + endL + " diff = " + TestAll.howClose(startL.getLongitude(), endL.getLongitude());
            ++countT1;
        }
        int countT2 = 0;
        ProjectionPointImpl startP = new ProjectionPointImpl();
        for (int i = 0; i < this.NTRIALS; ++i) {
            ProjectionPoint endP;
            startP.setLocation(10000.0 * (r.nextDouble() - 0.5), 10000.0 * (r.nextDouble() - 0.5));
            LatLonPoint ll = proj.projToLatLon((ProjectionPoint)startP);
            if (Double.isNaN(ll.getLatitude()) || Double.isNaN(ll.getLongitude()) || Double.isNaN((endP = proj.latLonToProj(ll)).getX()) || Double.isNaN(endP.getY())) continue;
            assert (TestAll.closeEnough(startP.getX(), endP.getX()));
            assert (TestAll.closeEnough(startP.getY(), endP.getY()));
            ++countT2;
        }
        System.out.printf("Tested %d, %d pts for projection %s %n", countT1, countT2, proj.getClassName());
    }

    public void testProjectionLonMax(ProjectionImpl proj, double lonMax, double latMax) {
        Random r = new Random(((Object)((Object)this)).hashCode());
        LatLonPointImpl startL = new LatLonPointImpl();
        double minx = Double.MAX_VALUE;
        double maxx = -1.7976931348623157E308;
        double miny = Double.MAX_VALUE;
        double maxy = -1.7976931348623157E308;
        for (int i = 0; i < this.NTRIALS; ++i) {
            startL.setLatitude(latMax * (2.0 * r.nextDouble() - 1.0));
            startL.setLongitude(lonMax * (2.0 * r.nextDouble() - 1.0));
            ProjectionPoint p = proj.latLonToProj((LatLonPoint)startL);
            LatLonPoint endL = proj.projToLatLon(p);
            if (this.show) {
                System.out.println("startL  = " + startL);
                System.out.println("inter  = " + p);
                System.out.println("endL  = " + endL);
            }
            double tolerence = 5.0E-4;
            assert (TestAll.closeEnough(startL.getLatitude(), endL.getLatitude(), tolerence)) : proj.getClass().getName() + " failed start= " + startL + " end = " + endL;
            assert (TestAll.closeEnough(startL.getLongitude(), endL.getLongitude(), tolerence)) : proj.getClass().getName() + " failed start= " + startL + " end = " + endL;
            minx = Math.min(minx, p.getX());
            maxx = Math.max(maxx, p.getX());
            miny = Math.min(miny, p.getY());
            maxy = Math.max(maxy, p.getY());
        }
        double rangex = maxx - minx;
        double rangey = maxy - miny;
        if (this.show) {
            System.out.printf("rangex  = (%f,%f) %n", minx, maxx);
            System.out.printf("rangey  = (%f,%f) %n", miny, maxy);
        }
        startL.setLatitude(latMax / 2.0);
        startL.setLongitude(lonMax / 2.0);
        ProjectionPointImpl base = new ProjectionPointImpl();
        proj.latLonToProj((LatLonPoint)startL, base);
        ProjectionPointImpl startP = new ProjectionPointImpl();
        for (int i = 0; i < this.NTRIALS; ++i) {
            double x = minx + rangex * r.nextDouble();
            double y = miny + rangey * r.nextDouble();
            startP.setLocation(x, y);
            try {
                LatLonPoint ll = proj.projToLatLon((ProjectionPoint)startP);
                ProjectionPoint endP = proj.latLonToProj(ll);
                if (this.show) {
                    System.out.println("start  = " + startP);
                    System.out.println("interL  = " + ll);
                    System.out.println("end  = " + endP);
                }
                assert (TestAll.closeEnough(startP.getX(), endP.getX(), 5.0E-4)) : " failed start= " + startP.getX() + " end = " + endP.getX() + "; x,y=" + startP;
                if ($assertionsDisabled || TestAll.closeEnough(startP.getY(), endP.getY(), 5.0E-4)) continue;
                throw new AssertionError((Object)(" failed start= " + startP.getY() + " end = " + endP.getY() + "; x,y=" + startP));
            }
            catch (IllegalArgumentException e) {
                System.out.printf("IllegalArgumentException=%s%n", e.getMessage());
            }
        }
        System.out.println("Tested " + this.NTRIALS + " pts for projection " + proj.getClassName());
    }

    public void testLC() {
        this.testProjection((ProjectionImpl)new LambertConformal());
        LambertConformal lc = new LambertConformal();
        LambertConformal lc2 = (LambertConformal)lc.constructCopy();
        assert (lc.equals((Object)lc2));
    }

    public void testLCseam() {
        LambertConformal lc = new LambertConformal(40.0, 180.0, 20.0, 60.0);
        ProjectionPointImpl p1 = (ProjectionPointImpl)lc.latLonToProj((LatLonPoint)new LatLonPointImpl(0.0, -1.0), new ProjectionPointImpl());
        ProjectionPointImpl p2 = (ProjectionPointImpl)lc.latLonToProj((LatLonPoint)new LatLonPointImpl(0.0, 1.0), new ProjectionPointImpl());
        System.out.printf(" p1= x=%f y=%f%n", p1.getX(), p1.getY());
        System.out.printf(" p2= x=%f y=%f%n", p2.getX(), p2.getY());
        assert (lc.crossSeam((ProjectionPoint)p1, (ProjectionPoint)p2));
    }

    public void testTM() {
        this.testProjection((ProjectionImpl)new TransverseMercator());
        TransverseMercator p = new TransverseMercator();
        TransverseMercator p2 = (TransverseMercator)p.constructCopy();
        assert (p.equals((Object)p2));
    }

    public void testStereo() {
        this.testProjection((ProjectionImpl)new Stereographic());
        Stereographic p = new Stereographic();
        Stereographic p2 = (Stereographic)p.constructCopy();
        assert (p.equals((Object)p2));
    }

    public void testLA() {
        this.testProjection((ProjectionImpl)new LambertAzimuthalEqualArea());
        LambertAzimuthalEqualArea p = new LambertAzimuthalEqualArea();
        LambertAzimuthalEqualArea p2 = (LambertAzimuthalEqualArea)p.constructCopy();
        assert (p.equals((Object)p2));
    }

    public void utestOrtho() {
        this.testProjectionLonMax((ProjectionImpl)new Orthographic(), 180.0, 80.0);
        Orthographic p = new Orthographic();
        Orthographic p2 = (Orthographic)p.constructCopy();
        assert (p.equals((Object)p2));
    }

    public void testAEA() {
        this.testProjection((ProjectionImpl)new AlbersEqualArea());
        AlbersEqualArea p = new AlbersEqualArea();
        AlbersEqualArea p2 = (AlbersEqualArea)p.constructCopy();
        assert (p.equals((Object)p2));
    }

    public void utestAEAE() {
        this.testProjectionLonMax((ProjectionImpl)new AlbersEqualAreaEllipse(), 360.0, 80.0);
        AlbersEqualAreaEllipse p = new AlbersEqualAreaEllipse();
        AlbersEqualAreaEllipse p2 = (AlbersEqualAreaEllipse)p.constructCopy();
        assert (p.equals((Object)p2));
    }

    public void utestLCCE() {
        this.testProjectionLonMax((ProjectionImpl)new LambertConformalConicEllipse(), 360.0, 80.0);
        LambertConformalConicEllipse p = new LambertConformalConicEllipse();
        LambertConformalConicEllipse p2 = (LambertConformalConicEllipse)p.constructCopy();
        assert (p.equals((Object)p2));
    }

    public void testFlatEarth() {
        this.testProjection((ProjectionImpl)new FlatEarth());
        FlatEarth p = new FlatEarth();
        FlatEarth p2 = (FlatEarth)p.constructCopy();
        assert (p.equals((Object)p2));
    }

    public void testMercator() {
        this.testProjection((ProjectionImpl)new Mercator());
        Mercator p = new Mercator();
        Mercator p2 = (Mercator)p.constructCopy();
        assert (p.equals((Object)p2));
    }

    private void showProjVal(ProjectionImpl proj, double lat, double lon) {
        LatLonPointImpl startL = new LatLonPointImpl(lat, lon);
        ProjectionPoint p = proj.latLonToProj((LatLonPoint)startL);
        System.out.printf("lat,lon= (%f, %f) x, y= (%f, %f) %n", lat, lon, p.getX(), p.getY());
    }

    public void testMSG() {
        this.doOne((ProjectionImpl)new MSGnavigation(), 60.0, 60.0);
        this.testProjection((ProjectionImpl)new MSGnavigation());
        MSGnavigation m = new MSGnavigation();
        this.showProjVal((ProjectionImpl)m, 0.0, 0.0);
        this.showProjVal((ProjectionImpl)m, 60.0, 0.0);
        this.showProjVal((ProjectionImpl)m, -60.0, 0.0);
        this.showProjVal((ProjectionImpl)m, 0.0, 60.0);
        this.showProjVal((ProjectionImpl)m, 0.0, -60.0);
    }

    public void testRotatedPole() {
        this.testProjectionLonMax((ProjectionImpl)new RotatedPole(37.0, 177.0), 360.0, 88.0);
        RotatedPole p = new RotatedPole();
        RotatedPole p2 = (RotatedPole)p.constructCopy();
        assert (p.equals((Object)p2));
    }

    public void testUTM() {
        this.testProjectionUTM(-12.89, 0.07996);
        this.testProjectionUTM(this.NTRIALS);
        UtmProjection p = new UtmProjection();
        UtmProjection p2 = (UtmProjection)p.constructCopy();
        assert (p.equals((Object)p2));
    }

    private void testProjectionUTM(double lat, double lon) {
        LatLonPointImpl startL = new LatLonPointImpl();
        startL.setLatitude(lat);
        startL.setLongitude(lon);
        int zone = (int)((lon + 183.0) / 6.0);
        UtmProjection proj = new UtmProjection(zone, lat >= 0.0);
        ProjectionPoint p = proj.latLonToProj((LatLonPoint)startL);
        LatLonPoint endL = proj.projToLatLon(p);
        if (this.show) {
            System.out.println("startL  = " + startL);
            System.out.println("inter  = " + p);
            System.out.println("endL  = " + endL);
        }
        assert (TestAll.closeEnough(startL.getLatitude(), endL.getLatitude(), 1.3E-4)) : proj.getClass().getName() + " failed start= " + startL + " end = " + endL;
        assert (TestAll.closeEnough(startL.getLongitude(), endL.getLongitude(), 1.3E-4)) : proj.getClass().getName() + " failed start= " + startL + " end = " + endL;
    }

    private void testProjectionUTM(int n) {
        Random r = new Random(((Object)((Object)this)).hashCode());
        LatLonPointImpl startL = new LatLonPointImpl();
        for (int i = 0; i < n; ++i) {
            startL.setLatitude(180.0 * (r.nextDouble() - 0.5));
            startL.setLongitude(360.0 * (r.nextDouble() - 0.5));
            double lat = startL.getLatitude();
            double lon = startL.getLongitude();
            int zone = (int)((lon + 183.0) / 6.0);
            UtmProjection proj = new UtmProjection(zone, lat >= 0.0);
            ProjectionPoint p = proj.latLonToProj((LatLonPoint)startL);
            LatLonPoint endL = proj.projToLatLon(p);
            if (this.show) {
                System.out.println("startL  = " + startL);
                System.out.println("inter  = " + p);
                System.out.println("endL  = " + endL);
            }
            double late = endL.getLatitude();
            double lone = endL.getLongitude();
            assert (TestAll.closeEnough(lat, late, 1.0E-4)) : proj.getClass().getName() + " lat failed start= " + startL + " end = " + endL + " diff = " + TestAll.howClose(lat, late);
            assert (TestAll.closeEnough(lon, lone, 0.004)) : proj.getClass().getName() + " lon failed start= " + startL + " end = " + endL + " diff = " + TestAll.howClose(lon, lone);
        }
        System.out.println("Tested " + n + " pts for UTM projection ");
    }

    public void utestVerticalPerspectiveView() {
        this.testProjectionLonMax((ProjectionImpl)new VerticalPerspectiveView(), 66.0, 60.0);
        VerticalPerspectiveView p = new VerticalPerspectiveView();
        VerticalPerspectiveView p2 = (VerticalPerspectiveView)p.constructCopy();
        assert (p.equals((Object)p2));
    }
}

