/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc;

import java.util.Random;
import junit.framework.TestCase;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.util.Format;

public class TestBasic
extends TestCase {
    private final boolean debug1 = false;
    private final boolean debug2 = false;
    private final boolean debug3 = false;
    private final boolean debug4 = false;

    public TestBasic(String name) {
        super(name);
    }

    LatLonRect makeLatLonBoundingBox2(double lon1, double lon2) {
        LatLonPointImpl pt1 = new LatLonPointImpl(-10.0, lon1);
        LatLonPointImpl pt2 = new LatLonPointImpl(10.0, lon2);
        LatLonRect llbb = new LatLonRect((LatLonPoint)pt1, (LatLonPoint)pt2);
        return llbb;
    }

    LatLonRect makeLatLonBoundingBox(double lon, double loninc) {
        LatLonPointImpl pt = new LatLonPointImpl(-10.0, lon);
        LatLonRect llbb = new LatLonRect((LatLonPoint)pt, 20.0, loninc);
        return llbb;
    }

    void testContains(LatLonRect b1, LatLonRect b2) {
        assert (b1.containedIn(b2));
    }

    LatLonRect testExtend(LatLonRect b, LatLonPoint pt) {
        b.extend(pt);
        assert (b.contains(pt));
        return b;
    }

    public void testGlobalBB() {
        Random rand = new Random(System.currentTimeMillis());
        int count = 0;
        while (count++ < 1000) {
            double r = 360.0 * (double)rand.nextFloat() - 180.0;
            LatLonRect llbb = new LatLonRect((LatLonPoint)new LatLonPointImpl(20.0, r), 20.0, 360.0);
            double r2 = 360.0 * (double)rand.nextFloat() - 180.0;
            LatLonPointImpl p = new LatLonPointImpl(30.0, r2);
            assert (llbb.contains((LatLonPoint)p));
        }
    }

    public void testLatLonBoundingBox() {
        assert (this.makeLatLonBoundingBox(140.0, 50.0).equals(this.makeLatLonBoundingBox(190.0, -50.0)));
        assert (this.makeLatLonBoundingBox(140.0, -150.0).equals(this.makeLatLonBoundingBox(-10.0, 150.0)));
        assert (this.makeLatLonBoundingBox(140.0, 50.0).equals(this.makeLatLonBoundingBox2(140.0, 190.0)));
        assert (this.makeLatLonBoundingBox(-170.0, 310.0).equals(this.makeLatLonBoundingBox2(190.0, 140.0)));
        assert (this.makeLatLonBoundingBox(190.0, 310.0).equals(this.makeLatLonBoundingBox2(190.0, 140.0)));
        assert (this.makeLatLonBoundingBox(140.0, 50.0).crossDateline());
        assert (!this.makeLatLonBoundingBox(140.0, -150.0).crossDateline());
        assert (this.makeLatLonBoundingBox(0.0, -250.0).crossDateline());
        assert (!this.makeLatLonBoundingBox(-170.0, 300.0).crossDateline());
        assert (this.makeLatLonBoundingBox2(140.0, 190.0).crossDateline());
        assert (!this.makeLatLonBoundingBox2(190.0, 140.0).crossDateline());
        assert (this.makeLatLonBoundingBox(-170.0, 370.0).crossDateline());
        LatLonPointImpl pt = new LatLonPointImpl(0.0, 177.0);
        assert (this.makeLatLonBoundingBox(140.0, 50.0).contains((LatLonPoint)pt));
        assert (!this.makeLatLonBoundingBox(190.0, 310.0).contains((LatLonPoint)pt));
        assert (this.makeLatLonBoundingBox2(140.0, 190.0).contains((LatLonPoint)pt));
        assert (!this.makeLatLonBoundingBox(190.0, 140.0).contains((LatLonPoint)pt));
        this.testContains(this.makeLatLonBoundingBox(140.0, 50.0), this.makeLatLonBoundingBox(140.0, 50.0));
        this.testContains(this.makeLatLonBoundingBox2(140.0, 50.0), this.makeLatLonBoundingBox2(140.0, 50.0));
        this.testContains(this.makeLatLonBoundingBox(140.0, 50.0), this.makeLatLonBoundingBox(0.0, 360.0));
        this.testContains(this.makeLatLonBoundingBox(300.0, 50.0), this.makeLatLonBoundingBox(0.0, 360.0));
        this.testContains(this.makeLatLonBoundingBox(50.0, 300.0), this.makeLatLonBoundingBox(0.0, 360.0));
        this.testContains(this.makeLatLonBoundingBox(50.0, 300.0), this.makeLatLonBoundingBox(-180.0, 360.0));
        this.testContains(this.makeLatLonBoundingBox2(190.0, 10.0), this.makeLatLonBoundingBox2(140.0, 50.0));
        this.testContains(this.makeLatLonBoundingBox(190.0, 10.0), this.makeLatLonBoundingBox(140.0, 60.0));
        LatLonPointImpl p = new LatLonPointImpl(30.0, 30.0);
        LatLonRect b = this.testExtend(this.makeLatLonBoundingBox(10.0, 10.0), (LatLonPoint)p);
        assert (p.equals((LatLonPoint)b.getUpperRightPoint()));
        p = new LatLonPointImpl(-30.0, -30.0);
        b = this.testExtend(this.makeLatLonBoundingBox(10.0, 10.0), (LatLonPoint)p);
        assert (p.equals((LatLonPoint)b.getLowerLeftPoint()));
        p = new LatLonPointImpl(30.0, 190.0);
        b = this.testExtend(this.makeLatLonBoundingBox(50.0, 100.0), (LatLonPoint)p);
        assert (p.equals((LatLonPoint)b.getUpperRightPoint()));
        assert (b.crossDateline());
        p = new LatLonPointImpl(-30.0, -50.0);
        b = this.testExtend(this.makeLatLonBoundingBox(50.0, 100.0), (LatLonPoint)p);
        assert (p.equals((LatLonPoint)b.getLowerLeftPoint()));
        assert (!b.crossDateline());
        p = new LatLonPointImpl(-30.0, 100.0);
        b = this.testExtend(this.makeLatLonBoundingBox2(140.0, 50.0), (LatLonPoint)p);
        assert (p.equals((LatLonPoint)b.getLowerLeftPoint()));
        assert (b.crossDateline());
        p = new LatLonPointImpl(30.0, 55.0);
        b = this.testExtend(this.makeLatLonBoundingBox2(140.0, 50.0), (LatLonPoint)p);
        assert (p.equals((LatLonPoint)b.getUpperRightPoint()));
        assert (b.crossDateline());
    }

    void showLatLonNormal(double lon, double center) {
        System.out.println(Format.formatDouble((double)lon, (int)8, (int)5) + " => " + Format.formatDouble((double)LatLonPointImpl.lonNormal((double)lon, (double)center), (int)8, (int)5));
    }

    void runCenter(double center) {
        for (double lon = 0.0; lon < 380.0; lon += 22.5) {
            double result = LatLonPointImpl.lonNormal((double)lon, (double)center);
            assert (result >= center - 180.0);
            assert (result <= center + 180.0);
            assert (result == lon || Math.abs(result - lon) == 360.0 || Math.abs(result - lon) == 720.0);
        }
    }

    public void testLatLonNormal() {
        this.runCenter(10.45454545454547);
        this.runCenter(110.45454545454547);
        this.runCenter(210.45454545454547);
        this.runCenter(-10.45454545454547);
        this.runCenter(-110.45454545454547);
        this.runCenter(-210.45454545454547);
        this.runCenter(310.4545454545455);
    }
}

