/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import ucar.ma2.Array;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.iosp.bufr.MessageScanner;
import ucar.unidata.io.RandomAccessFile;

public class TimeBufr2Xml {
    Formatter out = new Formatter(System.out);
    XMLStreamWriter staxWriter;

    void test(String filename, MClosure closure) throws IOException {
        File f = new File(filename);
        if (!f.exists()) {
            System.out.println(filename + " does not exist");
            return;
        }
        if (f.isDirectory()) {
            this.testAllInDir(f, closure);
        } else {
            try {
                closure.run(f.getPath());
            }
            catch (Exception ioe) {
                System.out.println("Failed on " + f.getPath() + ": " + ioe.getMessage());
                ioe.printStackTrace();
            }
        }
    }

    void testAllInDir(File dir, MClosure closure) {
        List<File> list = Arrays.asList(dir.listFiles());
        Collections.sort(list);
        for (File f : list) {
            if (f.getName().endsWith("bfx") || f.getName().endsWith("txt") || f.getName().endsWith("zip") || f.getName().endsWith("csh") || f.getName().endsWith("rtf")) continue;
            if (f.isDirectory()) {
                this.testAllInDir(f, closure);
                continue;
            }
            try {
                closure.run(f.getPath());
            }
            catch (Exception ioe) {
                System.out.println("Failed on " + f.getPath() + ": " + ioe.getMessage());
                ioe.printStackTrace();
            }
        }
    }

    int scan(String filename) throws IOException {
        long start = System.nanoTime();
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        this.out.format("\nOpen %s size = %d Kb \n", raf.getLocation(), raf.length() / 1000L);
        MessageScanner scan = new MessageScanner(raf);
        int count = 0;
        int bad = 0;
        while (scan.hasNext()) {
            Message m = scan.next();
            if (m == null) continue;
            if (!m.isTablesComplete()) {
                this.out.format("**INCOMPLETE%n", new Object[0]);
                ++bad;
                continue;
            }
            int nbitsCounted = m.getTotalBits();
            if (Math.abs(m.getCountedDataBytes() - m.dataSection.getDataLength()) > 1) {
                this.out.format("**BitCount Fails expect=%d != dataLength=%d%n", m.getCountedDataBytes(), m.dataSection.getDataLength());
                ++bad;
                continue;
            }
            byte[] mbytes = scan.getMessageBytesFromLast(m);
            NetcdfFile ncfile = NetcdfFile.openInMemory((String)"test", (byte[])mbytes);
            NetcdfDataset ncd = new NetcdfDataset(ncfile);
            this.writeMessage(m, (NetcdfFile)ncd);
            ++count;
        }
        raf.close();
        long took = System.nanoTime() - start;
        double rate = took > 0L ? 1000000.0 * (double)count / (double)took : 0.0;
        this.out.format("----nmsgs= %d bad=%d nobs = %d took %d msecs rate = %f msgs/msec\n", count, bad, scan.getTotalObs(), took / 1000000L, rate);
        return scan.getTotalObs();
    }

    void writeMessage(Message message, NetcdfFile ncfile) {
        Indent indent = new Indent(1);
        indent.setIndentLevel(1);
        try {
            this.staxWriter.writeCharacters("\n");
            this.staxWriter.writeCharacters(indent.toString());
            this.staxWriter.writeStartElement("bufrMessage");
            this.staxWriter.writeAttribute("nobs", Integer.toString(message.getNumberDatasets()));
            indent.incr();
            this.staxWriter.writeCharacters("\n");
            this.staxWriter.writeCharacters(indent.toString());
            this.staxWriter.writeStartElement("center");
            this.staxWriter.writeCharacters(message.getCenterName());
            this.staxWriter.writeEndElement();
            this.staxWriter.writeCharacters("\n");
            this.staxWriter.writeCharacters(indent.toString());
            this.staxWriter.writeStartElement("table");
            this.staxWriter.writeCharacters(message.getTableName());
            this.staxWriter.writeEndElement();
            this.staxWriter.writeCharacters("\n");
            this.staxWriter.writeCharacters(indent.toString());
            this.staxWriter.writeStartElement("category");
            this.staxWriter.writeCharacters(message.getCategoryFullName());
            this.staxWriter.writeEndElement();
            Structure obs = (Structure)ncfile.findVariable("obs");
            ArrayStructure obsData = (ArrayStructure)obs.read();
            StructureDataIterator sdataIter = obsData.getStructureDataIterator();
            while (sdataIter.hasNext()) {
                StructureData sdata = sdataIter.next();
                this.staxWriter.writeCharacters("\n");
                this.staxWriter.writeCharacters(indent.toString());
                this.staxWriter.writeStartElement("obs");
                indent.incr();
                for (StructureMembers.Member m : sdata.getMembers()) {
                    Array mdata = sdata.getArray(m);
                    Variable v = obs.findVariable(m.getName());
                    if (m.getDataType().isString() || m.getDataType().isNumeric()) {
                        this.writeVariable((VariableDS)v, mdata, indent);
                        continue;
                    }
                    if (m.getDataType() == DataType.STRUCTURE) {
                        this.writeStructureArray((Structure)v, (ArrayStructure)mdata, indent);
                        continue;
                    }
                    if (m.getDataType() != DataType.SEQUENCE) continue;
                    this.writeSequence((Structure)v, (ArraySequence)mdata, indent);
                }
                indent.decr();
                this.staxWriter.writeCharacters("\n");
                this.staxWriter.writeCharacters(indent.toString());
                this.staxWriter.writeEndElement();
            }
            indent.decr();
            this.staxWriter.writeCharacters("\n");
            this.staxWriter.writeCharacters(indent.toString());
            this.staxWriter.writeEndElement();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    void writeStructureArray(Structure s, ArrayStructure data, Indent indent) throws IOException, XMLStreamException {
        StructureDataIterator sdataIter = data.getStructureDataIterator();
        while (sdataIter.hasNext()) {
            StructureData sdata = sdataIter.next();
            this.staxWriter.writeCharacters("\n");
            this.staxWriter.writeCharacters(indent.toString());
            this.staxWriter.writeStartElement(s.getShortName());
            indent.incr();
            for (StructureMembers.Member m : sdata.getMembers()) {
                Variable v = s.findVariable(m.getName());
                if (!m.getDataType().isString() && !m.getDataType().isNumeric()) continue;
                this.writeVariable((VariableDS)v, sdata.getArray(m), indent);
            }
            indent.decr();
            this.staxWriter.writeCharacters("\n");
            this.staxWriter.writeCharacters(indent.toString());
            this.staxWriter.writeEndElement();
        }
    }

    void writeSequence(Structure s, ArraySequence data, Indent indent) throws IOException, XMLStreamException {
        StructureDataIterator sdataIter = data.getStructureDataIterator();
        while (sdataIter.hasNext()) {
            StructureData sdata = sdataIter.next();
            this.staxWriter.writeCharacters("\n");
            this.staxWriter.writeCharacters(indent.toString());
            this.staxWriter.writeStartElement(s.getShortName());
            indent.incr();
            for (StructureMembers.Member m : sdata.getMembers()) {
                Variable v = s.findVariable(m.getName());
                if (!m.getDataType().isString() && !m.getDataType().isNumeric()) continue;
                this.writeVariable((VariableDS)v, sdata.getArray(m), indent);
            }
            indent.decr();
            this.staxWriter.writeCharacters("\n");
            this.staxWriter.writeCharacters(indent.toString());
            this.staxWriter.writeEndElement();
        }
    }

    void writeVariable(VariableDS v, Array mdata, Indent indent) throws XMLStreamException, IOException {
        this.staxWriter.writeCharacters("\n");
        this.staxWriter.writeCharacters(indent.toString());
        this.staxWriter.writeStartElement("data");
        String name = v.getShortName();
        this.staxWriter.writeAttribute("name", name);
        String units = v.getUnitsString();
        if (units != null && !units.equals(name) && !units.startsWith("Code")) {
            this.staxWriter.writeAttribute("units", v.getUnitsString());
        }
        String desc = v.findAttribute("BUFR:TableB_descriptor").getStringValue();
        this.staxWriter.writeAttribute("Bufr", desc);
        if (v.getDataType().isNumeric()) {
            mdata.hasNext();
            double val = mdata.nextDouble();
            if (v.isMissing(val)) {
                this.staxWriter.writeCharacters("missing");
            } else if (v.getDataType() == DataType.FLOAT || v.getDataType() == DataType.DOUBLE) {
                Attribute bitWidthAtt = v.findAttribute("BUFR:bitWidth");
                int bitWidth = bitWidthAtt.getNumericValue().intValue();
                double sigDigitsD = Math.log10(2 << bitWidth);
                int sigDigits = (int)(sigDigitsD + 1.0);
                Formatter stringFormatter = new Formatter();
                String format = "%." + sigDigits + "g";
                stringFormatter.format(format, val);
                this.staxWriter.writeCharacters(stringFormatter.toString());
            } else {
                this.staxWriter.writeCharacters(mdata.toString());
            }
        } else {
            this.staxWriter.writeCharacters(mdata.toString());
        }
        this.staxWriter.writeEndElement();
    }

    void read2xml() throws IOException, XMLStreamException {
        XMLOutputFactory fac = XMLOutputFactory.newInstance();
        String fileout = "D:/bufr/out/test5.xml.gzip";
        FileOutputStream fos = new FileOutputStream(fileout);
        GZIPOutputStream zos = new GZIPOutputStream(fos);
        this.staxWriter = fac.createXMLStreamWriter(zos, "UTF-8");
        this.staxWriter.writeStartDocument("UTF-8", "1.0");
        this.staxWriter.writeCharacters("\n");
        this.staxWriter.writeStartElement("bufrMessages");
        String filename = "D:/bufr/mlodeSorted/IUSUV1KWBC.bufr";
        this.test(filename, new MClosure(){

            @Override
            public void run(String filename) throws IOException {
                TimeBufr2Xml.this.scan(filename);
            }
        });
        this.staxWriter.writeCharacters("\n");
        this.staxWriter.writeEndDocument();
        this.staxWriter.flush();
        zos.close();
        this.out.flush();
    }

    public static void main(String[] args) throws IOException, XMLStreamException {
        TimeBufr2Xml test = new TimeBufr2Xml();
        test.read2xml();
    }

    private static class Indent {
        private int nspaces = 0;
        private int level = 0;
        private StringBuilder blanks;
        private String indent = "";

        public Indent(int nspaces) {
            this.nspaces = nspaces;
            this.blanks = new StringBuilder();
            for (int i = 0; i < 100 * nspaces; ++i) {
                this.blanks.append(" ");
            }
        }

        public Indent incr() {
            ++this.level;
            this.setIndentLevel(this.level);
            return this;
        }

        public Indent decr() {
            --this.level;
            this.setIndentLevel(this.level);
            return this;
        }

        public String toString() {
            return this.indent;
        }

        public void setIndentLevel(int level) {
            this.level = level;
            this.indent = this.blanks.substring(0, level * this.nspaces);
        }
    }

    static interface MClosure {
        public void run(String var1) throws IOException;
    }
}

