/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import junit.framework.TestCase;
import ucar.nc2.TestAll;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.util.URLnaming;

public class TestDatasetURL
extends TestCase {
    public TestDatasetURL(String name) {
        super(name);
    }

    public void testBlanks() {
        this.testResolve("file:/test/me/", "blank in dir", "file:/test/me/blank in dir");
    }

    public void testNcML() throws IOException {
        String dir = TestAll.cdmUnitTestDir;
        String ncml = "<?xml version='1.0' encoding='UTF-8'?>\n<netcdf xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2'>\n <aggregation type='joinNew' dimName='fake'>\n  <netcdf location='" + dir + "tds/dir mit blank/20070101.nc' coord='1'/>\n" + "  <netcdf location='" + dir + "tds/dir mit blank/20070301.nc' coord='2'/>\n" + " </aggregation>\n" + "</netcdf> ";
        NetcdfDataset ncfile = NcMLReader.readNcML((Reader)new StringReader(ncml), null);
        System.out.printf("result=%s %n", ncfile);
        ncfile.close();
    }

    public void testMisc() {
        this.test("file:test/dir");
        this.test("file:/test/dir");
        this.test("file://test/dir");
        this.test("file:///test/dir");
        this.test("file:C:/Program Files (x86)/Apache Software Foundation/Tomcat 5.0/content/thredds/cache");
        this.test("file:C:\\Program Files (x86)\\Apache Software Foundation\\Tomcat 5.0\\content\\thredds\\cache");
        this.test("http://localhost:8080/thredds/catalog.html?hi=lo");
    }

    public void testResolve() {
        this.testResolve("http://test/me/", "wanna", "http://test/me/wanna");
        this.testResolve("http://test/me/", "/wanna", "http://test/wanna");
        this.testResolve("file:/test/me/", "wanna", "file:/test/me/wanna");
        this.testResolve("file:/test/me/", "/wanna", "/wanna");
        this.testResolve("file://test/me/", "http:/wanna", "http:/wanna");
        this.testResolve("file://test/me/", "file:/wanna", "file:/wanna");
        this.testResolve("file://test/me/", "C:/wanna", "C:/wanna");
        this.testResolve("http://test/me/", "file:wanna", "file:wanna");
    }

    public void testReletiveFile() throws MalformedURLException, URISyntaxException {
        URL url = new URL("file:src/test/data/ncml/nc/");
        this.test("src/test/data/ncml/nc/");
        URI uri = new URI("src/test/data/ncml/nc/");
        this.test("file:/src/test/data/ncml/nc/");
        uri = new URI("file:/src/test/data/ncml/nc/");
        new File(uri);
        this.test("file:src/test/data/ncml/nc/");
        uri = new URI("file:src/test/data/ncml/nc/");
    }

    public void testDods() throws URISyntaxException {
        String uriString = "http://test.opendap.org:8080/dods/dts/test.53.dods?types[0:1:9]";
        URI uri = new URI(uriString);
    }

    private void test(String uriS) {
        System.out.println(uriS);
        try {
            URI uri = URI.create(uriS);
            System.out.println(" scheme=" + uri.getScheme());
            System.out.println(" getSchemeSpecificPart=" + uri.getSchemeSpecificPart());
            System.out.println(" getAuthority=" + uri.getAuthority());
            System.out.println(" getPath=" + uri.getPath());
            System.out.println(" getQuery=" + uri.getQuery());
            System.out.println(" isAbsolute=" + uri.isAbsolute());
            System.out.println(" isOpaque=" + uri.isOpaque());
            System.out.println();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void testResolve(String base, String rel, String result) {
        System.out.println("\nbase= " + base);
        System.out.println("rel= " + rel);
        System.out.println("resolve= " + URLnaming.resolve((String)base, (String)rel));
        if (result != null) assert (URLnaming.resolve((String)base, (String)rel).equals(result));
    }
}

