/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.NcMLReader;

public class TestOffAggUpdating
extends TestCase {
    public TestOffAggUpdating(String name) {
        super(name);
    }

    public void testUpdate() throws IOException, InvalidRangeException, InterruptedException {
        String dir = TestAll.cdmUnitTestDir + "agg/updating";
        File dirFile = new File(dir);
        assert (dirFile != null);
        assert (dirFile.exists());
        assert (dirFile.isDirectory());
        for (File f : dirFile.listFiles()) {
            if (!f.getName().equals("extra.nc")) continue;
            if (f.renameTo(new File(dirFile, "extra.wait"))) break;
            System.out.printf("Rename fails on %s.extra.nc %n", dirFile);
            break;
        }
        String ncml = "<?xml version='1.0' encoding='UTF-8'?>\n<netcdf xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2'>\n       <aggregation dimName='time' type='joinExisting' recheckEvery='1 nsec'>\n         <scan location='" + dir + "' suffix='*.nc' />\n" + "         <variable name='depth'>\n" + "           <attribute name='coordinates' value='lon lat'/>\n" + "         </variable>\n" + "         <variable name='wvh'>\n" + "           <attribute name='coordinates' value='lon lat'/>\n" + "         </variable>\n" + "       </aggregation>\n" + "       <attribute name='Conventions' type='String' value='CF-1.0'/>\n" + "</netcdf>";
        String location = dir + "agg/updating.ncml";
        System.out.println(" TestOffAggExistingTimeUnitsChange.testNarrGrib=\n" + ncml);
        NetcdfDataset ncfile = NcMLReader.readNcML((Reader)new StringReader(ncml), (String)location, null);
        this.check((NetcdfFile)ncfile, 12);
        for (File f : dirFile.listFiles()) {
            if (!f.getName().equals("extra.wait")) continue;
            if (f.renameTo(new File(dirFile, "extra.nc"))) break;
            System.out.println(" rename fails on " + f.getPath());
            break;
        }
        ncfile.sync();
        this.check((NetcdfFile)ncfile, 18);
        ncfile.close();
    }

    private void check(NetcdfFile ncfile, int n) throws IOException, InvalidRangeException {
        Variable v = ncfile.findVariable("time");
        assert (v != null);
        System.out.printf(" time= %s%n", v.getNameAndDimensions());
        assert (v.getSize() == (long)n) : v.getSize();
        v = ncfile.findVariable("eta");
        assert (v != null);
        assert (v.getRank() == 3) : v.getRank();
    }
}

