/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.ncml.TestNcML;

public class TestOffAggNewSync
extends TestCase {
    String dataDir = "//shemp/data/testdata/image/testSync/";
    private String aggExistingSync = "<?xml version='1.0' encoding='UTF-8'?>\n<netcdf xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2'>\n  <aggregation  dimName='time' type='joinExisting' recheckEvery='1 sec' >\n    <variableAgg name='IR_WV'/>\n    <scan location='//shemp/data/testdata/image/testSync' suffix='.gini' dateFormatMark='SUPER-NATIONAL_8km_WV_#yyyyMMdd_HHmm'/>\n  </aggregation>\n</netcdf>";

    public TestOffAggNewSync(String name) {
        super(name);
    }

    public void testMove() throws IOException, InterruptedException {
        this.move(this.dataDir + "SUPER-NATIONAL_8km_WV_20051128_2100.gini");
        String filename = "file:./" + TestNcML.topDir + "offsite/aggExistingSync.xml";
        NetcdfDataset ncfile = NcMLReader.readNcML((String)filename, null);
        this.testAggCoordVar((NetcdfFile)ncfile, 7);
        ncfile.close();
        this.moveBack(this.dataDir + "SUPER-NATIONAL_8km_WV_20051128_2100.gini");
        ncfile = NcMLReader.readNcML((String)filename, null);
        this.testAggCoordVar((NetcdfFile)ncfile, 8);
        ncfile.close();
    }

    public void testRemove() throws IOException, InterruptedException {
        NetcdfDataset ncfile = NcMLReader.readNcML((Reader)new StringReader(this.aggExistingSync), (String)"aggExistingSync", null);
        this.testAggCoordVar((NetcdfFile)ncfile, 8);
        System.out.println("");
        ncfile.close();
        boolean ok = this.move(this.dataDir + "SUPER-NATIONAL_8km_WV_20051128_2100.gini");
        int nfiles = ok ? 7 : 8;
        ncfile = NcMLReader.readNcML((Reader)new StringReader(this.aggExistingSync), (String)"aggExistingSync", null);
        this.testAggCoordVar((NetcdfFile)ncfile, nfiles);
        ncfile.close();
        this.moveBack(this.dataDir + "SUPER-NATIONAL_8km_WV_20051128_2100.gini");
    }

    public void testSync() throws IOException, InterruptedException {
        this.move(this.dataDir + "SUPER-NATIONAL_8km_WV_20051128_2100.gini");
        NetcdfDataset ncfile = NcMLReader.readNcML((Reader)new StringReader(this.aggExistingSync), (String)"aggExistingSync", null);
        this.testAggCoordVar((NetcdfFile)ncfile, 7);
        this.moveBack(this.dataDir + "SUPER-NATIONAL_8km_WV_20051128_2100.gini");
        Thread.sleep(2000L);
        ncfile.sync();
        this.testAggCoordVar((NetcdfFile)ncfile, 8);
        ncfile.close();
    }

    public void testSyncRemove() throws IOException, InterruptedException {
        NetcdfDataset ncfile = NcMLReader.readNcML((Reader)new StringReader(this.aggExistingSync), (String)"aggExistingSync", null);
        this.testAggCoordVar((NetcdfFile)ncfile, 8);
        System.out.println("");
        boolean ok = this.move(this.dataDir + "SUPER-NATIONAL_8km_WV_20051128_2100.gini");
        int nfiles = ok ? 7 : 8;
        Thread.sleep(2000L);
        ncfile.sync();
        this.testAggCoordVar((NetcdfFile)ncfile, nfiles);
        ncfile.close();
        this.moveBack(this.dataDir + "SUPER-NATIONAL_8km_WV_20051128_2100.gini");
    }

    public void testAggCoordVar(NetcdfFile ncfile, int n) throws IOException {
        Variable time = ncfile.findVariable("time");
        assert (null != time);
        assert (time.getName().equals("time"));
        assert (time.getRank() == 1);
        assert (time.getSize() == (long)n) : time.getSize() + " != " + n;
        assert (time.getShape()[0] == n);
        assert (time.getDataType() == DataType.DOUBLE);
        assert (time.getDimension(0) == ncfile.findDimension("time"));
        Array data = time.read();
        assert (data.getRank() == 1);
        assert (data.getSize() == (long)n);
        assert (data.getShape()[0] == n);
        assert (data.getElementType() == Double.TYPE);
        double prev = Double.NaN;
        IndexIterator dataI = data.getIndexIterator();
        while (dataI.hasNext()) {
            double dval = dataI.getDoubleNext();
            System.out.println(" coord=" + dval);
            assert (Double.isNaN(prev) || dval > prev);
            prev = dval;
        }
    }

    boolean move(String filename) {
        File f = new File(filename);
        if (f.exists()) {
            return f.renameTo(new File(filename + ".save"));
        }
        return false;
    }

    void moveBack(String filename) {
        File f = new File(filename + ".save");
        f.renameTo(new File(filename));
    }
}

