/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.IOException;
import java.net.MalformedURLException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.TestUtils;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.ncml.TestNcML;
import ucar.nc2.util.CompareNetcdf;

public class TestAggUnionSimple
extends TestCase {
    static NetcdfFile ncfile = null;

    public TestAggUnionSimple(String name) {
        super(name);
    }

    public void setUp() {
        block4: {
            if (ncfile != null) {
                return;
            }
            String filename = "file:./" + TestNcML.topDir + "aggUnionSimple.xml";
            try {
                ncfile = NetcdfDataset.openDataset((String)filename, (boolean)false, null);
            }
            catch (MalformedURLException e) {
                System.out.println("bad URL error = " + e);
            }
            catch (IOException e) {
                System.out.println("IO error = " + e);
                e.printStackTrace();
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    public void tearDown() throws IOException {
        if (ncfile != null) {
            ncfile.close();
        }
        ncfile = null;
    }

    public void testDataset() {
        Variable v = ncfile.findVariable("lflx");
        assert (v instanceof VariableDS);
        VariableDS vds = (VariableDS)v;
        assert (vds.getOriginalDataType() == v.getDataType());
        Variable org = vds.getOriginalVariable();
        assert (vds.getOriginalDataType() == org.getDataType());
        assert (!(org instanceof VariableDS));
        assert (v.getParentGroup().equals((Object)org.getParentGroup()));
        assert (v.getParentGroup() != org.getParentGroup());
    }

    public void testRead() {
        System.out.println("ncfile = " + ncfile);
        TestUtils.testReadData(ncfile, true);
    }

    public void testStructure() {
        System.out.println("TestNested = \n" + ncfile);
        Attribute att = ncfile.findGlobalAttribute("title");
        assert (null != att);
        assert (!att.isArray());
        assert (att.isString());
        assert (att.getDataType() == DataType.STRING);
        assert (att.getStringValue().equals("Union cldc and lflx"));
        assert (att.getNumericValue() == null);
        assert (att.getNumericValue(3) == null);
        Dimension latDim = ncfile.findDimension("lat");
        assert (null != latDim);
        assert (latDim.getName().equals("lat"));
        assert (latDim.getLength() == 21);
        assert (!latDim.isUnlimited());
        Dimension timeDim = ncfile.findDimension("time");
        assert (null != timeDim);
        assert (timeDim.getName().equals("time"));
        assert (timeDim.getLength() == 456);
        assert (!timeDim.isUnlimited());
    }

    public void testReadCoordvar() {
        Variable lat = ncfile.findVariable("lat");
        assert (null != lat);
        assert (lat.getName().equals("lat"));
        assert (lat.getRank() == 1);
        assert (lat.getSize() == 21L);
        assert (lat.getShape()[0] == 21);
        assert (lat.getDataType() == DataType.FLOAT);
        assert (lat.isCoordinateVariable());
        assert (!lat.isUnlimited());
        assert (lat.getDimension(0).equals((Object)ncfile.findDimension("lat")));
        Attribute att = lat.findAttribute("units");
        assert (null != att);
        assert (!att.isArray());
        assert (att.isString());
        assert (att.getDataType() == DataType.STRING);
        assert (att.getStringValue().equals("degrees_north"));
        assert (att.getNumericValue() == null);
        assert (att.getNumericValue(3) == null);
        try {
            Array data = lat.read();
            assert (data.getRank() == 1);
            assert (data.getSize() == 21L);
            assert (data.getShape()[0] == 21);
            assert (data.getElementType() == Float.TYPE);
            IndexIterator dataI = data.getIndexIterator();
            assert (TestAll.closeEnough(dataI.getDoubleNext(), 10.0));
            assert (TestAll.closeEnough(dataI.getDoubleNext(), 9.0));
            assert (TestAll.closeEnough(dataI.getDoubleNext(), 8.0));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testReadData() {
        Variable v = ncfile.findVariable("lflx");
        assert (null != v);
        assert (v.getName().equals("lflx"));
        assert (v.getRank() == 3);
        assert (v.getSize() == 3447360L);
        assert (v.getShape()[0] == 456);
        assert (v.getShape()[1] == 21);
        assert (v.getShape()[2] == 360);
        assert (v.getDataType() == DataType.SHORT) : v.getDataType();
        assert (!v.isCoordinateVariable());
        assert (!v.isUnlimited());
        assert (v.getDimension(0).equals((Object)ncfile.findDimension("time")));
        assert (v.getDimension(1).equals((Object)ncfile.findDimension("lat")));
        assert (v.getDimension(2).equals((Object)ncfile.findDimension("lon")));
        Attribute att = v.findAttribute("units");
        assert (null != att);
        assert (!att.isArray());
        assert (att.isString());
        assert (att.getDataType() == DataType.STRING);
        assert (att.getStringValue().equals("grams/kg m/s"));
        assert (att.getNumericValue() == null);
        assert (att.getNumericValue(3) == null);
        try {
            Array data = v.read();
            assert (data.getRank() == 3);
            assert (data.getSize() == 3447360L);
            assert (data.getShape()[0] == 456);
            assert (data.getShape()[1] == 21);
            assert (data.getShape()[2] == 360);
            assert (data.getElementType() == Short.TYPE);
            IndexIterator dataI = data.getIndexIterator();
            assert (32766 == dataI.getShortNext());
            assert (32766 == dataI.getShortNext());
            assert (32766 == dataI.getShortNext());
            assert (32766 == dataI.getShortNext());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testReadSlice() {
        block15: {
            Variable v = ncfile.findVariable("lflx");
            int[] origin = new int[]{0, 6, 5};
            int[] shape = new int[]{1, 2, 3};
            try {
                Array data = v.read(origin, shape).reduce();
                assert (data.getRank() == 2);
                assert (data.getSize() == 6L);
                assert (data.getShape()[0] == 2);
                assert (data.getShape()[1] == 3);
                assert (data.getElementType() == Short.TYPE);
                IndexIterator dataI = data.getIndexIterator();
                assert (dataI.getShortNext() == -22711);
                assert (dataI.getShortNext() == -22239);
                assert (dataI.getShortNext() == -22585);
                assert (dataI.getShortNext() == -22670);
                assert (dataI.getShortNext() == 32766);
                assert (dataI.getShortNext() == 32766);
            }
            catch (InvalidRangeException io) {
                assert (false);
            }
            catch (IOException io) {
                io.printStackTrace();
                if ($assertionsDisabled) break block15;
                throw new AssertionError();
            }
        }
    }

    public void testScan() throws IOException {
        String filename = "file:./" + TestNcML.topDir + "aggUnionScan.xml";
        NetcdfDataset scanFile = NetcdfDataset.openDataset((String)filename, (boolean)false, null);
        CompareNetcdf.compareFiles((NetcdfFile)ncfile, (NetcdfFile)scanFile, (boolean)true, (boolean)true, (boolean)false);
        scanFile.close();
    }

    public void testRename() throws IOException {
        String filename = "file:./" + TestNcML.topDir + "aggUnionRename.xml";
        NetcdfDataset scanFile = NetcdfDataset.openDataset((String)filename, (boolean)false, null);
        Variable v = scanFile.findVariable("LavaFlow");
        assert (v != null);
        scanFile.close();
    }
}

