/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayObject;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ncml.TestNcML;
import ucar.nc2.util.NamedObject;

public class TestAggSynGrid
extends TestCase {
    static ucar.nc2.dt.GridDataset gds = null;
    String filename = "file:./" + TestNcML.topDir + "aggSynGrid.xml";

    public TestAggSynGrid(String name) {
        super(name);
    }

    public void setUp() throws IOException {
        if (gds != null) {
            return;
        }
        gds = GridDataset.open((String)this.filename);
    }

    public void tearDown() throws IOException {
        if (gds != null) {
            gds.close();
        }
        gds = null;
    }

    public void testGrid() {
        GridDatatype grid = gds.findGridDatatype("T");
        assert (null != grid);
        assert (grid.getName().equals("T"));
        assert (grid.getRank() == 3);
        assert (grid.getDataType() == DataType.DOUBLE);
        GridCoordSystem gcsys = grid.getCoordinateSystem();
        assert (gcsys.getYHorizAxis() != null);
        assert (gcsys.getXHorizAxis() != null);
        assert (gcsys.getTimeAxis() != null);
        CoordinateAxis1DTime taxis = gcsys.getTimeAxis1D();
        assert (taxis.getDataType() == DataType.STRING) : taxis.getDataType();
        List names = taxis.getNames();
        Date[] dates = taxis.getTimeDates();
        assert (dates != null);
        for (int i = 0; i < dates.length; ++i) {
            Date d = dates[i];
            NamedObject name = (NamedObject)names.get(i);
            System.out.println(name.getName() + " == " + d);
        }
    }

    public void testDimensions() {
        NetcdfFile ncfile = gds.getNetcdfFile();
        Dimension latDim = ncfile.findDimension("lat");
        assert (null != latDim);
        assert (latDim.getName().equals("lat"));
        assert (latDim.getLength() == 3);
        assert (!latDim.isUnlimited());
        Dimension lonDim = ncfile.findDimension("lon");
        assert (null != lonDim);
        assert (lonDim.getName().equals("lon"));
        assert (lonDim.getLength() == 4);
        assert (!lonDim.isUnlimited());
        Dimension timeDim = ncfile.findDimension("time");
        assert (null != timeDim);
        assert (timeDim.getName().equals("time"));
        assert (timeDim.getLength() == 3);
    }

    public void testCoordVar() {
        NetcdfFile ncfile = gds.getNetcdfFile();
        Variable lat = ncfile.findVariable("lat");
        assert (null != lat);
        assert (lat.getName().equals("lat"));
        assert (lat.getRank() == 1);
        assert (lat.getSize() == 3L);
        assert (lat.getShape()[0] == 3);
        assert (lat.getDataType() == DataType.FLOAT);
        assert (!lat.isUnlimited());
        assert (lat.getDimension(0).equals((Object)ncfile.findDimension("lat")));
        Attribute att = lat.findAttribute("units");
        assert (null != att);
        assert (!att.isArray());
        assert (att.isString());
        assert (att.getDataType() == DataType.STRING);
        assert (att.getStringValue().equals("degrees_north"));
        assert (att.getNumericValue() == null);
        assert (att.getNumericValue(3) == null);
        try {
            Array data = lat.read();
            assert (data.getRank() == 1);
            assert (data.getSize() == 3L);
            assert (data.getShape()[0] == 3);
            assert (data.getElementType() == Float.TYPE);
            IndexIterator dataI = data.getIndexIterator();
            assert (TestAll.closeEnough(dataI.getDoubleNext(), 41.0));
            assert (TestAll.closeEnough(dataI.getDoubleNext(), 40.0));
            assert (TestAll.closeEnough(dataI.getDoubleNext(), 39.0));
        }
        catch (IOException io) {
            // empty catch block
        }
    }

    public void testAggCoordVar() throws IOException {
        NetcdfFile ncfile = gds.getNetcdfFile();
        Variable time = ncfile.findVariable("time");
        assert (null != time);
        assert (time.getName().equals("time"));
        assert (time.getRank() == 1) : time.getRank();
        assert (time.getShape()[0] == 3);
        assert (time.getDataType() == DataType.STRING) : time.getDataType();
        assert (time.getDimension(0) == ncfile.findDimension("time"));
        int count = 0;
        String[] want = new String[]{"2005-11-22 22:19:53Z", "2005-11-22 23:19:53Z", "2005-11-23 00:19:59Z"};
        Array data = time.read();
        assert (data instanceof ArrayObject);
        while (data.hasNext()) {
            assert (want[count++].equals(data.next()));
        }
    }

    public void testReadData() {
        block24: {
            NetcdfFile ncfile = gds.getNetcdfFile();
            Variable v = ncfile.findVariable("T");
            assert (null != v);
            assert (v.getName().equals("T"));
            assert (v.getRank() == 3);
            assert (v.getSize() == 36L) : v.getSize();
            assert (v.getShape()[0] == 3);
            assert (v.getShape()[1] == 3);
            assert (v.getShape()[2] == 4);
            assert (v.getDataType() == DataType.DOUBLE);
            assert (!v.isCoordinateVariable());
            assert (v.getDimension(0) == ncfile.findDimension("time"));
            assert (v.getDimension(1) == ncfile.findDimension("lat"));
            assert (v.getDimension(2) == ncfile.findDimension("lon"));
            try {
                Array data = v.read();
                assert (data.getRank() == 3);
                assert (data.getSize() == 36L);
                assert (data.getShape()[0] == 3);
                assert (data.getShape()[1] == 3);
                assert (data.getShape()[2] == 4);
                assert (data.getElementType() == Double.TYPE);
                int[] shape = data.getShape();
                Index tIndex = data.getIndex();
                for (int i = 0; i < shape[0]; ++i) {
                    for (int j = 0; j < shape[1]; ++j) {
                        for (int k = 0; k < shape[2]; ++k) {
                            double val = data.getDouble(tIndex.set(i, j, k));
                            assert (TestAll.closeEnough(val, (double)(100 * i + 10 * j + k))) : val;
                        }
                    }
                }
            }
            catch (IOException io) {
                io.printStackTrace();
                if ($assertionsDisabled) break block24;
                throw new AssertionError();
            }
        }
    }

    public void readSlice(int[] origin, int[] shape) {
        block14: {
            NetcdfFile ncfile = gds.getNetcdfFile();
            Variable v = ncfile.findVariable("T");
            try {
                Array data = v.read(origin, shape);
                assert (data.getRank() == 3);
                assert (data.getSize() == (long)(shape[0] * shape[1] * shape[2]));
                assert (data.getShape()[0] == shape[0]) : data.getShape()[0] + " " + shape[0];
                assert (data.getShape()[1] == shape[1]);
                assert (data.getShape()[2] == shape[2]);
                assert (data.getElementType() == Double.TYPE);
                Index tIndex = data.getIndex();
                for (int i = 0; i < shape[0]; ++i) {
                    for (int j = 0; j < shape[1]; ++j) {
                        for (int k = 0; k < shape[2]; ++k) {
                            double val = data.getDouble(tIndex.set(i, j, k));
                            assert (TestAll.closeEnough(val, (double)(100 * (i + origin[0]) + 10 * j + k))) : val;
                        }
                    }
                }
            }
            catch (InvalidRangeException io) {
                assert (false);
            }
            catch (IOException io) {
                io.printStackTrace();
                if ($assertionsDisabled) break block14;
                throw new AssertionError();
            }
        }
    }

    public void testReadSlice() {
        this.readSlice(new int[]{0, 0, 0}, new int[]{3, 3, 4});
        this.readSlice(new int[]{0, 0, 0}, new int[]{2, 3, 2});
        this.readSlice(new int[]{2, 0, 0}, new int[]{1, 3, 4});
        this.readSlice(new int[]{1, 0, 0}, new int[]{2, 2, 3});
    }
}

