/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.NCdump;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.ncml.TestNcML;

public class TestAggExistingPromote
extends TestCase {
    public TestAggExistingPromote(String name) {
        super(name);
    }

    public void testWithDateFormatMark() throws Exception, InvalidRangeException {
        NetcdfDataset ncfile;
        block28: {
            String filename = "file:" + TestNcML.topDir + "aggExistingPromote.ncml";
            String aggExistingPromote = "<?xml version='1.0' encoding='UTF-8'?>\n<netcdf xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2'>\n  <aggregation dimName='time' type='joinExisting' recheckEvery='4 sec'>\n    <promoteGlobalAttribute name='times' orgName='time_coverage_end' />\n    <scan dateFormatMark='CG#yyyyDDD_HHmmss' location='nc/cg/' suffix='.nc' subdirs='false' />\n  </aggregation>\n</netcdf>";
            ncfile = NcMLReader.readNcML((Reader)new StringReader(aggExistingPromote), (String)filename, null);
            System.out.println(" TestNcmlAggExisting.open " + filename + "\n" + ncfile);
            Variable pv = ncfile.findVariable("times");
            assert (null != pv);
            assert (pv.getName().equals("times"));
            assert (pv.getRank() == 1);
            assert (pv.getSize() == 3L);
            assert (pv.getShape()[0] == 3);
            assert (pv.getDataType() == DataType.STRING);
            Dimension d = pv.getDimension(0);
            assert (d.getName().equals("time"));
            Array datap = pv.read();
            assert (datap.getRank() == 1);
            assert (datap.getSize() == 3L);
            assert (datap.getShape()[0] == 3);
            assert (datap.getElementType() == String.class);
            NCdump.printArray((Array)datap, (String)"time_coverage_end", (PrintStream)System.out, null);
            String[] resultp = new String[]{"2006-06-07T12:00:00Z", "2006-06-07T13:00:00Z", "2006-06-07T14:00:00Z"};
            int count = 0;
            IndexIterator dataI = datap.getIndexIterator();
            while (dataI.hasNext()) {
                String s = (String)dataI.getObjectNext();
                assert (s.equals(resultp[count])) : s;
                ++count;
            }
            Variable time = ncfile.findVariable("time");
            assert (null != time);
            assert (time.getName().equals("time"));
            assert (time.getRank() == 1);
            assert (time.getSize() == 3L);
            assert (time.getShape()[0] == 3);
            assert (time.getDataType() == DataType.STRING);
            assert (time.getDimension(0) == ncfile.findDimension("time"));
            String[] result = new String[]{"2006-06-07T12:00:00Z", "2006-06-07T13:00:00Z", "2006-06-07T14:00:00Z"};
            try {
                Array data = time.read();
                assert (data.getRank() == 1);
                assert (data.getSize() == 3L);
                assert (data.getShape()[0] == 3);
                assert (data.getElementType() == String.class);
                NCdump.printArray((Array)data, (String)"time coord", (PrintStream)System.out, null);
                count = 0;
                dataI = data.getIndexIterator();
                while (dataI.hasNext()) {
                    String val = (String)dataI.getObjectNext();
                    assert (val.equals(result[count])) : val + " != " + result[count];
                    ++count;
                }
            }
            catch (IOException io) {
                io.printStackTrace();
                if ($assertionsDisabled) break block28;
                throw new AssertionError();
            }
        }
        ncfile.close();
    }

    public void testNotOne() throws IOException, InvalidRangeException {
        String filename = "file:" + TestNcML.topDir + "aggExistingPromote2.ncml";
        String aggExistingPromote2 = "<?xml version='1.0' encoding='UTF-8'?>\n<netcdf xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2'>\n  <aggregation dimName='time' type='joinExisting'>\n    <promoteGlobalAttribute name='title' />\n    <promoteGlobalAttribute name='month' />\n    <promoteGlobalAttribute name='vector' />\n    <netcdf location='file:src/test/data/ncml/nc/jan.nc'>\n      <attribute name='month' value='jan'/>\n      <attribute name='vector' value='1 2 3' type='int'/>\n    </netcdf>\n    <netcdf location='file:src/test/data/ncml/nc/feb.nc'>\n      <attribute name='month' value='feb'/>\n      <attribute name='vector' value='4 5 6' type='int'/>\n    </netcdf>\n  </aggregation>\n</netcdf>";
        NetcdfDataset ncfile = NcMLReader.readNcML((Reader)new StringReader(aggExistingPromote2), (String)filename, null);
        Dimension dim = ncfile.findDimension("time");
        Variable pv = ncfile.findVariable("title");
        assert (null != pv);
        assert (pv.getName().equals("title"));
        assert (pv.getRank() == 1);
        assert (pv.getSize() == (long)dim.getLength());
        assert (pv.getDataType() == DataType.STRING);
        Dimension d = pv.getDimension(0);
        assert (d.getName().equals("time"));
        Array datap = pv.read();
        assert (datap.getRank() == 1);
        assert (datap.getSize() == (long)dim.getLength());
        assert (datap.getElementType() == String.class);
        NCdump.printArray((Array)datap, (String)"title", (PrintStream)System.out, null);
        while (datap.hasNext()) {
            assert (datap.next().equals("Example Data"));
        }
        pv = ncfile.findVariable("month");
        assert (null != pv);
        assert (pv.getName().equals("month"));
        assert (pv.getRank() == 1);
        assert (pv.getSize() == (long)dim.getLength());
        assert (pv.getDataType() == DataType.STRING);
        d = pv.getDimension(0);
        assert (d.getName().equals("time"));
        datap = pv.read();
        assert (datap.getRank() == 1);
        assert (datap.getSize() == (long)dim.getLength());
        assert (datap.getElementType() == String.class);
        NCdump.printArray((Array)datap, (String)"title", (PrintStream)System.out, null);
        int count = 0;
        while (datap.hasNext()) {
            assert (datap.next().equals(count < 31 ? "jan" : "feb")) : count;
            ++count;
        }
        ncfile.close();
    }
}

