/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.NCdump;
import ucar.nc2.TestAll;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.ncml.TestNcML;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateUnit;

public class TestAggExistingCoordVars
extends TestCase {
    String aggExisting2 = "<?xml version='1.0' encoding='UTF-8'?>\n<netcdf xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2'>\n   <variable name='time'>\n     <attribute name='units' value='hours since 2006-06-16 00:00'/>\n     <attribute name='_CoordinateAxisType' value='Time' />\n   </variable>\n  <aggregation type='joinExisting' dimName='time' >\n    <netcdf location='nc/cg/CG2006158_120000h_usfc.nc' ncoords='1' coordValue='12' />\n    <netcdf location='nc/cg/CG2006158_130000h_usfc.nc' ncoords='1' coordValue='13' />\n    <netcdf location='nc/cg/CG2006158_140000h_usfc.nc' ncoords='1' coordValue='14' />\n  </aggregation>\n</netcdf>";

    public TestAggExistingCoordVars(String name) {
        super(name);
    }

    public void testType1() throws IOException, InvalidRangeException {
        NetcdfDataset ncfile;
        block15: {
            String filename = "file:./" + TestNcML.topDir + "aggExisting1.xml";
            ncfile = NcMLReader.readNcML((String)filename, null);
            System.out.println(" TestNcmlAggExisting.open " + filename);
            Variable time = ncfile.findVariable("time");
            assert (null != time);
            assert (time.getName().equals("time"));
            assert (time.getRank() == 1);
            assert (time.getSize() == 59L);
            assert (time.getShape()[0] == 59);
            assert (time.getDataType() == DataType.INT);
            assert (time.getDimension(0) == ncfile.findDimension("time"));
            try {
                Array data = time.read();
                assert (data.getRank() == 1);
                assert (data.getSize() == 59L);
                assert (data.getShape()[0] == 59);
                assert (data.getElementType() == Integer.TYPE);
                int count = 0;
                IndexIterator dataI = data.getIndexIterator();
                while (dataI.hasNext()) {
                    assert (dataI.getIntNext() == 7 + 2 * count);
                    ++count;
                }
            }
            catch (IOException io) {
                io.printStackTrace();
                if ($assertionsDisabled) break block15;
                throw new AssertionError();
            }
        }
        ncfile.close();
    }

    public void testType2() throws IOException, InvalidRangeException {
        NetcdfDataset ncfile;
        block15: {
            String filename = "file:./" + TestNcML.topDir + "aggExisting2.xml";
            ncfile = NcMLReader.readNcML((Reader)new StringReader(this.aggExisting2), (String)filename, null);
            System.out.println(" TestNcmlAggExisting.open " + filename + "\n" + ncfile);
            Variable time = ncfile.findVariable("time");
            assert (null != time);
            assert (time.getName().equals("time"));
            assert (time.getRank() == 1);
            assert (time.getSize() == 3L);
            assert (time.getShape()[0] == 3);
            assert (time.getDataType() == DataType.DOUBLE);
            assert (time.getDimension(0) == ncfile.findDimension("time"));
            double[] result = new double[]{12.0, 13.0, 14.0};
            try {
                Array data = time.read();
                assert (data.getRank() == 1);
                assert (data.getSize() == 3L);
                assert (data.getShape()[0] == 3);
                assert (data.getElementType() == Double.TYPE);
                int count = 0;
                IndexIterator dataI = data.getIndexIterator();
                while (dataI.hasNext()) {
                    double val = dataI.getDoubleNext();
                    assert (TestAll.closeEnough(val, result[count])) : val + " != " + result[count];
                    ++count;
                }
            }
            catch (IOException io) {
                io.printStackTrace();
                if ($assertionsDisabled) break block15;
                throw new AssertionError();
            }
        }
        ncfile.close();
    }

    public void testType3() throws IOException, InvalidRangeException {
        NetcdfDataset ncfile;
        block17: {
            String filename = "file:./" + TestNcML.topDir + "aggExisting.xml";
            ncfile = NcMLReader.readNcML((String)filename, null);
            System.out.println(" TestNcmlAggExisting.open " + filename + "\n" + ncfile);
            Variable time = ncfile.findVariable("time");
            assert (null != time);
            String testAtt = ncfile.findAttValueIgnoreCase(time, "ncmlAdded", null);
            assert (testAtt != null);
            assert (testAtt.equals("timeAtt"));
            assert (time.getName().equals("time"));
            assert (time.getRank() == 1);
            assert (time.getSize() == 59L);
            assert (time.getShape()[0] == 59);
            assert (time.getDataType() == DataType.INT);
            assert (time.getDimension(0) == ncfile.findDimension("time"));
            try {
                Array data = time.read();
                assert (data.getRank() == 1);
                assert (data.getSize() == 59L);
                assert (data.getShape()[0] == 59);
                assert (data.getElementType() == Integer.TYPE);
                int count = 0;
                IndexIterator dataI = data.getIndexIterator();
                while (dataI.hasNext()) {
                    assert (dataI.getIntNext() == count++);
                }
            }
            catch (IOException io) {
                io.printStackTrace();
                if ($assertionsDisabled) break block17;
                throw new AssertionError();
            }
        }
        ncfile.close();
    }

    public void testType4() throws IOException, InvalidRangeException {
        NetcdfDataset ncfile;
        block15: {
            String filename = "file:" + TestNcML.topDir + "aggExisting4.ncml";
            ncfile = NcMLReader.readNcML((String)filename, null);
            Variable time = ncfile.findVariable("time");
            assert (null != time);
            assert (time.getName().equals("time"));
            assert (time.getRank() == 1);
            assert (time.getSize() == 3L);
            assert (time.getShape()[0] == 3);
            assert (time.getDataType() == DataType.DOUBLE);
            assert (time.getDimension(0) == ncfile.findDimension("time"));
            double[] result = new double[]{1.1496816E9, 1.1496852E9, 1.1496888E9};
            try {
                Array data = time.read();
                assert (data.getRank() == 1);
                assert (data.getSize() == 3L);
                assert (data.getShape()[0] == 3);
                assert (data.getElementType() == Double.TYPE);
                int count = 0;
                IndexIterator dataI = data.getIndexIterator();
                while (dataI.hasNext()) {
                    assert (TestAll.closeEnough(dataI.getDoubleNext(), result[count]));
                    ++count;
                }
            }
            catch (IOException io) {
                io.printStackTrace();
                if ($assertionsDisabled) break block15;
                throw new AssertionError();
            }
        }
        ncfile.close();
    }

    public void testWithDateFormatMark() throws Exception {
        NetcdfDataset ncfile;
        block15: {
            String filename = "file:" + TestNcML.topDir + "aggExistingOne.xml";
            ncfile = NcMLReader.readNcML((String)filename, null);
            Variable time = ncfile.findVariable("time");
            assert (null != time);
            assert (time.getName().equals("time"));
            assert (time.getRank() == 1);
            assert (time.getSize() == 3L);
            assert (time.getShape()[0] == 3);
            assert (time.getDataType() == DataType.STRING);
            assert (time.getDimension(0) == ncfile.findDimension("time"));
            String[] result = new String[]{"2006-06-07T12:00:00Z", "2006-06-07T13:00:00Z", "2006-06-07T14:00:00Z"};
            try {
                Array data = time.read();
                assert (data.getRank() == 1);
                assert (data.getSize() == 3L);
                assert (data.getShape()[0] == 3);
                assert (data.getElementType() == String.class);
                NCdump.printArray((Array)data, (String)"time coord", (PrintStream)System.out, null);
                int count = 0;
                IndexIterator dataI = data.getIndexIterator();
                while (dataI.hasNext()) {
                    String val = (String)dataI.getObjectNext();
                    assert (val.equals(result[count])) : val + " != " + result[count];
                    ++count;
                }
            }
            catch (IOException io) {
                io.printStackTrace();
                if ($assertionsDisabled) break block15;
                throw new AssertionError();
            }
        }
        ncfile.close();
    }

    public void oldTestWithDateFormatMark() throws Exception {
        NetcdfDataset ncfile;
        block15: {
            String filename = "file:" + TestNcML.topDir + "aggExistingOne.xml";
            ncfile = NcMLReader.readNcML((String)filename, null);
            Variable time = ncfile.findVariable("time");
            assert (null != time);
            assert (time.getName().equals("time"));
            assert (time.getRank() == 1);
            assert (time.getSize() == 3L);
            assert (time.getShape()[0] == 3);
            assert (time.getDataType() == DataType.DOUBLE);
            assert (time.getDimension(0) == ncfile.findDimension("time"));
            String units = time.getUnitsString();
            DateUnit du = new DateUnit(units);
            DateFormatter df = new DateFormatter();
            String[] result = new String[]{"2006-06-07T12:00:00Z", "2006-06-07T13:00:00Z", "2006-06-07T14:00:00Z"};
            try {
                Array data = time.read();
                assert (data.getRank() == 1);
                assert (data.getSize() == 3L);
                assert (data.getShape()[0] == 3);
                assert (data.getElementType() == Double.TYPE);
                NCdump.printArray((Array)data, (String)"time coord", (PrintStream)System.out, null);
                int count = 0;
                IndexIterator dataI = data.getIndexIterator();
                while (dataI.hasNext()) {
                    double val = dataI.getDoubleNext();
                    Date dateVal = du.makeDate(val);
                    String dateS = df.toDateTimeStringISO(dateVal);
                    assert (dateS.equals(result[count])) : dateS + " != " + result[count];
                    ++count;
                }
            }
            catch (IOException io) {
                io.printStackTrace();
                if ($assertionsDisabled) break block15;
                throw new AssertionError();
            }
        }
        ncfile.close();
    }

    public void testClimatologicalDate() throws IOException, InvalidRangeException {
        String filename = "file:" + TestNcML.topDir + "aggExisting5.ncml";
        NetcdfDataset ncfile = NcMLReader.readNcML((String)filename, null);
        Variable time = ncfile.findVariable("time");
        assert (null != time);
        assert (time.getName().equals("time"));
        assert (time.getRank() == 1);
        assert (time.getSize() == 59L);
        assert (time.getShape()[0] == 59);
        assert (time.getDataType() == DataType.INT);
        assert (time.getDimension(0) == ncfile.findDimension("time"));
        Array data = time.read();
        assert (data.getRank() == 1);
        assert (data.getSize() == 59L);
        assert (data.getShape()[0] == 59);
        assert (data.getElementType() == Integer.TYPE);
        int count = 0;
        while (data.hasNext()) {
            assert (data.nextInt() == count) : data.nextInt() + "!=" + count;
            ++count;
        }
        ncfile.close();
    }
}

