/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.nexrad2;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;

public class TestNexrad2
extends TestCase {
    public TestNexrad2(String name) {
        super(name);
    }

    public void testRead() throws IOException {
        long start = System.currentTimeMillis();
        this.doDirectory(TestAll.testdataDir + "radar/nexrad/level2/VCP11", false);
        long took = System.currentTimeMillis() - start;
        System.out.println("that took = " + took + " msec");
    }

    private void doDirectory(String dirName, boolean alwaysUncompress) throws IOException {
        String path;
        File file;
        int i;
        File dir = new File(dirName);
        File[] files = dir.listFiles();
        if (alwaysUncompress) {
            for (i = 0; i < files.length; ++i) {
                file = files[i];
                path = file.getPath();
                if (!path.endsWith(".uncompress")) continue;
                file.delete();
            }
        }
        for (i = 0; i < files.length; ++i) {
            file = files[i];
            path = file.getPath();
            if (path.endsWith(".uncompress")) continue;
            if (file.isDirectory()) {
                this.doDirectory(path, alwaysUncompress);
                continue;
            }
            NetcdfFile ncfile = NetcdfDataset.openFile((String)path, null);
            this.testRead(ncfile);
        }
    }

    private void testRead(NetcdfFile nexrad2) throws IOException {
        System.out.println(nexrad2.getLocation());
        Dimension scanR = nexrad2.findDimension("scanR");
        assert (null != scanR);
        Dimension scanV = nexrad2.findDimension("scanV");
        assert (null != scanV);
        assert (scanR.getLength() == scanV.getLength());
        Variable elevR = nexrad2.findVariable("elevationR");
        assert (elevR != null);
        Array elevRdata = elevR.read();
        Variable elevV = nexrad2.findVariable("elevationV");
        assert (elevV != null);
        Array elevVdata = elevV.read();
        assert (elevRdata.getSize() == elevVdata.getSize());
        Variable v = nexrad2.findVariable("Reflectivity");
        assert (v != null);
        Array data = v.read();
        v = nexrad2.findVariable("RadialVelocity");
        assert (v != null);
        data = v.read();
        v = nexrad2.findVariable("SpectrumWidth");
        assert (v != null);
        data = v.read();
    }

    public static boolean testCoordSystem(NetcdfFile nexrad2) throws IOException {
        Dimension scanR = nexrad2.findDimension("scanR");
        assert (null != scanR);
        Dimension scanV = nexrad2.findDimension("scanV");
        assert (null != scanV);
        assert (scanR.getLength() == scanV.getLength());
        Variable elevR = nexrad2.findVariable("elevationR");
        assert (elevR != null);
        Array elevRdata = elevR.read();
        IndexIterator elevRiter = elevRdata.getIndexIterator();
        Variable elevV = nexrad2.findVariable("elevationV");
        assert (elevV != null);
        Array elevVdata = elevV.read();
        IndexIterator elevViter = elevVdata.getIndexIterator();
        assert (elevRdata.getSize() == elevVdata.getSize());
        int count = 0;
        boolean ok = true;
        while (elevRiter.hasNext()) {
            if (elevRiter.getFloatNext() != elevViter.getFloatNext()) {
                ok = false;
                System.out.println(count + " " + elevRiter.getFloatCurrent() + " != " + elevViter.getFloatCurrent());
            }
            ++count;
        }
        return ok;
    }

    public void utestCoordSys() throws IOException {
        String filename = TestAll.testdataDir + "radar/nexrad/level2/Level2_KYUX_20060527_2335.ar2v";
        NetcdfFile ncfile = NetcdfDataset.openFile((String)filename, null);
        TestNexrad2.testCoordSystem(ncfile);
    }

    public void testBzipProblem() throws IOException, InvalidRangeException {
        String filename = TestAll.testdataDir + "radar/nexrad/level2/Level2_KFTG_20060818_1814.ar2v.uncompress.missingradials";
        NetcdfDataset ncd = NetcdfDataset.openDataset((String)filename);
        VariableDS azi = (VariableDS)ncd.findVariable("azimuthR");
        assert (azi != null);
        VariableDS elev = (VariableDS)ncd.findVariable("elevationR");
        assert (elev != null);
        VariableDS time = (VariableDS)ncd.findVariable("timeR");
        assert (time != null);
        VariableDS r = (VariableDS)ncd.findVariable("Reflectivity");
        assert (r != null);
        this.checkMissingValues(elev, azi, time, r);
        azi = (VariableDS)ncd.findVariable("azimuthV");
        assert (azi != null);
        elev = (VariableDS)ncd.findVariable("elevationV");
        assert (elev != null);
        time = (VariableDS)ncd.findVariable("timeV");
        assert (time != null);
        r = (VariableDS)ncd.findVariable("RadialVelocity");
        assert (r != null);
        this.checkMissingValues(elev, azi, time, r);
        r = (VariableDS)ncd.findVariable("SpectrumWidth");
        assert (r != null);
        this.checkMissingValues(elev, azi, time, r);
    }

    private void checkMissingValues(VariableDS elev, VariableDS azi, VariableDS time, VariableDS q) throws IOException, InvalidRangeException {
        Array elevData = elev.read();
        IndexIterator elevII = elevData.getIndexIterator();
        Array aziData = azi.read();
        IndexIterator aziII = aziData.getIndexIterator();
        Array timeData = time.read();
        IndexIterator timeII = timeData.getIndexIterator();
        while (elevII.hasNext()) {
            float elevValue = elevII.getFloatNext();
            float aziValue = aziII.getFloatNext();
            assert (azi.isMissing((double)aziValue) == elev.isMissing((double)elevValue));
        }
        int[] shape = q.getShape();
        int rank = q.getRank();
        int[] origin = new int[rank];
        shape[rank - 1] = 1;
        Array qData = q.read(origin, shape);
        assert (qData.getSize() == aziData.getSize());
        IndexIterator qII = qData.getIndexIterator();
        aziII = aziData.getIndexIterator();
        while (qII.hasNext()) {
            float qValue = qII.getFloatNext();
            float aziValue = aziII.getFloatNext();
            if (azi.isMissing((double)aziValue)) assert (q.isMissing((double)qValue));
        }
    }
}

