/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf5;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.nc2.NCdump;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.TestNC2;
import ucar.nc2.Variable;
import ucar.nc2.dt.grid.GeoGrid;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.iosp.hdf5.H5header;
import ucar.nc2.util.DebugFlags;
import ucar.nc2.util.DebugFlagsImpl;

public class TestN4
extends TestCase {
    String testDir = TestAll.testdataDir + "netcdf4/";

    public TestN4(String name) {
        super(name);
    }

    public void testGlobalHeapOverun() throws IOException {
        String filename = this.testDir + "globalHeapOverrun.nc4";
        NetcdfFile ncfile = TestNC2.open(filename);
        System.out.println("\n**** testGlobalHeapOverun done\n\n" + ncfile);
        List vars = ncfile.getVariables();
        Collections.sort(vars);
        for (Variable v : vars) {
            System.out.println(" " + v.getName());
        }
        System.out.println("nvars = " + ncfile.getVariables().size());
        ncfile.close();
    }

    public void utestTiling() throws IOException {
        String filename = this.testDir + "tiling.nc4";
        GridDataset gridDataset = GridDataset.open((String)filename);
        GeoGrid grid = gridDataset.findGridByName("Turbulence_SIGMET_AIRMET");
        System.out.printf("grid=%s%n", grid);
        grid.readDataSlice(4, 13, 176, 216);
        gridDataset.close();
    }

    public void testOpen() throws IOException {
        String filename = this.testDir + "nc4/tst_enums.nc";
        NetcdfFile ncfile = TestNC2.open(filename);
        System.out.println("\n**** testReadNetcdf4 done\n\n" + ncfile);
        List vars = ncfile.getVariables();
        Collections.sort(vars);
        for (Variable v : vars) {
            System.out.println(" " + v.getName());
        }
        System.out.println("nvars = " + ncfile.getVariables().size());
        ncfile.close();
    }

    public void testReadAll() throws IOException {
        TestAll.readAllDir(this.testDir + "nc4", null);
        TestAll.readAllDir(this.testDir + "nc4-classic", null);
        TestAll.readAllDir(this.testDir + "files", null);
    }

    public void problem() throws IOException {
        String filename = this.testDir + "files/nctest_64bit_offset.nc";
        TestAll.readAll(filename);
        NetcdfFile ncfile = TestNC2.open(filename);
        System.out.println(ncfile.toString());
    }

    public void utestEnum() throws IOException {
        H5header.setDebugFlags((DebugFlags)new DebugFlagsImpl("H5header/header"));
        String filename = this.testDir + "nc4/tst_enum_data.nc";
        NetcdfFile ncfile = TestNC2.open(filename);
        Variable v = ncfile.findVariable("primary_cloud");
        Array data = v.read();
        System.out.println("\n**** testReadNetcdf4 done\n\n" + ncfile);
        NCdump.printArray((Array)data, (String)"primary_cloud", (PrintStream)System.out, null);
        ncfile.close();
    }

    public void testVlenStrings() throws IOException {
        String filename = this.testDir + "nc4/tst_strings.nc";
        NetcdfFile ncfile = TestNC2.open(filename);
        System.out.println("\n**** testReadNetcdf4 done\n\n" + ncfile);
        Variable v = ncfile.findVariable("measure_for_measure_var");
        Array data = v.read();
        NCdump.printArray((Array)data, (String)"measure_for_measure_var", (PrintStream)System.out, null);
        ncfile.close();
    }

    public void utestCompoundVlens() throws IOException {
        String filename = this.testDir + "vlen/cdm_sea_soundings.nc4";
        NetcdfFile ncfile = TestNC2.open(filename);
        System.out.println("\n**** testReadNetcdf4 done\n\n" + ncfile);
        Variable v = ncfile.findVariable("fun_soundings");
        Array data = v.read();
        NCdump.printArray((Array)data, (String)"fun_soundings", (PrintStream)System.out, null);
        ncfile.close();
    }

    public void testStrings() throws IOException {
        String filename = this.testDir + "files/nc_test_netcdf4.nc4";
        NetcdfFile ncfile = TestNC2.open(filename);
        System.out.println("\n**** testReadNetcdf4 done\n\n" + ncfile);
        Variable v = ncfile.findVariable("d");
        String attValue = ncfile.findAttValueIgnoreCase(v, "c", null);
        String s = H5header.showBytes((byte[])attValue.getBytes());
        System.out.println(" d:c= (" + attValue + ") = " + s);
        ncfile.close();
    }

    public static void main(String[] args) throws IOException {
        new TestN4("").problem();
    }
}

