/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf5;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.iosp.hdf5.TestH5;

public class TestH5filter
extends TestCase {
    public TestH5filter(String name) {
        super(name);
    }

    public void testFilterNoneApplied() throws IOException {
        NetcdfFile ncfile = TestH5.openH5("support/zip.h5");
        Variable v = ncfile.findVariable("Data/Compressed_Data");
        assert (v != null);
        Array data = v.read();
        int[] shape = data.getShape();
        assert (shape[0] == 1000);
        assert (shape[1] == 20);
        Index ima = data.getIndex();
        for (int i = 0; i < 1000; ++i) {
            for (int j = 0; j < 20; ++j) {
                int val = data.getInt(ima.set(i, j));
                assert (val == i + j) : val + " != " + (i + j);
            }
        }
    }

    public void test2() throws IOException {
        NetcdfFile ncfile = TestH5.openH5("wrf/wrf_input_seq.h5");
        Variable v = ncfile.findVariable("DATASET=INPUT/GSW");
        assert (v != null);
        Array data = v.read();
        int[] shape = data.getShape();
        assert (shape[0] == 1);
        assert (shape[1] == 20);
        assert (shape[2] == 10);
    }

    public void testDeflate() throws IOException {
        NetcdfFile ncfile = TestH5.openH5("msg/MSG1_8bit_HRV.H5");
        Variable v = ncfile.findVariable("image1/image_data");
        assert (v != null);
        Array data = v.read();
        int[] shape = data.getShape();
        assert (shape[0] == 1000);
        assert (shape[1] == 1500);
    }

    public void testMissing() throws IOException {
        NetcdfFile ncfile = TestH5.openH5("eos/HIRDLS/HIRDLS2-AFGL_b027_na.he5");
        Variable v = ncfile.findVariable("HDFEOS/SWATHS/HIRDLS/Data Fields/Altitude");
        assert (v != null);
        Array data = v.read();
        int[] shape = data.getShape();
        assert (shape[0] == 6);
        assert (shape[1] == 145);
    }
}

