/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf5;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import junit.framework.TestCase;
import ucar.nc2.NCdump;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestNC2;
import ucar.nc2.util.Misc;

public class TestCDL
extends TestCase {
    public TestCDL(String name) {
        super(name);
    }

    public void testCDL() throws IOException, InterruptedException {
        File[] files;
        File dir = new File("C://data/netcdf4/files/");
        for (File f : files = dir.listFiles()) {
            String name = f.getAbsolutePath();
            if (!name.endsWith(".nc")) continue;
            this.testCDL(name, false);
        }
    }

    public void testOneCDL() throws IOException, InterruptedException {
        this.testCDL("C:\\data\\netcdf4\\files\\tst_ncml.nc", true);
    }

    private void testCDL(String filename, boolean show) throws IOException, InterruptedException {
        NetcdfFile ncfile = TestNC2.open(filename);
        System.out.println("File " + filename);
        ByteArrayOutputStream bout = new ByteArrayOutputStream(30000);
        NCdump.print((NetcdfFile)ncfile, (OutputStream)bout, (boolean)false, (boolean)false, (boolean)false, (boolean)true, null, null);
        String njCDL = bout.toString();
        if (show) {
            System.out.println("============================================");
        }
        if (show) {
            System.out.println("njCDL " + njCDL);
        }
        if (show) {
            System.out.println("---------------------");
        }
        String cdl = this.getCDL(filename);
        if (show) {
            System.out.println("CDL " + cdl);
        }
        if (show) {
            System.out.println("---------------------");
        }
        String[] ncTokens = njCDL.split("[\\s,;]+");
        String[] cdlTokens = cdl.split("[\\s,;]+");
        int countNC = 0;
        for (int countCDL = 0; countNC < ncTokens.length && countCDL < cdlTokens.length; ++countNC, ++countCDL) {
            if (!ncTokens[countNC].equals(cdlTokens[countCDL])) {
                if (this.matchDoubleToken(ncTokens[countNC], cdlTokens[countCDL])) {
                    if (!show) continue;
                    System.out.println("ok double " + ncTokens[countNC] + " == " + cdlTokens[countCDL]);
                    continue;
                }
                System.out.println("mismatch " + ncTokens[countNC] + " != " + cdlTokens[countCDL]);
                continue;
            }
            if (!show) continue;
            System.out.println("ok " + ncTokens[countNC] + " == " + cdlTokens[countCDL]);
        }
    }

    private boolean matchDoubleToken(String toke1, String toke2) {
        try {
            double val1 = Double.parseDouble(toke1);
            double val2 = Double.parseDouble(toke2);
            return Misc.closeEnough((double)val1, (double)val2);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private String getCDL(String filename) throws IOException, InterruptedException {
        Runtime run = Runtime.getRuntime();
        Process p = run.exec(new String[]{"ncdump", "-h", filename});
        StreamGobbler err = new StreamGobbler(p.getErrorStream(), "ERR");
        StreamCapture out = new StreamCapture(p.getInputStream());
        err.start();
        out.start();
        int exitVal = p.waitFor();
        if (exitVal != 0) {
            throw new IOException("run.exec failed " + filename);
        }
        return out.result.toString();
    }

    public void testExec() throws IOException, InterruptedException {
        Runtime run = Runtime.getRuntime();
        Process p = run.exec(new String[]{"ncdump", "-h", "C:/data/netcdf4/files/tst_v2.nc"});
        StreamGobbler err = new StreamGobbler(p.getErrorStream(), "ERR");
        StreamGobbler out = new StreamGobbler(p.getInputStream(), "OUT");
        err.start();
        out.start();
        int exitVal = p.waitFor();
        System.out.println("ExitValue: " + exitVal);
    }

    public static void main2(String[] args) {
        String[] tokes;
        String test = "abc  hello;;; ;iou";
        for (String t : tokes = test.split("[\\s;]+")) {
            System.out.println(" " + t);
        }
        System.out.println("dobe");
    }

    class StreamGobbler
    extends Thread {
        InputStream is;
        String type;

        StreamGobbler(InputStream is, String type) {
            this.is = is;
            this.type = type;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    System.out.println(this.type + ">" + line);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    class StreamCapture
    extends Thread {
        InputStream is;
        StringBuilder result = new StringBuilder(10000);

        StreamCapture(InputStream is) {
            this.is = is;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    this.result.append(line).append("\n");
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

