/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf4;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.Variable;
import ucar.nc2.util.CompareNetcdf;

public class TestH4eos
extends TestCase {
    String testDir = TestAll.testdataDir + "hdf4/";

    public TestH4eos(String name) {
        super(name);
    }

    public void testReadAll() throws IOException {
        int count = 0;
        count = TestAll.actOnAll(this.testDir, new MyFileFilter(), new MyAct());
        System.out.println("***READ " + count + " files");
    }

    public void testUnsigned() throws IOException, InvalidRangeException {
        String filename = this.testDir + "MOD021KM.A2004328.1735.004.2004329164007.hdf";
        NetcdfFile ncfile = NetcdfFile.open((String)filename);
        String vname = "/MODIS_SWATH_Type_L1B/Data Fields/EV_250_Aggr1km_RefSB";
        Variable v = ncfile.findVariable(vname);
        assert (v != null) : filename + " " + vname;
        Array data = v.read();
        System.out.printf(" sum =          %f%n", MAMath.sumDouble((Array)data));
        double sum2 = 0.0;
        double sum3 = 0.0;
        int[] varShape = v.getShape();
        int[] origin = new int[3];
        int[] size = new int[]{1, varShape[1], varShape[2]};
        for (int i = 0; i < varShape[0]; ++i) {
            origin[0] = i;
            Array data2D = v.read(origin, size);
            double sum = MAMath.sumDouble((Array)data2D);
            System.out.printf("  %d sum3D =        %f%n", i, sum);
            sum2 += sum;
            sum = MAMath.sumDouble((Array)data2D.reduce(0));
            System.out.printf("  %d sum2D =        %f%n", i, sum);
            sum3 += sum;
            CompareNetcdf.compareData((Array)data2D, (Array)data2D.reduce(0));
        }
        System.out.printf(" sum2D =        %f%n", sum2);
        System.out.printf(" sum2D.reduce = %f%n", sum3);
        assert (sum2 == sum3);
    }

    public void testUnsigned2() throws IOException, InvalidRangeException {
        int nz = 1;
        int ny = 2030;
        int nx = 1354;
        int size = nz * ny * nx;
        short[] vals = new short[size];
        for (int i = 0; i < size; ++i) {
            vals[i] = (short)i;
        }
        Array data = Array.factory((DataType)DataType.SHORT, (int[])new int[]{nz, ny, nx}, (Object)vals);
        data.setUnsigned(true);
        System.out.printf(" sum =          %f%n", MAMath.sumDouble((Array)data));
        System.out.printf(" sum2 =          %f%n", MAMath.sumDouble((Array)data.reduce(0)));
    }

    private class MyAct
    implements TestAll.Act {
        private MyAct() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int doAct(String filename) throws IOException {
            NetcdfFile ncfile = null;
            try {
                Variable dset;
                ncfile = NetcdfFile.open((String)filename);
                Group root = ncfile.getRootGroup();
                Group g = root.findGroup("HDFEOS INFORMATION");
                if (g == null) {
                    g = ncfile.getRootGroup();
                }
                if ((dset = g.findVariable("StructMetadata.0")) != null) {
                    System.out.println("EOS file=" + filename);
                    int n = 1;
                    return n;
                }
                System.out.println("NOT EOS file=" + filename);
                int n = 0;
                return n;
            }
            finally {
                if (ncfile != null) {
                    ncfile.close();
                }
            }
        }
    }

    class MyFileFilter
    implements FileFilter {
        MyFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".hdf") || pathname.getName().endsWith(".eos");
        }
    }
}

