/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grib;

import java.io.File;
import junit.framework.TestCase;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.dataset.NetcdfDataset;

public class TestJustRead
extends TestCase {
    private boolean show = false;

    public TestJustRead(String name) {
        super(name);
    }

    public void testReadGrib1Files() throws Exception {
        this.readAllDir(TestAll.testdataDir + "motherlode/grid", "grib1");
    }

    public void testReadGrib2Files() throws Exception {
        this.readAllDir(TestAll.testdataDir + "motherlode/grid", "grib2");
    }

    public void testReadFiles() throws Exception {
        long start = System.currentTimeMillis();
        this.readAllDir("D:\\data\\grib\\nam\\c20s", "");
        long end = System.currentTimeMillis();
        System.out.printf(" that took %d msecs%n", end - start);
    }

    void readAllDir(String dirName, String suffix) throws Exception {
        System.out.println("---------------Reading directory " + dirName);
        File allDir = new File(dirName);
        File[] allFiles = allDir.listFiles();
        for (int i = 0; i < allFiles.length; ++i) {
            File f = allFiles[i];
            String name = f.getAbsolutePath();
            if (f.isDirectory() || !name.endsWith(suffix) || name.endsWith(".gbx")) continue;
            this.doOne(name);
        }
    }

    private void doOne(String filename) throws Exception {
        System.out.println("read file= " + filename);
        NetcdfFile ncfile = NetcdfDataset.openFile((String)filename, null);
        System.out.println(" Generating_Process_or_Model=" + ncfile.findAttValueIgnoreCase(null, "Generating_Process_or_Model", "NONE"));
        ncfile.close();
    }
}

