/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableEnhanced;

public class TestCompareGrib {
    static boolean showCompare = false;
    static boolean showEach = false;
    static boolean compareData = false;
    static boolean skipLocation = true;
    static boolean skipUnknownVar = true;

    public static void compareFiles(NetcdfFile org, NetcdfFile copy) {
        TestCompareGrib.compareFiles(org, copy, false, false, false);
    }

    public static void compareFiles(NetcdfFile org, NetcdfFile copy, boolean _compareData, boolean _showCompare, boolean _showEach) {
        System.out.println(" Original= " + org.getLocation());
        System.out.println(" Copy= " + copy.getLocation());
        showCompare = _showCompare;
        showEach = _showEach;
        compareData = _compareData;
        long start = System.currentTimeMillis();
        if (org.getId() != null || copy.getId() != null) assert (org.getId().equals(copy.getId()));
        if (org.getTitle() != null || copy.getTitle() != null) assert (org.getTitle().equals(copy.getTitle()));
        TestCompareGrib.compareGroups(org.getRootGroup(), copy.getRootGroup());
        long took = System.currentTimeMillis() - start;
        System.out.println(" Time= " + took + " msecs");
    }

    private static void compareGroups(Group org, Group copy) {
        if (showCompare) {
            System.out.println("compareGroups  " + org.getName() + " " + copy.getName());
        }
        assert (org.getName().equals(copy.getName()));
        TestCompareGrib.checkAll(org.getDimensions(), copy.getDimensions());
        TestCompareGrib.checkAll(org.getAttributes(), copy.getAttributes());
        List varsOrg = org.getVariables();
        for (Variable orgV : varsOrg) {
            if (skipUnknownVar && orgV.getShortName().contains("Unknown")) continue;
            Variable copyVar = copy.findVariable(orgV.getShortName());
            assert (copyVar != null) : orgV.getShortName();
            TestCompareGrib.compareVariables(orgV, copyVar, compareData);
        }
        List varsCopy = copy.getVariables();
        for (Variable copyV : varsCopy) {
            Variable orgV = org.findVariable(copyV.getShortName());
            assert (orgV != null);
        }
        ArrayList groups = TestCompareGrib.checkAll(org.getGroups(), copy.getGroups());
        for (int i = 0; i < groups.size(); i += 2) {
            Group orgGroup = (Group)groups.get(i);
            Group ncmlGroup = (Group)groups.get(i + 1);
            TestCompareGrib.compareGroups(orgGroup, ncmlGroup);
        }
    }

    static void compareVariables(Variable org, Variable copy, boolean compareData) {
        block10: {
            if (skipUnknownVar && org.getName().contains("Unknown")) {
                System.out.println("skipping " + org.getName());
                return;
            }
            if (showCompare) {
                System.out.println("compareVariables  " + org.getName() + " " + copy.getName());
            }
            assert (org.getName().equals(copy.getName()));
            TestCompareGrib.checkAll(org.getDimensions(), copy.getDimensions());
            TestCompareGrib.checkAll(org.getAttributes(), copy.getAttributes());
            if (org instanceof VariableEnhanced && copy instanceof VariableEnhanced) {
                VariableEnhanced orge = (VariableEnhanced)org;
                VariableEnhanced copye = (VariableEnhanced)copy;
                TestCompareGrib.checkAll(orge.getCoordinateSystems(), copye.getCoordinateSystems());
            }
            if (compareData) {
                try {
                    TestCompareGrib.compareVariableData(org, copy);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block10;
                    throw new AssertionError();
                }
            }
        }
        if (org instanceof Structure) {
            assert (copy instanceof Structure);
            Structure orgS = (Structure)org;
            Structure ncmlS = (Structure)copy;
            ArrayList vars = TestCompareGrib.checkAll(orgS.getVariables(), ncmlS.getVariables());
            for (int i = 0; i < vars.size(); i += 2) {
                Variable orgV = (Variable)vars.get(i);
                Variable ncmlV = (Variable)vars.get(i + 1);
                TestCompareGrib.compareVariables(orgV, ncmlV, false);
            }
        }
    }

    public static ArrayList checkAll(List list1, List list2) {
        ArrayList result = new ArrayList();
        Iterator iter1 = list1.iterator();
        while (iter1.hasNext()) {
            TestCompareGrib.checkEach(iter1.next(), list1, list2, result);
        }
        Iterator iter2 = list2.iterator();
        while (iter2.hasNext()) {
            TestCompareGrib.checkEach(iter2.next(), list2, list1, null);
        }
        return result;
    }

    public static void checkEach(Object want1, List list1, List list2, List result) {
        try {
            int index2;
            String status = null;
            if (want1 instanceof Attribute) {
                Attribute a = (Attribute)want1;
                status = "Checking " + a.getName() + " " + a.getStringValue();
                if (skipLocation && a.getName().contains("location")) {
                    return;
                }
                if (a.getName().contains("ScanningMode") || a.getName().contains("grid_spacing") || a.getName().contains("grid_units") || a.getName().contains("spherical") || a.getName().contains("GDSkey")) {
                    return;
                }
            }
            if ((index2 = list2.indexOf(want1)) < 0) {
                System.out.println(status);
            }
            assert (index2 >= 0) : want1.getClass().getName() + " " + want1 + " not in list 2";
            Object want2 = list2.get(index2);
            int index1 = list1.indexOf(want2);
            assert (index1 >= 0) : want2.getClass().getName() + " " + want2 + " not in list 1";
            Object want = list1.get(index1);
            assert (want == want1) : want1 + " not == " + want;
            if (showEach) {
                System.out.println("  OK <" + want1 + ". equals <" + want2 + ">");
            }
            if (result != null) {
                result.add(want1);
                result.add(want2);
            }
        }
        catch (Throwable t) {
            System.out.printf(" Error= %s %n", t.getMessage());
        }
    }

    public static void compareVariableData(Variable var1, Variable var2) throws IOException {
        Array data1 = var1.read();
        Array data2 = var2.read();
        if (showCompare) {
            System.out.print("compareArrays  " + var1.getName() + " " + var1.isUnlimited() + " size = " + data1.getSize());
        }
        TestCompareGrib.compareData(data1, data2);
        if (showCompare) {
            System.out.println(" ok");
        }
    }

    public static void compareData(Array data1, Array data2) {
        block13: {
            IndexIterator iter2;
            IndexIterator iter1;
            DataType dt;
            block16: {
                block15: {
                    block14: {
                        block12: {
                            assert (data1.getSize() == data2.getSize());
                            assert (data1.getElementType() == data2.getElementType()) : data1.getElementType() + "!=" + data2.getElementType();
                            dt = DataType.getType((Class)data1.getElementType());
                            iter1 = data1.getIndexIterator();
                            iter2 = data2.getIndexIterator();
                            if (dt != DataType.DOUBLE) break block12;
                            while (iter1.hasNext()) {
                                double v1 = iter1.getDoubleNext();
                                double v2 = iter2.getDoubleNext();
                                if (!Double.isNaN(v1) || !Double.isNaN(v2)) assert (v1 == v2) : v1 + " != " + v2 + " count=" + iter1;
                            }
                            break block13;
                        }
                        if (dt != DataType.FLOAT) break block14;
                        while (iter1.hasNext()) {
                            float v1 = iter1.getFloatNext();
                            float v2 = iter2.getFloatNext();
                            if (!Float.isNaN(v1) || !Float.isNaN(v2)) assert (v1 == v2) : v1 + " != " + v2 + " count=" + iter1;
                        }
                        break block13;
                    }
                    if (dt != DataType.INT) break block15;
                    while (iter1.hasNext()) {
                        int v1 = iter1.getIntNext();
                        int v2 = iter2.getIntNext();
                        assert (v1 == v2) : v1 + " != " + v2 + " count=" + iter1;
                    }
                    break block13;
                }
                if (dt != DataType.SHORT) break block16;
                while (iter1.hasNext()) {
                    short v1 = iter1.getShortNext();
                    short v2 = iter2.getShortNext();
                    assert (v1 == v2) : v1 + " != " + v2 + " count=" + iter1;
                }
                break block13;
            }
            if (dt != DataType.BYTE) break block13;
            while (iter1.hasNext()) {
                byte v1 = iter1.getByteNext();
                byte v2 = iter2.getByteNext();
                assert (v1 == v2) : v1 + " != " + v2 + " count=" + iter1;
            }
        }
    }

    public static void main(String[] arg) throws IOException {
        NetcdfFile ncfile1 = NetcdfDataset.openFile((String)"dods://thredds.cise-nsf.gov:8080/thredds/dodsC/satellite/SFC-T/SUPER-NATIONAL_1km/20090516/SUPER-NATIONAL_1km_SFC-T_20090516_2200.gini", null);
        NetcdfFile ncfile2 = NetcdfDataset.openFile((String)"dods://motherlode.ucar.edu:8080/thredds/dodsC/satellite/SFC-T/SUPER-NATIONAL_1km/20090516/SUPER-NATIONAL_1km_SFC-T_20090516_2200.gini", null);
        TestCompareGrib.compareFiles(ncfile1, ncfile2, false, true, false);
    }
}

