/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grib;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import ucar.grib.GribIndexReader;
import ucar.grid.GridDefRecord;
import ucar.grid.GridIndex;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.iosp.grib.GribGridServiceProvider;
import ucar.nc2.iosp.grib.TestCompareGrib;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class TestBinaryTextIndexes
extends TestCase {
    public TestBinaryTextIndexes(String name) {
        super(name);
    }

    public void testCompare() throws IOException {
        File where = new File("C:/data/grib/idd");
        if (where.exists()) {
            String[] args = new String[]{"C:/data/grib/idd"};
            this.doAll(args);
        } else {
            this.doAll(null);
        }
    }

    void compareNC(String fileBinary, String fileText) throws IOException {
        Class<GribGridServiceProvider> c = GribGridServiceProvider.class;
        IOServiceProvider spiB = null;
        try {
            spiB = (IOServiceProvider)c.newInstance();
        }
        catch (InstantiationException e) {
            throw new IOException("IOServiceProvider " + c.getName() + "must have no-arg constructor.");
        }
        catch (IllegalAccessException e) {
            throw new IOException("IOServiceProvider " + c.getName() + " IllegalAccessException: " + e.getMessage());
        }
        RandomAccessFile rafB = new RandomAccessFile(fileBinary, "r");
        rafB.order(0);
        MyNetcdfFile ncfileBinary = new MyNetcdfFile(spiB, rafB, fileBinary, null);
        System.out.println("Binary Netcdf object created");
        try {
            spiB = (IOServiceProvider)c.newInstance();
        }
        catch (InstantiationException e) {
            throw new IOException("IOServiceProvider " + c.getName() + "must have no-arg constructor.");
        }
        catch (IllegalAccessException e) {
            throw new IOException("IOServiceProvider " + c.getName() + " IllegalAccessException: " + e.getMessage());
        }
        RandomAccessFile rafT = new RandomAccessFile(fileText, "r");
        rafT.order(0);
        MyNetcdfFile ncfileText = new MyNetcdfFile(spiB, rafT, fileText, null);
        System.out.println("Text Index Netcdf object created");
        TestCompareGrib.compareFiles(ncfileBinary, ncfileText, false, true, false);
        ncfileBinary.close();
        ncfileText.close();
    }

    void compareIndexes(String fileBinary, String fileText) throws IOException {
        String valueT;
        String valueB;
        GridIndex giB = new GribIndexReader().open(fileBinary + ".gbx8");
        GridIndex giT = new GribIndexReader().open(fileText + ".gbx");
        List hcsB = giB.getHorizCoordSys();
        List hcsT = giT.getHorizCoordSys();
        for (int i = 0; i < hcsB.size(); ++i) {
            GridDefRecord gdrB = (GridDefRecord)hcsB.get(i);
            GridDefRecord gdrT = (GridDefRecord)hcsT.get(i);
            Set keysB = gdrB.getKeys();
            for (String key : keysB) {
                if (key.equals("grid_units") || key.equals("created") || key.equals("location") || key.equals("VectorComponentFlag") || key.equals("GDSkey") || key.equals("grid_name") || key.equals("scanning_mode") || key.equals("grid_shape")) continue;
                valueB = gdrB.getParam(key);
                if (!valueB.equals(valueT = gdrT.getParam(key))) {
                    System.out.println("hcs " + key + " differ for Binary and Text  " + valueB + " " + valueT);
                }
                assert (valueB.equals(valueT));
            }
            Set keysT = gdrT.getKeys();
            for (String key : keysT) {
                if (key.equals("grid_units") || key.equals("created") || key.equals("location") || key.equals("VectorComponentFlag") || key.equals("GDSkey") || key.equals("grid_name") || key.equals("ScanningMode") || key.equals("grid_shape")) continue;
                String valueB2 = gdrB.getParam(key);
                String valueT2 = gdrT.getParam(key);
                if (!valueT2.equals(valueB2)) {
                    System.out.println("hcs " + key + " differ for Text and Binary " + valueT2 + " " + valueB2);
                }
                assert (valueB2.equals(valueT2));
            }
        }
        Map attB = giB.getGlobalAttributes();
        Map attT = giT.getGlobalAttributes();
        Set keysB = attB.keySet();
        for (String key : keysB) {
            String valueT3;
            if (key.equals("basetime") || key.equals("created") || key.equals("location") || key.equals("grid_units") || key.equals("ensemble")) continue;
            String valueB3 = (String)attB.get(key);
            if (!valueB3.equals(valueT3 = (String)attT.get(key)) || key.equals("index_version")) {
                System.out.println("attribute " + key + " differ for Binary and Text  " + valueB3 + " " + valueT3);
            }
            if (!key.equals("index_version")) assert (valueB3.equals(valueT3));
        }
        Set keysT = attT.keySet();
        for (String key : keysT) {
            if (key.equals("ensemble") || key.equals("tiles") || key.equals("thin") || key.equals("created") || key.equals("location") || key.equals("grid_units")) continue;
            valueB = (String)attB.get(key);
            valueT = (String)attT.get(key);
            if (!valueT.equals(valueB) || key.equals("index_version")) {
                System.out.println("attribute " + key + " differ for Text and Binary " + valueT + " " + valueB);
            }
            if (!key.equals("index_version")) assert (valueB.equals(valueT));
        }
    }

    void doAll(String[] args) throws IOException {
        String dirT;
        String dirB;
        if (args == null || args.length < 1) {
            dirB = TestAll.testdataDir + "test/motherlode/grid/grib/binary";
            dirT = TestAll.testdataDir + "test/motherlode/grid/grib/text";
        } else {
            dirB = args[0] + "/binary";
            dirT = args[0] + "/text";
        }
        File dir = new File(dirT);
        if (dir.isDirectory()) {
            String[] children;
            System.out.println("In directory " + dir.getParent() + "/" + dir.getName());
            for (String child : children = dir.list()) {
                File aChild = new File(dir, child);
                if (aChild.isDirectory() || child.contains("Ensemble") || child.contains("SREF") || child.contains("GFS_Spectral") || child.contains("SPECTRAL") || child.contains("OCEAN") || child.contains("ECMWF") || child.contains("GFS_Extended") || child.contains("SST") || child.contains("UKMET") || child.contains("ukm") || child.contains("GFS_Global_1p25deg") || child.endsWith("gbx") || child.endsWith("gbx8") || child.endsWith("xml") || child.endsWith("tmp") || child.length() == 0) continue;
                System.out.println("\n\nComparing File:  " + child);
                System.out.println("  Index comparisons Binary and Text");
                this.compareIndexes(dirB + "/" + child, dirT + "/" + child);
                System.out.println();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        TestBinaryTextIndexes bti = new TestBinaryTextIndexes("");
        bti.testCompare();
    }

    static class MyNetcdfFile
    extends NetcdfFile {
        MyNetcdfFile(IOServiceProvider spi, RandomAccessFile raf, String location, CancelTask cancelTask) throws IOException {
            super(spi, raf, location, cancelTask);
        }
    }
}

