/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.dorade;

import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.Variable;

public class TestDorade
extends TestCase {
    public static String groundDroadeFile = TestAll.cdmLocalTestDataDir + "dorade/swp.1020511015815.SP0L.573.1.2_SUR_v1";
    public static String airDoradeFile = TestAll.cdmLocalTestDataDir + "dorade/swp.1030524195200.TA-ELDR.291.-16.5_AIR_v-999";
    public static boolean dumpFile = false;
    NetcdfFile ncfile = null;

    public void testDoradeGround() throws IOException {
        Variable var = null;
        try {
            System.out.println("**** Open " + groundDroadeFile);
            this.ncfile = NetcdfFile.open((String)groundDroadeFile);
        }
        catch (IOException e) {
            System.out.println(" fail = " + e);
            e.printStackTrace();
            TestDorade.assertTrue((boolean)false);
        }
        List vars = this.ncfile.getVariables();
        for (int i = 0; i < vars.size(); ++i) {
            Variable v = (Variable)vars.get(i);
            System.out.println(" " + v.getShortName() + " == " + v.getName());
        }
        Dimension gateDim = this.ncfile.getRootGroup().findDimension("gate_1");
        assert (gateDim.getLength() == 1008);
        Dimension radialDim = this.ncfile.getRootGroup().findDimension("radial");
        assert (radialDim.getLength() == 439);
        Attribute testAtt = this.ncfile.getRootGroup().findAttribute("Conventions");
        assert (testAtt.getStringValue().equals("_Coordinates"));
        testAtt = this.ncfile.getRootGroup().findAttribute("format");
        assert (testAtt.getStringValue().equals("Unidata/netCDF/Dorade"));
        testAtt = this.ncfile.getRootGroup().findAttribute("Project_name");
        assert (testAtt.getStringValue().equalsIgnoreCase("IHOP_2002"));
        testAtt = this.ncfile.getRootGroup().findAttribute("Radar_Name");
        assert (testAtt.getStringValue().equalsIgnoreCase("SPOL"));
        testAtt = this.ncfile.getRootGroup().findAttribute("VolumeCoveragePatternName");
        assert (testAtt.getStringValue().equalsIgnoreCase("SUR"));
        testAtt = this.ncfile.getRootGroup().findAttribute("Volume_Number");
        assert (testAtt.getStringValue().equalsIgnoreCase("1"));
        testAtt = this.ncfile.getRootGroup().findAttribute("Sweep_Number");
        assert (testAtt.getStringValue().equalsIgnoreCase("2"));
        testAtt = this.ncfile.getRootGroup().findAttribute("Sweep_Date");
        assert (testAtt.getStringValue().equalsIgnoreCase("Fri May 10 19:58:15 MDT 2002"));
        var = this.ncfile.findVariable("elevation");
        this.testReadData(var);
        var = this.ncfile.findVariable("azimuth");
        this.testReadData(var);
        var = this.ncfile.findVariable("distance_1");
        this.testReadData(var);
        var = this.ncfile.findVariable("latitudes_1");
        this.testReadData(var);
        var = this.ncfile.findVariable("longitudes_1");
        this.testReadData(var);
        var = this.ncfile.findVariable("altitudes_1");
        this.testReadData(var);
        var = this.ncfile.findVariable("rays_time");
        this.testReadData(var);
        var = this.ncfile.findVariable("Range_to_First_Cell");
        float t = this.testReadScalar(var);
        assert (t == 150.0f);
        var = this.ncfile.findVariable("Cell_Spacing");
        t = this.testReadScalar(var);
        assert (t == 149.89624f);
        var = this.ncfile.findVariable("Fixed_Angle");
        t = this.testReadScalar(var);
        assert (t == 1.1975098f);
        var = this.ncfile.findVariable("Nyquist_Velocity");
        t = this.testReadScalar(var);
        assert (t == 25.618269f);
        var = this.ncfile.findVariable("Unambiguous_Range");
        t = this.testReadScalar(var);
        assert (t == 156.11694f);
        var = this.ncfile.findVariable("Radar_Constant");
        t = this.testReadScalar(var);
        assert (t == 70.325195f);
        var = this.ncfile.findVariable("rcvr_gain");
        t = this.testReadScalar(var);
        assert (t == 46.95f);
        var = this.ncfile.findVariable("ant_gain");
        t = this.testReadScalar(var);
        assert (t == 45.58f);
        var = this.ncfile.findVariable("sys_gain");
        t = this.testReadScalar(var);
        assert (t == 46.95f);
        var = this.ncfile.findVariable("bm_width");
        t = this.testReadScalar(var);
        assert (t == 0.92f);
        var = this.ncfile.findVariable("VE");
        this.testReadData(var);
        var = this.ncfile.findVariable("DM");
        this.testReadData(var);
        var = this.ncfile.findVariable("NCP");
        this.testReadData(var);
        var = this.ncfile.findVariable("SW");
        this.testReadData(var);
        var = this.ncfile.findVariable("DZ");
        this.testReadData(var);
        var = this.ncfile.findVariable("DCZ");
        this.testReadData(var);
        var = this.ncfile.findVariable("LVDR");
        this.testReadData(var);
        var = this.ncfile.findVariable("NIQ");
        this.testReadData(var);
        var = this.ncfile.findVariable("AIQ");
        this.testReadData(var);
        var = this.ncfile.findVariable("CH");
        this.testReadData(var);
        var = this.ncfile.findVariable("AH");
        this.testReadData(var);
        var = this.ncfile.findVariable("CV");
        this.testReadData(var);
        var = this.ncfile.findVariable("AV");
        this.testReadData(var);
        var = this.ncfile.findVariable("RHOHV");
        this.testReadData(var);
        var = this.ncfile.findVariable("LDR");
        this.testReadData(var);
        var = this.ncfile.findVariable("DL");
        this.testReadData(var);
        var = this.ncfile.findVariable("DX");
        this.testReadData(var);
        var = this.ncfile.findVariable("ZDR");
        this.testReadData(var);
        var = this.ncfile.findVariable("PHI");
        this.testReadData(var);
        var = this.ncfile.findVariable("KDP");
        this.testReadData(var);
        assert (0 == var.findDimensionIndex("radial"));
        assert (1 == var.findDimensionIndex("gate_1"));
        this.ncfile.close();
    }

    public void testDoradeAir() throws IOException {
        Variable var;
        block17: {
            var = null;
            this.ncfile = null;
            try {
                System.out.println("**** Open " + airDoradeFile);
                this.ncfile = NetcdfFile.open((String)airDoradeFile);
            }
            catch (IOException e) {
                System.out.println(" fail = " + e);
                e.printStackTrace();
                if ($assertionsDisabled) break block17;
                throw new AssertionError();
            }
        }
        List vars = this.ncfile.getVariables();
        for (int i = 0; i < vars.size(); ++i) {
            Variable v = (Variable)vars.get(i);
            System.out.println(" " + v.getShortName() + " == " + v.getName());
        }
        Dimension gateDim = this.ncfile.getRootGroup().findDimension("gate_1");
        assert (gateDim.getLength() == 320);
        Dimension radialDim = this.ncfile.getRootGroup().findDimension("radial");
        assert (radialDim.getLength() == 274);
        var = this.ncfile.findVariable("elevation");
        this.testReadData(var);
        var = this.ncfile.findVariable("azimuth");
        this.testReadData(var);
        var = this.ncfile.findVariable("distance_1");
        this.testReadData(var);
        var = this.ncfile.findVariable("latitudes_1");
        this.testReadData(var);
        var = this.ncfile.findVariable("longitudes_1");
        this.testReadData(var);
        var = this.ncfile.findVariable("altitudes_1");
        this.testReadData(var);
        var = this.ncfile.findVariable("rays_time");
        this.testReadData(var);
        var = this.ncfile.findVariable("Range_to_First_Cell");
        float t = this.testReadScalar(var);
        assert (t == -2.0f);
        var = this.ncfile.findVariable("Cell_Spacing");
        t = this.testReadScalar(var);
        assert (t == 150.0f);
        var = this.ncfile.findVariable("Fixed_Angle");
        t = this.testReadScalar(var);
        assert (t == -16.53f);
        var = this.ncfile.findVariable("Nyquist_Velocity");
        t = this.testReadScalar(var);
        assert (t == 78.03032f);
        var = this.ncfile.findVariable("Unambiguous_Range");
        t = this.testReadScalar(var);
        assert (t == 60.0f);
        var = this.ncfile.findVariable("Radar_Constant");
        t = this.testReadScalar(var);
        assert (t == -81.17389f);
        var = this.ncfile.findVariable("rcvr_gain");
        t = this.testReadScalar(var);
        assert (t == 32.64f);
        var = this.ncfile.findVariable("ant_gain");
        t = this.testReadScalar(var);
        assert (t == 39.35f);
        var = this.ncfile.findVariable("sys_gain");
        t = this.testReadScalar(var);
        assert (t == 52.34f);
        var = this.ncfile.findVariable("bm_width");
        t = this.testReadScalar(var);
        assert (t == 1.79f);
        var = this.ncfile.findVariable("VS");
        this.testReadData(var);
        var = this.ncfile.findVariable("VL");
        this.testReadData(var);
        var = this.ncfile.findVariable("SW");
        this.testReadData(var);
        var = this.ncfile.findVariable("VR");
        this.testReadData(var);
        var = this.ncfile.findVariable("NCP");
        this.testReadData(var);
        var = this.ncfile.findVariable("DBZ");
        this.testReadData(var);
        var = this.ncfile.findVariable("VG");
        this.testReadData(var);
        var = this.ncfile.findVariable("VT");
        this.testReadData(var);
        assert (null != var.getDimension(0));
        assert (null != var.getDimension(1));
        this.ncfile.close();
    }

    private void testReadData(Variable v) {
        Array a;
        block6: {
            a = null;
            assert (null != v);
            assert (null != v.getDimension(0));
            try {
                a = v.read();
                assert (null != a);
            }
            catch (IOException e) {
                e.printStackTrace();
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        assert (v.getSize() == a.getSize());
    }

    private float testReadScalar(Variable v) {
        Array a;
        block4: {
            a = null;
            assert (null != v);
            try {
                a = v.read();
                assert (null != a);
            }
            catch (IOException e) {
                e.printStackTrace();
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        IndexIterator ii = a.getIndexIterator();
        return ii.getFloatNext();
    }
}

