/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import junit.framework.TestCase;
import ucar.nc2.TestAll;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.iosp.bufr.MessageScanner;
import ucar.unidata.io.RandomAccessFile;

public class TestBufrRead
extends TestCase {
    public void utestReadAllInDir() throws IOException {
        int count = 0;
        System.out.println("***READ " + (count += TestAll.actOnAll(TestAll.cdmUnitTestDir + "iosp/bufr", new MyFileFilter(), new TestAll.Act(){

            @Override
            public int doAct(String filename) throws IOException {
                return TestBufrRead.this.readBufr(filename);
            }
        })) + " files");
    }

    public void testReadMessages() throws IOException {
        int count = 0;
        assert (5519 == (count = this.readBufr(TestAll.cdmUnitTestDir + "iosp/bufr/uniqueIDD.bufr"))) : count;
        assert (11533 == (count = this.readBufr(TestAll.cdmUnitTestDir + "iosp/bufr/uniqueBrasil.bufr"))) : count;
        assert (12727 == (count = this.readBufr(TestAll.cdmUnitTestDir + "iosp/bufr/uniqueExamples.bufr"))) : count;
        assert (9929 == (count = this.readBufr(TestAll.cdmUnitTestDir + "iosp/bufr/uniqueFnmoc.bufr"))) : count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readBufr(String filename) throws IOException {
        System.out.printf("%n***READ bufr %s%n", filename);
        int count = 0;
        int totalObs = 0;
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(filename, "r");
            MessageScanner scan = new MessageScanner(raf);
            while (scan.hasNext()) {
                try {
                    Message m = scan.next();
                    if (m == null) continue;
                    int nobs = m.getNumberDatasets();
                    System.out.printf(" %3d nobs = %4d %s", count++, nobs, m.getHeader());
                    if (m.isTablesComplete()) {
                        if (m.isBitCountOk()) {
                            totalObs += nobs;
                            System.out.printf("%n", new Object[0]);
                            continue;
                        }
                        System.out.printf(" BITS NOT OK%n", new Object[0]);
                        continue;
                    }
                    System.out.printf(" TABLES NOT COMPLETE%n", new Object[0]);
                }
                catch (Exception e) {
                    System.out.printf(" CANT READ %n", new Object[0]);
                    e.printStackTrace();
                }
            }
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
        return totalObs;
    }

    class MyFileFilter
    implements FileFilter {
        MyFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return !pathname.getName().endsWith(".bfx");
        }
    }
}

