/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp;

import junit.framework.TestCase;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.iosp.Indexer;
import ucar.nc2.iosp.RegularIndexer;
import ucar.nc2.iosp.RegularLayout;

public class TestRegularLayout
extends TestCase {
    RegularLayout layout;
    RegularIndexer index;

    public TestRegularLayout(String name) {
        super(name);
    }

    private TestRegularLayout(long startPos, int elemSize, int recSize, int[] varShape, Section want) throws InvalidRangeException {
        if (want == null) {
            want = new Section(varShape);
        } else {
            want.setDefaults(varShape);
        }
        String err = want.checkInRange(varShape);
        if (err != null) {
            this.printa("section= " + want + "\nvarShape=", varShape);
            throw new InvalidRangeException(err);
        }
        this.layout = new RegularLayout(startPos, elemSize, recSize, varShape, want);
        this.index = new RegularIndexer(varShape, elemSize, startPos, want.getRanges(), recSize);
    }

    private void printa(String name, int[] a, int rank) {
        System.out.print(name + "= ");
        for (int i = 0; i < rank; ++i) {
            System.out.print(a[i] + " ");
        }
        System.out.println();
    }

    private void printa(String name, int[] a) {
        System.out.print(name + "= ");
        for (int i = 0; i < a.length; ++i) {
            System.out.print(a[i] + " ");
        }
        System.out.println();
    }

    public static void compare(TestRegularLayout rlayout) throws InvalidRangeException {
        while (rlayout.layout.hasNext() && rlayout.index.hasNext()) {
            Indexer.Chunk chunk = rlayout.layout.next();
            Indexer.Chunk chunk2 = rlayout.index.next();
            assert (chunk.getFilePos() == chunk2.getFilePos());
            assert (chunk.getStartElem() == chunk2.getStartElem());
            assert (chunk.getNelems() == chunk2.getNelems());
        }
        assert (!rlayout.layout.hasNext());
        assert (!rlayout.index.hasNext());
    }

    public void test() throws InvalidRangeException {
        Section var = new Section().appendRange(10).appendRange(20).appendRange(30).appendRange(4);
        Section want = new Section().appendRange(2).appendRange(10).appendRange(30).appendRange(4);
        TestRegularLayout.compare(new TestRegularLayout(0L, 1, 0, var.getShape(), want));
        TestRegularLayout.compare(new TestRegularLayout(1000L, 8, 4000, var.getShape(), want));
        want = new Section().appendRange(5, 5).appendRange(0, 900, 20).appendRange(3, 3).appendRange(0, 16);
        TestRegularLayout.compare(new TestRegularLayout(1000L, 4, 888, new int[]{13, 1000, 4, 17}, want));
        TestRegularLayout.compare(new TestRegularLayout(1000L, 4, 0, new int[]{13, 1000, 4, 17}, want));
        want = new Section().appendRange(5, 5).appendRange().appendRange();
        TestRegularLayout.compare(new TestRegularLayout(1000L, 4, 888, new int[]{13, 40, 5}, want));
        TestRegularLayout.compare(new TestRegularLayout(1000L, 4, 0, new int[]{13, 40, 5}, want));
        want = new Section().appendRange(2).appendRange(0, 55, 11);
        TestRegularLayout.compare(new TestRegularLayout(200000L, 3, 123999, new int[]{5, 56}, want));
        TestRegularLayout.compare(new TestRegularLayout(200000L, 3, 0, new int[]{5, 56}, want));
        want = new Section().appendRange(0, 55, 19).appendRange();
        TestRegularLayout.compare(new TestRegularLayout(4000L, 4000, 4000, new int[]{60, 5}, want));
        TestRegularLayout.compare(new TestRegularLayout(4000L, 4000, 0, new int[]{60, 5}, want));
        want = new Section().appendRange(6, 55, 2).appendRange();
        TestRegularLayout.compare(new TestRegularLayout(4000L, 4000, 4000, new int[]{60, 5}, want));
        TestRegularLayout.compare(new TestRegularLayout(4000L, 4000, 0, new int[]{60, 5}, want));
        want = new Section().appendRange(0, 55, 9);
        TestRegularLayout.compare(new TestRegularLayout(4000L, 4000, 4000, new int[]{60}, want));
        TestRegularLayout.compare(new TestRegularLayout(4000L, 4000, 0, new int[]{60}, want));
        want = new Section().appendRange(19, 55, 3);
        TestRegularLayout.compare(new TestRegularLayout(4000L, 4000, 4000, new int[]{60}, want));
        TestRegularLayout.compare(new TestRegularLayout(4000L, 4000, 0, new int[]{60}, want));
        want = new Section();
        TestRegularLayout.compare(new TestRegularLayout(4000L, 4000, 4000, new int[0], want));
        TestRegularLayout.compare(new TestRegularLayout(4000L, 4000, 0, new int[0], want));
    }
}

