/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft;

import java.util.Formatter;
import java.util.List;
import junit.framework.TestCase;
import thredds.inventory.FeatureCollectionConfig;
import thredds.inventory.bdb.MetadataManager;
import ucar.nc2.TestAll;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.fmrc.Fmrc;

public class TestFmrc
extends TestCase {
    private static String datadir = TestAll.cdmUnitTestDir + "fmrc/";
    private static boolean showCount = true;

    public TestFmrc(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void utestCollections() throws Exception {
        try {
            FeatureCollectionConfig.setRegularizeDefault((boolean)true);
            TestFmrc.doOne(datadir + "toms/**/hiig_#yyyyMMdd#.nc", 25, 11, 13, 2, "u", 4, 25, 58);
            TestFmrc.doOne(datadir + "bom/**/ocean_fc_#yyyyMMdd#_..._eta.nc", 1, 1, 8, 0, "eta_t", 2, 7, 10);
            TestFmrc.doOne(TestAll.cdmUnitTestDir + "ncml/nc/ruc_conus40/RUC_CONUS_40km_#yyyyMMdd_HHmm#.grib1", 48, 12, 16, 6, "Pressure", 3, 9, 9);
            TestFmrc.doOne(TestAll.cdmUnitTestDir + "ncml/agg/#yyyyMMdd_HHmm#.nc$", 10, 4, 8, 2, "Visibility", 4, 2, 8);
            TestFmrc.doOne("catalog:http://motherlode.ucar.edu:8080/thredds/catalog/fmrc/NCEP/GFS/Hawaii_160km/files/catalog.xml", 15, 8, 11, 6, "Temperature", -1, 21, 111);
            TestFmrc.doOne(datadir + "bom/BoM_test.ncml", 1, 3, 8, 0, "eta_t", 2, 7, 10);
            TestFmrc.doOne(datadir + "ncom/ncom_fmrc.ncml", 1, 1, 5, 1, "surf_el", 3, 25, 41);
            TestFmrc.doOne(datadir + "rtofs/rtofs.ncml", 9, 4, 9, 1, "N3-D_Temperature", 2, 3, 4);
            TestFmrc.doOne(TestAll.cdmLocalTestDataDir + "ncml/offsite/AggFmrcGribRunseq.ncml", 13, 3, 6, 2, "Temperature", 4, 29, 35);
            TestFmrc.doOne(TestAll.cdmLocalTestDataDir + "ncml/offsite/AggFmrcGrib.ncml", 54, 13, 16, 12, "Temperature", 8, 29, 72);
            TestFmrc.doOne(TestAll.cdmLocalTestDataDir + "ncml/offsite/AggFmrcNomads.ncml", 117, 17, 19, 14, "Temperature", 1, 3, 3);
            TestFmrc.doOne(TestAll.cdmLocalTestDataDir + "ncml/offsite/AggFmrcNonuniform.ncml", 48, 12, 16, 6, "Temperature", 3, 11, 11);
            TestFmrc.doOne(TestAll.cdmLocalTestDataDir + "ncml/offsite/aggForecastModel.ncml", 41, 6, 10, 4, "u", 14, 11, 37);
            TestFmrc.doOne(TestAll.cdmLocalTestDataDir + "ncml/offsite/aggFmrcScan2.ncml", 148, 24, 27, 23, "Temperature", 2, 3, 6);
            TestFmrc.doOne(datadir + "nomads/nomads.ncml", 117, 17, 19, 14, "Temperature", 1, 3, 3);
            TestFmrc.doOne(datadir + "gomoos/fmrc.ncml", 16, -1, 7, 1, "salt", 2, 21, 29);
        }
        finally {
            MetadataManager.closeAll();
        }
    }

    public void utestProblem() throws Exception {
        TestFmrc.doOne("catalog:http://motherlode.ucar.edu:8080/thredds/catalog/fmrc/NCEP/GFS/Hawaii_160km/files/catalog.xml", 15, 8, 11, 6, "Temperature", -1, 21, 111);
    }

    static void doOne(String pathname, int ngrids, int ncoordSys, int ncoordAxes, int nVertCooordAxes, String gridName, int nruns, int ntimes, int nbest) throws Exception {
        System.out.println("\ntest read Fmrc = " + pathname);
        TestFmrc.doOne2D(pathname, ngrids, ncoordSys, ncoordAxes, nVertCooordAxes, gridName, nruns, ntimes);
        TestFmrc.doOneBest(pathname, ngrids, ncoordSys, ncoordAxes - 1, nVertCooordAxes, gridName, nruns, nbest);
    }

    static void doOne2D(String pathname, int ngrids, int ncoordSys, int ncoordAxes, int nVertCooordAxes, String gridName, int nruns, int ntimes) throws Exception {
        System.out.println("2D dataset");
        Formatter errlog = new Formatter();
        Fmrc fmrc = Fmrc.open((String)pathname, (Formatter)errlog);
        if (fmrc == null) {
            System.out.printf("Fmrc failed to open %s%n", pathname);
            System.out.printf("errlog= %s%n", errlog.toString());
            return;
        }
        GridDataset gridDs = fmrc.getDataset2D(null);
        NetcdfDataset ncd = (NetcdfDataset)gridDs.getNetcdfFile();
        int countGrids = gridDs.getGrids().size();
        int countCoordAxes = ncd.getCoordinateAxes().size();
        int countCoordSys = ncd.getCoordinateSystems().size();
        int countVertCooordAxes = 0;
        List axes = ncd.getCoordinateAxes();
        for (int i = 0; i < axes.size(); ++i) {
            CoordinateAxis axis = (CoordinateAxis)axes.get(i);
            AxisType t = axis.getAxisType();
            if (t != AxisType.GeoZ && t != AxisType.Height && t != AxisType.Pressure) continue;
            ++countVertCooordAxes;
        }
        if (showCount) {
            System.out.println(" grids=" + countGrids + (ngrids < 0 ? " *" : ""));
            System.out.println(" coordSys=" + countCoordSys + (ncoordSys < 0 ? " *" : ""));
            System.out.println(" coordAxes=" + countCoordAxes + (ncoordAxes < 0 ? " *" : ""));
            System.out.println(" vertAxes=" + countVertCooordAxes + (nVertCooordAxes < 0 ? " *" : ""));
        }
        for (GridDataset.Gridset gridset : gridDs.getGridsets()) {
            gridset.getGeoCoordSystem();
        }
        GridDatatype grid = gridDs.findGridDatatype(gridName);
        assert (grid != null) : "Cant find grid " + gridName;
        GridCoordSystem gcs = grid.getCoordinateSystem();
        CoordinateAxis1DTime runtime = gcs.getRunTimeAxis();
        assert (runtime != null) : "Cant find runtime for " + gridName;
        CoordinateAxis time = gcs.getTimeAxis();
        assert (time != null) : "Cant find time for " + gridName;
        assert (time.getRank() == 2) : "Time should be 2D " + gridName;
        if (showCount) {
            System.out.println(" runtimes=" + runtime.getSize());
            System.out.println(" ntimes=" + time.getDimension(1).getLength());
        }
        if (ngrids >= 0) assert (ngrids == countGrids) : "Grids " + ngrids + " != " + countGrids;
        if (ncoordAxes >= 0) assert (ncoordAxes == countCoordAxes) : "CoordAxes " + ncoordAxes + " != " + countCoordAxes;
        if (nVertCooordAxes >= 0) assert (nVertCooordAxes == countVertCooordAxes) : "VertAxes" + nVertCooordAxes + " != " + countVertCooordAxes;
        if (nruns >= 0) assert (runtime.getSize() == (long)nruns) : runtime.getSize() + " != " + nruns;
        if (nruns >= 0) assert (time.getDimension(0).getLength() == nruns) : " nruns should be " + nruns;
        if (ntimes >= 0) assert (time.getDimension(1).getLength() == ntimes) : " ntimes should be " + ntimes;
        gridDs.close();
    }

    static void doOneBest(String pathname, int ngrids, int ncoordSys, int ncoordAxes, int nVertCooordAxes, String gridName, int nruns, int ntimes) throws Exception {
        System.out.println("Best dataset");
        Formatter errlog = new Formatter();
        Fmrc fmrc = Fmrc.open((String)pathname, (Formatter)errlog);
        if (fmrc == null) {
            System.out.printf("Fmrc failed to open %s%n", pathname);
            System.out.printf("errlog= %s%n", errlog.toString());
            return;
        }
        GridDataset gridDs = fmrc.getDatasetBest();
        NetcdfDataset ncd = (NetcdfDataset)gridDs.getNetcdfFile();
        int countGrids = gridDs.getGrids().size();
        int countCoordAxes = ncd.getCoordinateAxes().size();
        int countCoordSys = ncd.getCoordinateSystems().size();
        int countVertCooordAxes = 0;
        List axes = ncd.getCoordinateAxes();
        for (int i = 0; i < axes.size(); ++i) {
            CoordinateAxis axis = (CoordinateAxis)axes.get(i);
            AxisType t = axis.getAxisType();
            if (t != AxisType.GeoZ && t != AxisType.Height && t != AxisType.Pressure) continue;
            ++countVertCooordAxes;
        }
        if (showCount) {
            System.out.println(" grids=" + countGrids + (ngrids < 0 ? " *" : ""));
            System.out.println(" coordSys=" + countCoordSys + (ncoordSys < 0 ? " *" : ""));
            System.out.println(" coordAxes=" + countCoordAxes + (ncoordAxes < 0 ? " *" : ""));
            System.out.println(" vertAxes=" + countVertCooordAxes + (nVertCooordAxes < 0 ? " *" : ""));
        }
        for (GridDataset.Gridset gridset : gridDs.getGridsets()) {
            gridset.getGeoCoordSystem();
        }
        GridDatatype grid = gridDs.findGridDatatype(gridName);
        assert (grid != null) : "Cant find grid " + gridName;
        GridCoordSystem gcs = grid.getCoordinateSystem();
        CoordinateAxis1DTime runtime = gcs.getRunTimeAxis();
        assert (runtime != null) : "Cant find runtime for " + gridName;
        CoordinateAxis time = gcs.getTimeAxis();
        assert (time != null) : "Cant find time for " + gridName;
        if (showCount) {
            System.out.println(" ntimes=" + time.getDimension(0).getLength());
        }
        if (ngrids >= 0) assert (ngrids == countGrids) : "Grids " + ngrids + " != " + countGrids;
        if (ntimes >= 0) assert (time.getDimension(0).getLength() == ntimes) : " ntimes should be " + ntimes;
        gridDs.close();
    }
}

