/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.trajectory;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Range;
import ucar.ma2.StructureData;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dt.DataIterator;
import ucar.nc2.dt.PointObsDatatype;
import ucar.nc2.dt.TrajectoryObsDataset;
import ucar.nc2.dt.TrajectoryObsDatatype;
import ucar.nc2.dt.TypedDatasetFactory;
import ucar.nc2.dt.trajectory.RafTrajectoryObsDataset;
import ucar.nc2.dt.trajectory.TestTrajectoryObsDataset;

public class TestRafTrajectoryObsDataset
extends TestCase {
    private TrajectoryObsDataset me;
    private String testFilePath = TestTrajectoryObsDataset.getRemoteTestDataDir() + "/trajectory/aircraft";
    private String test_Raf_1_2_FileName = "raftrack.nc";
    private String test_Raf_1_3_Recvar_FileName = "135_raw.nc";
    private String test_Raf_1_3_NoRecvar_FileName = "135_ordrd.nc";

    public TestRafTrajectoryObsDataset(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void testRaf_1_2() throws IOException {
        String location = this.testFilePath + "/" + this.test_Raf_1_2_FileName;
        TestRafTrajectoryObsDataset.assertTrue((String)("Test file <" + location + "> does not exist."), (boolean)new File(location).exists());
        try {
            StringBuilder errlog = new StringBuilder();
            this.me = (TrajectoryObsDataset)TypedDatasetFactory.open((FeatureType)FeatureType.TRAJECTORY, (String)location, null, (StringBuilder)errlog);
        }
        catch (IOException e) {
            String tmpMsg = "Couldn't create TrajectoryObsDataset from RAF aircraft file <" + location + ">: " + e.getMessage();
            TestRafTrajectoryObsDataset.assertTrue((String)tmpMsg, (boolean)false);
        }
        TestRafTrajectoryObsDataset.assertTrue((String)("Null TrajectoryObsDataset after open <" + location + "> "), (this.me != null ? 1 : 0) != 0);
        TestRafTrajectoryObsDataset.assertTrue((String)("Dataset <" + location + "> not a RafTrajectoryObsDataset."), (boolean)(this.me instanceof RafTrajectoryObsDataset));
        int dsNumVars = 341;
        String exampleVarName = "PITCH";
        String exampleVarDescription = "Aircraft Pitch Angle";
        String exampleVarUnitsString = "deg";
        int exampleVarRank = 0;
        int[] exampleVarShape = new int[]{};
        String exampleVarDataType = DataType.FLOAT.toString();
        int exampleVarNumAtts = 6;
        int numTrajs = 1;
        String exampleTrajId = "1Hz data";
        String exampleTrajDesc = null;
        int exampleTrajNumPoints = 8157;
        float exampleTrajStartLat = 17.129574f;
        float exampleTrajEndLat = 17.124596f;
        float exampleTrajStartLon = -61.8017f;
        float exampleTrajEndLon = -61.79552f;
        float exampleTrajStartElev = -34.01111f;
        float exampleTrajEndElev = -19.944588f;
        TestTrajectoryObsDataset.TrajDatasetInfo trajDsInfo = new TestTrajectoryObsDataset.TrajDatasetInfo(null, null, location, 1105193344000L, 1105201500000L, null, 14, "Source", "NCAR Research Aviation Facility", dsNumVars, exampleVarName, exampleVarDescription, exampleVarUnitsString, exampleVarRank, exampleVarShape, exampleVarDataType, exampleVarNumAtts, new Float(0.18874642f), new Float(-1.0590017f), numTrajs, exampleTrajId, exampleTrajDesc, exampleTrajNumPoints, exampleTrajStartLat, exampleTrajEndLat, exampleTrajStartLon, exampleTrajEndLon, exampleTrajStartElev, exampleTrajEndElev);
        TestTrajectoryObsDataset.testTrajInfo(this.me, trajDsInfo);
    }

    public void testRaf_1_3_Recvar_And_NoRecvar() throws IOException {
        String location = this.testFilePath + "/" + this.test_Raf_1_3_Recvar_FileName;
        TestRafTrajectoryObsDataset.assertTrue((String)("Test file <" + location + "> does not exist."), (boolean)new File(location).exists());
        try {
            StringBuilder errlog = new StringBuilder();
            this.me = (TrajectoryObsDataset)TypedDatasetFactory.open((FeatureType)FeatureType.TRAJECTORY, (String)location, null, (StringBuilder)errlog);
        }
        catch (IOException e) {
            String tmpMsg = "Couldn't create TrajectoryObsDataset from RAF aircraft file <" + location + ">: " + e.getMessage();
            TestRafTrajectoryObsDataset.assertTrue((String)tmpMsg, (boolean)false);
        }
        TestRafTrajectoryObsDataset.assertTrue((String)("Null TrajectoryObsDataset after open <" + location + "> "), (this.me != null ? 1 : 0) != 0);
        TestRafTrajectoryObsDataset.assertTrue((String)("Dataset <" + location + "> not a RafTrajectoryObsDataset."), (boolean)(this.me instanceof RafTrajectoryObsDataset));
        long startDateLong = 1102515300000L;
        long endDateLong = 1102523040000L;
        int numGlobalAtts = 16;
        String exampGlobalAttName = "Source";
        String exampGlobalAttVal = "NCAR Research Aviation Facility";
        int dsNumVars = 350;
        String exampleVarName = "PITCH";
        String exampleVarDescription = "Aircraft Pitch Angle";
        String exampleVarUnitsString = "deg";
        int exampleVarRank = 0;
        int[] exampleVarShape = new int[]{};
        String exampleVarDataType = DataType.FLOAT.toString();
        int exampleVarNumAtts = 11;
        Float exampleVarStartVal = new Float(-0.1351365f);
        Float exampleVarEndVal = new Float(-1.3088403f);
        int numTrajs = 1;
        String exampleTrajId = "1Hz data";
        String exampleTrajDesc = null;
        int exampleTrajNumPoints = 7741;
        float exampleTrajStartLat = 17.11825f;
        float exampleTrajEndLat = 17.137465f;
        float exampleTrajStartLon = -61.817482f;
        float exampleTrajEndLon = -61.79102f;
        float exampleTrajStartElev = 28.45f;
        float exampleTrajEndElev = 23.349998f;
        TestTrajectoryObsDataset.TrajDatasetInfo trajDsInfo = new TestTrajectoryObsDataset.TrajDatasetInfo(null, null, location, startDateLong, endDateLong, null, numGlobalAtts, exampGlobalAttName, exampGlobalAttVal, dsNumVars, exampleVarName, exampleVarDescription, exampleVarUnitsString, exampleVarRank, exampleVarShape, exampleVarDataType, exampleVarNumAtts, exampleVarStartVal, exampleVarEndVal, numTrajs, exampleTrajId, exampleTrajDesc, exampleTrajNumPoints, exampleTrajStartLat, exampleTrajEndLat, exampleTrajStartLon, exampleTrajEndLon, exampleTrajStartElev, exampleTrajEndElev);
        TestTrajectoryObsDataset.testTrajInfo(this.me, trajDsInfo);
        location = this.testFilePath + "/" + this.test_Raf_1_3_NoRecvar_FileName;
        try {
            StringBuilder errlog = new StringBuilder();
            this.me = (TrajectoryObsDataset)TypedDatasetFactory.open((FeatureType)FeatureType.TRAJECTORY, (String)location, null, (StringBuilder)errlog);
        }
        catch (IOException e) {
            String tmpMsg = "Couldn't create TrajectoryObsDataset from RAF aircraft file <" + location + ">: " + e.getMessage();
            TestRafTrajectoryObsDataset.assertTrue((String)tmpMsg, (boolean)false);
        }
        TestRafTrajectoryObsDataset.assertTrue((String)("Null TrajectoryObsDataset after open <" + location + "> "), (this.me != null ? 1 : 0) != 0);
        TestRafTrajectoryObsDataset.assertTrue((String)("Dataset <" + location + "> not a RafTrajectoryObsDataset."), (boolean)(this.me instanceof RafTrajectoryObsDataset));
        trajDsInfo.setLocationURI(location);
        TestTrajectoryObsDataset.testTrajInfo(this.me, trajDsInfo);
    }

    public void formerly_testTiming() throws Exception {
        PointObsDatatype pointOb;
        StructureData structData;
        Array a;
        String location = this.testFilePath + "/" + this.test_Raf_1_3_Recvar_FileName;
        TestRafTrajectoryObsDataset.assertTrue((String)("Test file <" + location + "> does not exist."), (boolean)new File(location).exists());
        try {
            StringBuilder errlog = new StringBuilder();
            this.me = (TrajectoryObsDataset)TypedDatasetFactory.open((FeatureType)FeatureType.TRAJECTORY, (String)location, null, (StringBuilder)errlog);
        }
        catch (IOException e) {
            String tmpMsg = "Couldn't create TrajectoryObsDataset from RAF aircraft file <" + location + ">: " + e.getMessage();
            TestRafTrajectoryObsDataset.assertTrue((String)tmpMsg, (boolean)false);
        }
        TestRafTrajectoryObsDataset.assertTrue((String)("Null TrajectoryObsDataset after open <" + location + "> "), (this.me != null ? 1 : 0) != 0);
        TestRafTrajectoryObsDataset.assertTrue((String)("Dataset <" + location + "> not a RafTrajectoryObsDataset."), (boolean)(this.me instanceof RafTrajectoryObsDataset));
        TrajectoryObsDatatype trajDt = this.me.getTrajectory("1Hz data");
        Range range = trajDt.getFullRange();
        long startDate = System.currentTimeMillis();
        for (VariableSimpleIF var : trajDt.getDataVariables()) {
            a = trajDt.getData(range, var.getName());
        }
        long endDate = System.currentTimeMillis();
        System.out.println("Variable-oriented read of record written data: " + (double)(endDate - startDate) / 1000.0 + " seconds");
        startDate = System.currentTimeMillis();
        for (int i = 0; i < trajDt.getNumberPoints(); ++i) {
            structData = trajDt.getData(i);
        }
        endDate = System.currentTimeMillis();
        System.out.println("Point-oriented read of record written data: " + (double)(endDate - startDate) / 1000.0 + " seconds");
        startDate = System.currentTimeMillis();
        DataIterator it = trajDt.getDataIterator(0);
        while (it.hasNext()) {
            pointOb = (PointObsDatatype)it.nextData();
        }
        endDate = System.currentTimeMillis();
        System.out.println("Point-oriented iterator read of record written data: " + (double)(endDate - startDate) / 1000.0 + " seconds");
        location = this.testFilePath + "/" + this.test_Raf_1_3_NoRecvar_FileName;
        TestRafTrajectoryObsDataset.assertTrue((String)("Test file <" + location + "> does not exist."), (boolean)new File(location).exists());
        try {
            StringBuilder errlog = new StringBuilder();
            this.me = (TrajectoryObsDataset)TypedDatasetFactory.open((FeatureType)FeatureType.TRAJECTORY, (String)location, null, (StringBuilder)errlog);
        }
        catch (IOException e) {
            String tmpMsg = "Couldn't create TrajectoryObsDataset from RAF aircraft file <" + location + ">: " + e.getMessage();
            TestRafTrajectoryObsDataset.assertTrue((String)tmpMsg, (boolean)false);
        }
        TestRafTrajectoryObsDataset.assertTrue((String)("Null TrajectoryObsDataset after open <" + location + "> "), (this.me != null ? 1 : 0) != 0);
        TestRafTrajectoryObsDataset.assertTrue((String)("Dataset <" + location + "> not a RafTrajectoryObsDataset."), (boolean)(this.me instanceof RafTrajectoryObsDataset));
        trajDt = this.me.getTrajectory("1Hz data");
        range = trajDt.getFullRange();
        startDate = System.currentTimeMillis();
        for (VariableSimpleIF var : trajDt.getDataVariables()) {
            a = trajDt.getData(range, var.getName());
        }
        endDate = System.currentTimeMillis();
        System.out.println("Variable-oriented read of non-record written data: " + (double)(endDate - startDate) / 1000.0 + " seconds");
        startDate = System.currentTimeMillis();
        for (int i = 0; i < trajDt.getNumberPoints(); ++i) {
            structData = trajDt.getData(i);
        }
        endDate = System.currentTimeMillis();
        System.out.println("Point-oriented read of non-record written data: " + (double)(endDate - startDate) / 1000.0 + " seconds");
        startDate = System.currentTimeMillis();
        it = trajDt.getDataIterator(0);
        while (it.hasNext()) {
            pointOb = (PointObsDatatype)it.nextData();
        }
        endDate = System.currentTimeMillis();
        System.out.println("Point-oriented iterator read of non-record written data: " + (double)(endDate - startDate) / 1000.0 + " seconds");
        TestRafTrajectoryObsDataset.assertTrue((String)"Timing output", (boolean)false);
    }
}

