/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.trajectory;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dt.PointObsDatatype;
import ucar.nc2.dt.TrajectoryObsDataset;
import ucar.nc2.dt.TrajectoryObsDatatype;
import ucar.nc2.dt.TypedDatasetFactory;
import ucar.nc2.dt.trajectory.ARMTrajectoryObsDataset;
import ucar.nc2.dt.trajectory.TestTrajectoryObsDataset;
import ucar.unidata.geoloc.LatLonRect;

public class TestARMTrajectoryObsDataset
extends TestCase {
    private TrajectoryObsDataset me;
    private String testFilePath = TestTrajectoryObsDataset.getRemoteTestDataDir() + "/trajectory/sonde";
    private String testDataFileName = "sgpsondewnpnC1.a1.20020507.112400.cdf";

    public TestARMTrajectoryObsDataset(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void testARM() throws IOException {
        StructureData sdata;
        PointObsDatatype pointOb;
        String location = this.testFilePath + "/" + this.testDataFileName;
        TestARMTrajectoryObsDataset.assertTrue((String)("Test file <" + location + "> does not exist."), (boolean)new File(location).exists());
        try {
            StringBuilder errlog = new StringBuilder();
            this.me = (TrajectoryObsDataset)TypedDatasetFactory.open((FeatureType)FeatureType.TRAJECTORY, (String)location, null, (StringBuilder)errlog);
        }
        catch (IOException e) {
            String tmpMsg = "Couldn't create TrajectoryObsDataset from ARM sonde file <" + location + ">: " + e.getMessage();
            TestARMTrajectoryObsDataset.assertTrue((String)tmpMsg, (boolean)false);
        }
        TestARMTrajectoryObsDataset.assertTrue((String)("Null TrajectoryObsDataset after open <" + location + "> "), (this.me != null ? 1 : 0) != 0);
        TestARMTrajectoryObsDataset.assertTrue((String)("Dataset <" + location + "> not a ARMTrajectoryObsDataset."), (boolean)(this.me instanceof ARMTrajectoryObsDataset));
        String dsTitle = null;
        String dsDescrip = null;
        long dsStartDateLong = 1020770640000L;
        long dsEndDateLong = 1020776540000L;
        LatLonRect dsBoundBox = null;
        int dsNumGlobalAtts = 27;
        String exampleGlobalAttName = "history";
        String exampleGlobalAttVal = "created by the Zebra DataStore library";
        int dsNumVars = 10;
        String exampleVarName = "tdry";
        String exampleVarDescription = "Dry Bulb Temperature";
        String exampleVarUnitsString = "C";
        int exampleVarRank = 0;
        int[] exampleVarShape = new int[]{};
        String exampleVarDataType = DataType.FLOAT.toString();
        int exampleVarNumAtts = 4;
        Float exampleVarStartVal = new Float(21.0f);
        Float exampleVarEndVal = new Float(-49.1f);
        int numTrajs = 1;
        String exampleTrajId = "trajectory data";
        String exampleTrajDesc = null;
        int exampleTrajNumPoints = 2951;
        float exampleTrajStartLat = 36.61f;
        float exampleTrajEndLat = 37.12618f;
        float exampleTrajStartLon = -97.49f;
        float exampleTrajEndLon = -96.28289f;
        float exampleTrajStartElev = 315.0f;
        float exampleTrajEndElev = 26771.0f;
        TestTrajectoryObsDataset.TrajDatasetInfo trajDsInfo = new TestTrajectoryObsDataset.TrajDatasetInfo(dsTitle, dsDescrip, location, dsStartDateLong, dsEndDateLong, dsBoundBox, dsNumGlobalAtts, exampleGlobalAttName, exampleGlobalAttVal, dsNumVars, exampleVarName, exampleVarDescription, exampleVarUnitsString, exampleVarRank, exampleVarShape, exampleVarDataType, exampleVarNumAtts, exampleVarStartVal, exampleVarEndVal, numTrajs, exampleTrajId, exampleTrajDesc, exampleTrajNumPoints, exampleTrajStartLat, exampleTrajEndLat, exampleTrajStartLon, exampleTrajEndLon, exampleTrajStartElev, exampleTrajEndElev);
        TestTrajectoryObsDataset.testTrajInfo(this.me, trajDsInfo);
        TrajectoryObsDatatype traj = this.me.getTrajectory(exampleTrajId);
        try {
            pointOb = traj.getPointObsData(0);
        }
        catch (IOException e) {
            TestARMTrajectoryObsDataset.assertTrue((String)("IOException on call to getPointObsData(0): " + e.getMessage()), (boolean)false);
            return;
        }
        try {
            sdata = pointOb.getData();
        }
        catch (IOException e) {
            TestARMTrajectoryObsDataset.assertTrue((String)("IOException on getData(): " + e.getMessage()), (boolean)false);
            return;
        }
        String u = sdata.findMember("alt").getUnitsString();
        assert (u.equals("meters")) : "traj.getPointObsData().getData().findMember( \"alt\") units <" + u + "> not as expected";
        try {
            sdata = traj.getData(0);
        }
        catch (IOException e) {
            TestARMTrajectoryObsDataset.assertTrue((String)("IOException on getData(0): " + e.getMessage()), (boolean)false);
            return;
        }
        catch (InvalidRangeException e) {
            TestARMTrajectoryObsDataset.assertTrue((String)("InvalidRangeException on getData(0): " + e.getMessage()), (boolean)false);
            return;
        }
    }
}

