/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.grid;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.TestAll;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.grid.GeoGrid;
import ucar.nc2.dt.grid.GridDataset;
import ucar.unidata.geoloc.vertical.VerticalTransform;

public class TestVerticalTransforms
extends TestCase {
    public TestVerticalTransforms(String name) {
        super(name);
    }

    public void testWRF() throws Exception {
        this.testDataset(TestAll.testdataDir + "grid/netcdf/wrf/wrfout_v2_Lambert.nc");
        this.testDataset(TestAll.testdataDir + "grid/netcdf/wrf/wrfout_d01_2006-03-08_21-00-00");
    }

    private void testDataset(String location) throws IOException, InvalidRangeException {
        GridDataset dataset = GridDataset.open((String)location);
        assert (dataset != null);
        this.testGrid(dataset.findGridByName("U"));
        this.testGrid(dataset.findGridByName("V"));
        this.testGrid(dataset.findGridByName("W"));
        this.testGrid(dataset.findGridByName("T"));
        dataset.close();
    }

    private void testGrid(GeoGrid grid) throws IOException, InvalidRangeException {
        assert (null != grid);
        GridCoordSystem gcs = grid.getCoordinateSystem();
        assert (null != gcs);
        assert (grid.getRank() == 4);
        Array data = grid.readDataSlice(0, -1, -1, -1);
        assert (data.getRank() == 3);
        CoordinateAxis1D zaxis = gcs.getVerticalAxis();
        assert ((long)data.getShape()[0] == zaxis.getSize()) : zaxis.getSize();
        CoordinateAxis yaxis = gcs.getYHorizAxis();
        assert ((long)data.getShape()[1] == yaxis.getSize()) : yaxis.getSize();
        CoordinateAxis xaxis = gcs.getXHorizAxis();
        assert ((long)data.getShape()[2] == xaxis.getSize()) : xaxis.getSize();
        VerticalTransform vt = gcs.getVerticalTransform();
        assert (vt != null);
        assert (vt.getUnitString() != null);
        ArrayDouble.D3 vcoord = vt.getCoordinateArray(0);
        assert ((long)vcoord.getShape()[0] == zaxis.getSize()) : vcoord.getShape()[0];
        assert ((long)vcoord.getShape()[1] == yaxis.getSize()) : vcoord.getShape()[1];
        assert ((long)vcoord.getShape()[2] == xaxis.getSize()) : vcoord.getShape()[2];
    }
}

