/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.grid;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dt.grid.GeoGrid;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.dt.grid.TestGrid;

public class TestReadPermute
extends TestCase {
    private boolean show = true;

    public TestReadPermute(String name) {
        super(name);
    }

    public void testReadPermute() {
        block2: {
            try {
                GridDataset dataset = GridDataset.open((String)(TestGrid.topDir + "permuteTest.nc"));
                this.doRead4(dataset, "tzyx");
                this.doRead4(dataset, "tzxy");
                this.doRead4(dataset, "txyz");
                this.doRead4(dataset, "tyxz");
                this.doRead4(dataset, "zyxt");
                this.doRead4(dataset, "zxyt");
                this.doRead4(dataset, "xyzt");
                this.doRead4(dataset, "yxzt");
                this.doRead3(dataset, "zyx");
                this.doRead3(dataset, "txy");
                this.doRead3(dataset, "yxz");
                this.doRead3(dataset, "xzy");
                this.doRead3(dataset, "yxt");
                this.doRead3(dataset, "xyt");
                this.doRead3(dataset, "yxt");
                this.doRead3(dataset, "xyz");
                this.doRead2(dataset, "yx");
                this.doRead2(dataset, "xy");
                this.doRead2(dataset, "yz");
                this.doRead2(dataset, "xz");
                this.doRead2(dataset, "yt");
                this.doRead2(dataset, "xt");
                this.doRead2(dataset, "ty");
                this.doRead2(dataset, "tx");
                this.doRead4Volume(dataset, "tzyx");
                this.doRead4Volume(dataset, "tzxy");
                this.doRead4Volume(dataset, "txyz");
                this.doRead4Volume(dataset, "tyxz");
                this.doRead4Volume(dataset, "zyxt");
                this.doRead4Volume(dataset, "zxyt");
                this.doRead4Volume(dataset, "xyzt");
                this.doRead4Volume(dataset, "yxzt");
                this.doRead3Volume(dataset, "txy");
                this.doRead3Volume(dataset, "yxt");
                this.doRead3Volume(dataset, "xyt");
                this.doRead3Volume(dataset, "yxt");
                this.doRead3XY(dataset, "zyx");
                this.doRead3XY(dataset, "yxz");
                this.doRead3XY(dataset, "xzy");
                this.doRead3XY(dataset, "xyz");
                dataset.close();
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)e.getMessage());
            }
        }
        System.out.println("*****************Test Read done");
    }

    private void doRead4(GridDataset ds, String varName) throws IOException {
        GeoGrid gg = ds.findGridByName(varName);
        this.testOrder(gg);
        Array aa = gg.readDataSlice(-1, -1, -1, -1);
        int[] shape = aa.getShape();
        Index ima = aa.getIndex();
        int[] w = this.getWeights(gg);
        for (int i = 0; i < shape[0]; ++i) {
            for (int j = 0; j < shape[1]; ++j) {
                for (int k = 0; k < shape[2]; ++k) {
                    for (int m = 0; m < shape[3]; ++m) {
                        double got = aa.getDouble(ima.set(i, j, k, m));
                        double want = i * w[0] + j * w[1] + k * w[2] + m * w[3];
                        assert (got == want) : "got " + got + " want " + want;
                    }
                }
            }
        }
        System.out.println("ok reading " + varName);
    }

    private void doRead3(GridDataset ds, String varName) throws IOException {
        GeoGrid gg = ds.findGridByName(varName);
        this.testOrder(gg);
        Array aa = gg.readDataSlice(-1, -1, -1, -1);
        int[] shape = aa.getShape();
        int[] w = this.getWeights(gg);
        Index ima = aa.getIndex();
        for (int i = 0; i < shape[0]; ++i) {
            for (int j = 0; j < shape[1]; ++j) {
                for (int k = 0; k < shape[2]; ++k) {
                    double got = aa.getDouble(ima.set(i, j, k));
                    double want = i * w[0] + j * w[1] + k * w[2];
                    assert (got == want) : "got " + got + " want " + want;
                }
            }
        }
        System.out.println("ok reading " + varName);
    }

    private void doRead2(GridDataset ds, String varName) throws IOException {
        GeoGrid gg = ds.findGridByName(varName);
        if (gg == null) {
            return;
        }
        this.testOrder(gg);
        Array aa = gg.readDataSlice(-1, -1, -1, -1);
        int[] shape = aa.getShape();
        int[] w = this.getWeights(gg);
        Index ima = aa.getIndex();
        for (int i = 0; i < shape[0]; ++i) {
            for (int j = 0; j < shape[1]; ++j) {
                double got = aa.getDouble(ima.set(i, j));
                double want = i * w[0] + j * w[1];
                assert (got == want) : "got " + got + " want " + want;
            }
        }
        System.out.println("ok reading " + varName);
    }

    private int[] getWeights(GeoGrid gg) {
        int rank = gg.getRank();
        int[] w = new int[rank];
        for (int n = 0; n < rank; ++n) {
            Dimension dim = gg.getDimension(n);
            String dimName = dim.getName();
            if (dimName.equals("time")) {
                w[n] = 1000;
            }
            if (dimName.equals("z")) {
                w[n] = 100;
            }
            if (dimName.equals("y")) {
                w[n] = 10;
            }
            if (!dimName.equals("x")) continue;
            w[n] = 1;
        }
        return w;
    }

    private void testOrder(GeoGrid gg) {
        int current = -1;
        int idx = gg.getTimeDimensionIndex();
        if (idx >= 0) {
            assert (idx > current);
            current = idx;
        }
        if ((idx = gg.getZDimensionIndex()) >= 0) {
            assert (idx > current);
            current = idx;
        }
        if ((idx = gg.getYDimensionIndex()) >= 0) {
            assert (idx > current);
            current = idx;
        }
        if ((idx = gg.getXDimensionIndex()) >= 0) {
            assert (idx > current);
            current = idx;
        }
    }

    private void doRead4Volume(GridDataset ds, String varName) throws IOException {
        GeoGrid gg = ds.findGridByName(varName);
        CoordinateAxis1DTime timeAxis = gg.getCoordinateSystem().getTimeAxis1D();
        int t = 0;
        while ((long)t < timeAxis.getSize()) {
            Array aa = gg.readVolumeData(t);
            int[] shape = aa.getShape();
            Index ima = aa.getIndex();
            for (int i = 0; i < shape[0]; ++i) {
                for (int j = 0; j < shape[1]; ++j) {
                    for (int k = 0; k < shape[2]; ++k) {
                        double got = aa.getDouble(ima.set(i, j, k));
                        double want = t * 1000 + i * 100 + j * 10 + k;
                        assert (got == want) : "got " + got + " want " + want;
                    }
                }
            }
            ++t;
        }
        System.out.println("*** ok reading doRead4Volume for " + varName);
    }

    private void doRead3Volume(GridDataset ds, String varName) throws IOException {
        GeoGrid gg = ds.findGridByName(varName);
        CoordinateAxis1DTime timeAxis = gg.getCoordinateSystem().getTimeAxis1D();
        int[] w = this.getWeights(gg);
        int t = 0;
        while ((long)t < timeAxis.getSize()) {
            Array aa = gg.readVolumeData(t);
            int[] shape = aa.getShape();
            Index ima = aa.getIndex();
            for (int i = 0; i < shape[0]; ++i) {
                for (int j = 0; j < shape[1]; ++j) {
                    double got = aa.getDouble(ima.set(i, j));
                    double want = t * 1000 + i * w[1] + j * w[2];
                    assert (got == want) : "got " + got + " want " + want;
                }
            }
            ++t;
        }
        System.out.println("*** ok reading doRead3Volume for " + varName);
    }

    private void doRead3XY(GridDataset ds, String varName) throws IOException {
        GeoGrid gg = ds.findGridByName(varName);
        CoordinateAxis1D zAxis = gg.getCoordinateSystem().getVerticalAxis();
        int[] w = this.getWeights(gg);
        int z = 0;
        while ((long)z < zAxis.getSize()) {
            Array aa = gg.readYXData(0, z);
            int[] shape = aa.getShape();
            Index ima = aa.getIndex();
            for (int i = 0; i < shape[0]; ++i) {
                for (int j = 0; j < shape[1]; ++j) {
                    double got = aa.getDouble(ima.set(i, j));
                    double want = z * 100 + i * w[1] + j * w[2];
                    assert (got == want) : "got " + got + " want " + want;
                }
            }
            ++z;
        }
        System.out.println("*** ok reading doRead3XY for " + varName);
    }
}

