/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.grid;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;

public class TestLongitudeWrap
extends TestCase {
    public TestLongitudeWrap(String name) {
        super(name);
    }

    public void testTimeAxisEval() throws IOException {
        String testFileFullPath = "E:/work/margolis/bugfix/echoTops_runtime.nc";
        GridDataset runtimeDataset = new GridDataset(new NetcdfDataset(NetcdfFile.open((String)testFileFullPath)));
        if (runtimeDataset.getGrids().isEmpty()) {
            throw new RuntimeException("Runtime data file did not generate a dataset with grids");
        }
        if (((GridDatatype)runtimeDataset.getGrids().get(0)).getCoordinateSystem().getRunTimeAxis() == null) {
            throw new RuntimeException("Runtime data file did not generate a dataset with a RunTime axis");
        }
        System.out.println("BugFixesTest - completed.");
    }

    public void testLongitudeWrap() throws Exception {
        String testFileFullPath = "E:/work/margolis/bugfix/gfs_crossPM_contiguous.nc";
        String targetGridName = "Temperature_altitude_above_msl";
        GridDataset dataset = GridDataset.open((String)testFileFullPath);
        GridDatatype targetGrid = dataset.findGridDatatype(targetGridName);
        if (targetGrid == null) {
            throw new RuntimeException("Grid '" + targetGridName + "' does not exist in data file");
        }
        GridCoordSystem coordSys = targetGrid.getCoordinateSystem();
        TestLongitudeWrap.validateIndices(coordSys, 38.0, -10.0, new int[]{92, 1});
        TestLongitudeWrap.validateIndices(coordSys, 38.0, 350.0, new int[]{92, 1});
        TestLongitudeWrap.validateIndices(coordSys, 38.0, -8.0, new int[]{94, 1});
        TestLongitudeWrap.validateIndices(coordSys, 38.0, 352.0, new int[]{94, 1});
        TestLongitudeWrap.validateIndices(coordSys, 38.0, -0.6, new int[]{101, 1});
        TestLongitudeWrap.validateIndices(coordSys, 38.0, 359.4, new int[]{101, 1});
        TestLongitudeWrap.validateIndices(coordSys, 38.0, 0.0, new int[]{102, 1});
        TestLongitudeWrap.validateIndices(coordSys, 38.0, 360.0, new int[]{102, 1});
        TestLongitudeWrap.validateIndices(coordSys, 38.0, 4.0, new int[]{106, 1});
        TestLongitudeWrap.validateIndices(coordSys, 38.0, 364.0, new int[]{106, 1});
        TestLongitudeWrap.validateIndices(coordSys, 39.0, -10.0, new int[]{92, 0});
        TestLongitudeWrap.validateIndices(coordSys, 39.0, 350.0, new int[]{92, 0});
        TestLongitudeWrap.validateIndices(coordSys, 39.0, -8.0, new int[]{94, 0});
        TestLongitudeWrap.validateIndices(coordSys, 39.0, 352.0, new int[]{94, 0});
        TestLongitudeWrap.validateIndices(coordSys, 39.0, -0.6, new int[]{101, 0});
        TestLongitudeWrap.validateIndices(coordSys, 39.0, 359.4, new int[]{101, 0});
        TestLongitudeWrap.validateIndices(coordSys, 39.0, 0.0, new int[]{102, 0});
        TestLongitudeWrap.validateIndices(coordSys, 39.0, 360.0, new int[]{102, 0});
        TestLongitudeWrap.validateIndices(coordSys, 39.0, 4.0, new int[]{106, 0});
        TestLongitudeWrap.validateIndices(coordSys, 39.0, 364.0, new int[]{106, 0});
        TestLongitudeWrap.validateIndicesBounded(coordSys, 38.0, -20.0, new int[]{82, 1});
        TestLongitudeWrap.validateIndicesBounded(coordSys, 38.0, 340.0, new int[]{82, 1});
        TestLongitudeWrap.validateIndicesBounded(coordSys, 38.0, 10.0, new int[]{112, 1});
        TestLongitudeWrap.validateIndicesBounded(coordSys, 38.0, 370.0, new int[]{112, 1});
        TestLongitudeWrap.validateIndicesBounded(coordSys, 39.0, -20.0, new int[]{82, 0});
        TestLongitudeWrap.validateIndicesBounded(coordSys, 39.0, 340.0, new int[]{82, 0});
        TestLongitudeWrap.validateIndicesBounded(coordSys, 39.0, 10.0, new int[]{112, 0});
        TestLongitudeWrap.validateIndicesBounded(coordSys, 39.0, 370.0, new int[]{112, 0});
    }

    private static void validateIndices(GridCoordSystem coordSystem, double lat, double lon, int[] expectedIndices) throws Exception {
        TestLongitudeWrap.validateIndices(coordSystem, lat, lon, expectedIndices, false);
    }

    private static void validateIndicesBounded(GridCoordSystem coordSystem, double lat, double lon, int[] expectedIndices) throws Exception {
        TestLongitudeWrap.validateIndices(coordSystem, lat, lon, expectedIndices, true);
    }

    private static void validateIndices(GridCoordSystem coordSystem, double lat, double lon, int[] expectedIndices, boolean bounded) throws Exception {
        int[] indices;
        int[] nArray = indices = bounded ? coordSystem.findXYindexFromLatLonBounded(lat, lon, null) : coordSystem.findXYindexFromLatLon(lat, lon, null);
        if (indices[0] != expectedIndices[0]) {
            throw new Exception("(latitude " + lat + ", longitude " + lon + ") expected index[0]==" + expectedIndices[0] + "; received index[0]==" + indices[0]);
        }
        if (indices[1] != expectedIndices[1]) {
            throw new Exception("(latitude " + lat + ", longitude " + lon + ") expected index[1]==" + expectedIndices[1] + "; received index[1]==" + indices[1]);
        }
    }
}

