/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import ucar.nc2.dt.point.decode.MetarParseReport;
import ucar.nc2.util.Misc;

public class TimeObsRaw {
    private static boolean showErrs = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        String url = "C:/TEMP/metars/save/rawC.raw";
        int count = 0;
        int bad = 0;
        BufferedReader fin = new BufferedReader(new InputStreamReader(new FileInputStream(url)), 10000);
        double sum = 0.0;
        long start = System.currentTimeMillis();
        try {
            String line;
            while (null != (line = fin.readLine())) {
                int pos = line.indexOf(61);
                if (pos > 0) {
                    line = line.substring(pos + 2);
                }
                try {
                    double val;
                    LinkedHashMap flds;
                    String valS;
                    MetarParseReport parser = new MetarParseReport();
                    if (!parser.parseReport(line)) {
                        if (showErrs) {
                            System.out.println("*** failed on <" + line + ">");
                        }
                        ++bad;
                    }
                    if ((valS = (String)(flds = parser.getFields()).get("Temperature")) != null && !Misc.closeEnough((double)(val = Double.parseDouble(valS)), (double)-99999.0)) {
                        sum += val;
                    }
                }
                catch (Exception e) {
                    if (showErrs) {
                        System.out.println("*** EXCEPTION " + line);
                    }
                    ++bad;
                }
                ++count;
            }
            long took = System.currentTimeMillis() - start;
            System.out.println("that took = " + took + " msecs temperature sum= " + sum);
        }
        finally {
            if (fin != null) {
                fin.close();
            }
        }
        System.out.println("successfully read " + count + " records " + bad + " bad");
    }
}

