/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dods;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayObject;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.dods.DODSStructure;
import ucar.nc2.dods.TestDODSRead;

public class TestDODSArrayOfStructureNested
extends TestCase {
    private boolean debug = false;
    private DODSNetcdfFile dodsfile;

    public TestDODSArrayOfStructureNested(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        DODSNetcdfFile.setPreload((boolean)false);
        this.dodsfile = TestDODSRead.open("test.53");
        DODSNetcdfFile.setPreload((boolean)true);
    }

    protected void tearDown() throws Exception {
        this.dodsfile.close();
    }

    public void testScalarReadByte() throws IOException {
        Variable v = null;
        Array a = null;
        assert (null != (v = this.dodsfile.findVariable("types")));
        assert (v instanceof Structure);
        Structure s = (Structure)v;
        assert (null != (v = s.findVariable("ss")));
        assert (v instanceof Structure);
        Structure ss = (Structure)v;
        assert (null != (v = ss.findVariable("f32")));
        assert (v.getShortName().equals("f32"));
        assert (v.getRank() == 0);
        assert (v.getSize() == 1L);
        assert (v.getDataType() == DataType.FLOAT);
        a = v.read();
        assert (a.getRank() == 0);
        assert (a.getSize() == 1L);
        assert (a.getElementType() == Float.TYPE);
        assert (a instanceof ArrayFloat.D0);
        float val = a.getFloat(a.getIndex());
        assert ((double)val == 0.0);
    }

    public void testReadScalarMemberVariable() throws IOException {
        Variable v = this.dodsfile.findVariable("types.ss.ui16");
        assert (v != null);
        assert (v.getRank() == 1);
        assert (v.getSize() == 10L);
        assert (v.getDataType() == DataType.SHORT) : v.getDataType();
        assert (v.isUnsigned());
        Array a = v.read();
        Index ima = a.getIndex();
        assert (a.getRank() == 1);
        assert (a.getSize() == 10L);
        assert (a.getInt(ima) == 0);
        v = this.dodsfile.findVariable("types.ss.s");
        assert (v != null);
        assert (v.getRank() == 0);
        assert (v.getDataType() == DataType.STRING) : v.getDataType();
        a = v.read();
        assert (a.getRank() == 0);
        assert (a instanceof ArrayObject.D0) : a.getClass().getName();
        ArrayObject.D0 a0 = (ArrayObject.D0)a;
        assert (a0.get().equals("This is a data test string (pass 0)."));
    }

    public void testReadArrayOfStructs() throws IOException, InvalidRangeException {
        Variable v = this.dodsfile.findVariable("types");
        assert (v != null);
        assert (v instanceof DODSStructure);
        assert (v.getRank() == 1);
        assert (v.getDataType() == DataType.STRUCTURE);
        DODSStructure struct = (DODSStructure)v;
        Array data = struct.read();
        assert (data.getRank() == 1);
        assert (data.getElementType().equals(StructureData.class));
        IndexIterator ii = data.getIndexIterator();
        while (ii.hasNext()) {
            Object d = ii.next();
            assert (d instanceof StructureData) : d.getClass().getName();
        }
    }

    public void testRead1DArrayOfStructs() throws IOException, InvalidRangeException {
        Variable v = this.dodsfile.findVariable("types");
        assert (v != null);
        assert (v instanceof DODSStructure);
        assert (v.getRank() == 1);
        assert (v.getDataType() == DataType.STRUCTURE);
        DODSStructure struct = (DODSStructure)v;
        int i = 0;
        while ((long)i < struct.getSize()) {
            StructureData sd = struct.readStructure(i);
            StructureMembers.Member m = sd.findMember("ss");
            assert (m != null);
            Array a = sd.getArray(m);
            assert (a.getRank() == 0);
            assert (a.getElementType() == StructureData.class);
            StructureData ss = (StructureData)a.getObject(a.getIndex());
            assert (ss.getScalarString("s").equals("This is a data test string (pass 0)."));
            ++i;
        }
    }
}

