/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.IOException;
import java.util.Set;
import junit.framework.TestCase;
import timing.Average;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;

public class TimeScaleOffsetMissing
extends TestCase {
    int N = 10;

    public TimeScaleOffsetMissing(String name) {
        super(name);
    }

    public void testScaleOffset() throws IOException, InvalidRangeException {
        Average all = new Average();
        Average alldefer = new Average();
        Average sm = new Average();
        Average smNoNans = new Average();
        Average coords = new Average();
        Average none = new Average();
        Average file = new Average();
        this.openDataset(NetcdfDataset.getEnhanceAll(), null);
        this.openFile(null);
        for (int i = 0; i < this.N; ++i) {
            this.openDataset(NetcdfDataset.getEnhanceAll(), all);
            this.openDataset(NetcdfDataset.parseEnhanceMode((String)"AllDefer"), alldefer);
            this.openDataset(NetcdfDataset.parseEnhanceMode((String)"ScaleMissing"), sm);
            NetcdfDataset.setUseNaNs((boolean)false);
            this.openDataset(NetcdfDataset.parseEnhanceMode((String)"ScaleMissing"), smNoNans);
            this.openDataset(NetcdfDataset.parseEnhanceMode((String)"CoordSystems"), coords);
            this.openDataset(null, none);
            this.openFile(file);
        }
        System.out.println(" all enhance=" + all);
        System.out.println(" all defer  =" + alldefer);
        System.out.println("scaleMissing=" + sm);
        System.out.println(" smNoNans   =" + smNoNans);
        System.out.println(" coords     =" + coords);
        System.out.println(" none       =" + none);
        System.out.println(" open File  =" + file);
    }

    public void openFile(Average avg) throws IOException, InvalidRangeException {
        long start = System.nanoTime();
        NetcdfFile ncfile = NetcdfDataset.openFile((String)(TestAll.testdataDir + "grid/netcdf/AZ.000000000.nc"), null);
        Variable v = ncfile.findVariable("qc");
        assert (null != v);
        assert (v.getDataType() == DataType.BYTE);
        Array data = v.read();
        assert (data.getElementType() == Byte.TYPE);
        double sum = MAMath.sumDoubleSkipMissingData((Array)data, (double)Double.NaN);
        long end = System.nanoTime();
        double took = (double)(end - start) / 1000.0 / 1000.0 / 1000.0;
        double perelem = (double)(end - start) / (double)data.getSize();
        ncfile.close();
        if (avg != null) {
            avg.add(took);
        }
    }

    public void openDataset(Set<NetcdfDataset.Enhance> enhance, Average avg) throws IOException, InvalidRangeException {
        long start = System.nanoTime();
        NetcdfDataset ncd = NetcdfDataset.openDataset((String)(TestAll.testdataDir + "grid/netcdf/AZ.000000000.nc"), enhance, (int)-1, null, null);
        Variable v = ncd.findVariable("qc");
        assert (null != v);
        Array data = v.read();
        double sum = MAMath.sumDoubleSkipMissingData((Array)data, (double)Double.NaN);
        long end = System.nanoTime();
        double took = (double)(end - start) / 1000.0 / 1000.0 / 1000.0;
        double perelem = (double)(end - start) / (double)data.getSize();
        ncd.close();
        if (avg != null) {
            avg.add(took);
        }
    }

    public void testNaNs() throws IOException, InvalidRangeException {
        NetcdfDataset.setUseNaNs((boolean)true);
        NetcdfDataset ncd = NetcdfDataset.openDataset((String)(TestAll.testdataDir + "grid/netcdf/AZ.000000000.nc"), (boolean)true, null);
        VariableDS v = (VariableDS)ncd.findVariable("qc");
        assert (null != v);
        long start = System.nanoTime();
        int count = 0;
        Array data = v.read();
        while (data.hasNext()) {
            if (!v.isMissing(data.nextDouble())) continue;
            ++count;
        }
        System.out.println(" missing= " + count);
        long end = System.nanoTime();
        double took = (double)(end - start) / 1000.0 / 1000.0 / 1000.0;
        double perelem = (double)(end - start) / (double)data.getSize();
        System.out.println(" took=" + took + " secs; size= " + data.getSize() + "; nanosecs/elem= " + perelem);
    }
}

