/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import ucar.ma2.ArrayDouble;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Dimension;
import ucar.nc2.TestAll;
import ucar.nc2.dataset.CoordTransBuilder;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.grid.GeoGrid;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.units.SimpleUnit;
import ucar.unidata.geoloc.vertical.AtmosSigma;
import ucar.unidata.geoloc.vertical.HybridSigmaPressure;
import ucar.unidata.geoloc.vertical.OceanS;
import ucar.unidata.geoloc.vertical.OceanSG1;
import ucar.unidata.geoloc.vertical.OceanSG2;
import ucar.unidata.geoloc.vertical.OceanSigma;
import ucar.unidata.geoloc.vertical.VTfromExistingData;
import ucar.unidata.geoloc.vertical.VerticalTransform;
import ucar.unidata.geoloc.vertical.WRFEta;

public class TestTransforms
extends TestCase {
    private String testDir = "cdmUnitTest/transforms/";

    public TestTransforms(String name) {
        super(name);
    }

    public void testHybridSigmaPressure() throws IOException, InvalidRangeException {
        String filename = TestAll.testdataDir + this.testDir + "HybridSigmaPressure.nc";
        this.test(filename, "lev", "T", "time", VerticalCT.Type.HybridSigmaPressure, HybridSigmaPressure.class, SimpleUnit.pressureUnit);
    }

    public void testHybridSigmaPressure2() throws IOException, InvalidRangeException {
        String filename = TestAll.testdataDir + "grid/netcdf/cf/climo.cam2.h0.0000-09.nc";
        NetcdfDataset ncd = NetcdfDataset.openDataset((String)filename);
        VerticalTransform vt = this.test(ncd, "lev", "T", "time", VerticalCT.Type.HybridSigmaPressure, HybridSigmaPressure.class, SimpleUnit.pressureUnit);
        Dimension timeDim = ncd.findDimension("time");
        for (int i = 0; i < timeDim.getLength(); ++i) {
            ArrayDouble.D3 coordVals = vt.getCoordinateArray(i);
            int[] shape = coordVals.getShape();
            assert (shape[0] == ncd.findDimension("lev").getLength());
            assert (shape[1] == ncd.findDimension("lat").getLength());
            assert (shape[2] == ncd.findDimension("lon").getLength());
        }
        ncd.close();
    }

    public void testHybridSigmaPressure3() throws IOException, InvalidRangeException {
        String filename = TestAll.testdataDir + "grid/grib/grib1/ecmwf/HIRLAMhybrid.ncml";
        NetcdfDataset ncd = NetcdfDataset.openDataset((String)filename);
        VerticalTransform vt = this.test(ncd, "hybrid", "Relative_humidity", "time", VerticalCT.Type.HybridSigmaPressure, HybridSigmaPressure.class, SimpleUnit.pressureUnit);
        Dimension timeDim = ncd.findDimension("time");
        for (int i = 0; i < timeDim.getLength(); ++i) {
            ArrayDouble.D3 coordVals = vt.getCoordinateArray(i);
            int[] shape = coordVals.getShape();
            assert (shape[0] == ncd.findDimension("hybrid").getLength());
            assert (shape[1] == ncd.findDimension("y").getLength());
            assert (shape[2] == ncd.findDimension("x").getLength());
        }
        ncd.close();
    }

    public void testOceanS() throws IOException, InvalidRangeException {
        String filename = TestAll.testdataDir + this.testDir + "OceanS.nc";
        this.test(filename, "s_rho", "salt", "ocean_time", VerticalCT.Type.OceanS, OceanS.class, SimpleUnit.meterUnit);
    }

    public void testOceanS2() throws IOException, InvalidRangeException {
        String filename = TestAll.testdataDir + this.testDir + "OceanS2.nc";
        this.test(filename, "s_rho", "temp", "ocean_time", VerticalCT.Type.OceanS, OceanS.class, SimpleUnit.meterUnit);
    }

    public void testOceanSigma() throws IOException, InvalidRangeException {
        String filename = TestAll.testdataDir + this.testDir + "OceanSigma.nc";
        this.test(filename, "zpos", "salt", "time", VerticalCT.Type.OceanSigma, OceanSigma.class, SimpleUnit.meterUnit);
    }

    public void testOceanSigma2() throws IOException, InvalidRangeException {
        String filename = TestAll.testdataDir + this.testDir + "erie_test.ncml";
        this.test(filename, "sigma", "temp", "time", VerticalCT.Type.OceanSigma, OceanSigma.class, SimpleUnit.meterUnit);
    }

    public void testGomoos() throws IOException, InvalidRangeException {
        String filename = TestAll.testdataDir + this.testDir + "gomoos.ncml";
        this.test(filename, "zpos", "temp", "time", VerticalCT.Type.OceanSigma, OceanSigma.class, SimpleUnit.meterUnit);
    }

    public void testWrf() throws IOException, InvalidRangeException {
        String filename = TestAll.cdmUnitTestDir + "wrf/global.nc";
        this.test(filename, "z", "T", "Time", VerticalCT.Type.WRFEta, WRFEta.class, SimpleUnit.pressureUnit);
        this.test(filename, "z", "U", "Time", VerticalCT.Type.WRFEta, WRFEta.class, SimpleUnit.pressureUnit);
        this.test(filename, "z", "V", "Time", VerticalCT.Type.WRFEta, WRFEta.class, SimpleUnit.pressureUnit);
        this.test(filename, "z_stag", "W", "Time", VerticalCT.Type.WRFEta, WRFEta.class, SimpleUnit.meterUnit);
    }

    public void testWrf2() throws IOException, InvalidRangeException {
        String filename = TestAll.cdmUnitTestDir + "wrf/wrfout_mercator.nc";
        this.test(filename, "z", "T", "Time", VerticalCT.Type.WRFEta, WRFEta.class, SimpleUnit.pressureUnit);
        this.test(filename, "z", "U", "Time", VerticalCT.Type.WRFEta, WRFEta.class, SimpleUnit.pressureUnit);
        this.test(filename, "z", "V", "Time", VerticalCT.Type.WRFEta, WRFEta.class, SimpleUnit.pressureUnit);
        this.test(filename, "z_stag", "W", "Time", VerticalCT.Type.WRFEta, WRFEta.class, SimpleUnit.meterUnit);
    }

    public void btestOceanSigmaNcml() throws IOException, InvalidRangeException {
        String filename = "http://coast-enviro.er.usgs.gov/models/share/glos_test.ncml";
        this.test(filename, "sigma", "temp", "time", VerticalCT.Type.OceanSigma, OceanSigma.class, SimpleUnit.meterUnit);
    }

    public void btestOceanS3() throws IOException, InvalidRangeException {
        String filename = TestAll.testdataDir + this.testDir + "ocean_his.nc";
        this.test(filename, "s_rho", "u", "ocean_time", VerticalCT.Type.OceanS, OceanS.class, SimpleUnit.meterUnit);
    }

    public void btestOceanG1() throws IOException, InvalidRangeException {
        String filename = TestAll.testdataDir + this.testDir + "ocean_his_g1.nc";
        this.test(filename, "s_rho", "u", "ocean_time", VerticalCT.Type.OceanSG1, OceanSG1.class, SimpleUnit.meterUnit);
    }

    public void btestOceanG2() throws IOException, InvalidRangeException {
        String filename = TestAll.testdataDir + this.testDir + "ocean_his_g2.nc";
        this.test(filename, "s_rho", "u", "ocean_time", VerticalCT.Type.OceanSG2, OceanSG2.class, SimpleUnit.meterUnit);
    }

    public void testSigma() throws IOException, InvalidRangeException {
        String filename = TestAll.testdataDir + this.testDir + "Sigma_LC.nc";
        this.test(filename, "level", "Temperature", null, VerticalCT.Type.Sigma, AtmosSigma.class, SimpleUnit.pressureUnit);
    }

    public void testExisting3D() throws IOException, InvalidRangeException {
        String filename = TestAll.testdataDir + this.testDir + "VExisting3D_NUWG.nc";
        this.test(filename, "VerticalTransform", "rhu_hybr", "record", VerticalCT.Type.Existing3DField, VTfromExistingData.class, null);
    }

    private VerticalTransform test(String filename, String levName, String varName, String timeName, VerticalCT.Type vtype, Class vclass, SimpleUnit unit) throws IOException, InvalidRangeException {
        NetcdfDataset ncd = NetcdfDataset.openDataset((String)filename);
        this.test(ncd, levName, varName, timeName, vtype, vclass, unit);
        ncd.close();
        this.testGrid(filename, varName);
        return null;
    }

    private VerticalTransform test(NetcdfDataset ncd, String levName, String varName, String timeName, VerticalCT.Type vtype, Class vclass, SimpleUnit vunit) throws IOException, InvalidRangeException {
        System.out.printf("file= %s%n", ncd.getLocation());
        VariableDS lev = (VariableDS)ncd.findVariable(levName);
        assert (lev != null);
        System.out.println(" dump of ctv = \n" + lev);
        VariableDS v = (VariableDS)ncd.findVariable(varName);
        assert (v != null);
        System.out.printf(" data variable = %s%n", v);
        Section varSection = new Section(v.getShapeAsSection());
        List cList = v.getCoordinateSystems();
        assert (cList != null);
        assert (cList.size() == 1);
        CoordinateSystem csys = (CoordinateSystem)cList.get(0);
        ArrayList<CoordinateTransform> vList = new ArrayList<CoordinateTransform>();
        for (CoordinateTransform ct : csys.getCoordinateTransforms()) {
            if (ct.getTransformType() != TransformType.Vertical) continue;
            vList.add(ct);
        }
        assert (vList.size() == 1);
        CoordinateTransform ct = (CoordinateTransform)vList.get(0);
        assert (ct.getTransformType() == TransformType.Vertical);
        assert (ct instanceof VerticalCT);
        VerticalCT vct = (VerticalCT)ct;
        assert (vct.getVerticalTransformType() == vtype) : vct.getVerticalTransformType();
        VariableDS ctv = CoordTransBuilder.makeDummyTransformVariable((NetcdfDataset)ncd, (CoordinateTransform)ct);
        System.out.println(" dump of equivilent ctv = \n" + ctv);
        VerticalTransform vt = null;
        if (timeName == null) {
            vt = vct.makeVerticalTransform(ncd, null);
            assert (!vt.isTimeDependent());
            ArrayDouble.D3 coordVals = vt.getCoordinateArray(0);
            assert (null != coordVals);
            Section cSection = new Section(coordVals.getShape());
            System.out.printf(" coordVal shape = %s %n", cSection);
            assert (varSection.computeSize() == cSection.computeSize());
        } else {
            Dimension timeDim = ncd.findDimension(timeName);
            assert (null != timeDim);
            vt = vct.makeVerticalTransform(ncd, timeDim);
            assert (vt.isTimeDependent());
            varSection = varSection.removeRange(0);
            for (int i = 0; i < timeDim.getLength(); ++i) {
                ArrayDouble.D3 coordVals = vt.getCoordinateArray(i);
                assert (null != coordVals);
                Section cSection = new Section(coordVals.getShape());
                System.out.printf("%s: varSection shape = %s %n", v.getName(), varSection);
                System.out.printf("%s: coordVal shape = %s %n", v.getName(), cSection);
                assert (varSection.computeSize() == cSection.computeSize());
            }
        }
        assert (vt != null);
        assert (vclass.isInstance(vt));
        if (vunit != null) {
            String vertCoordUnit = vt.getUnitString();
            assert (vunit.isCompatible(vertCoordUnit)) : vertCoordUnit + " not udunits compatible with " + vunit.getUnitString();
        }
        return vt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testGrid(String uri, String var) throws IOException, InvalidRangeException {
        GridDataset ds = null;
        try {
            ds = GridDataset.open((String)uri);
            GeoGrid grid = ds.findGridByName(var);
            Section s = new Section(grid.getShape());
            System.out.printf("var = %s %n", s);
            GridCoordSystem GridCoordS = grid.getCoordinateSystem();
            VerticalTransform vt = GridCoordS.getVerticalTransform();
            ArrayDouble.D3 z = vt.getCoordinateArray(0);
            Section sv = new Section(z.getShape());
            System.out.printf("3dcoord = %s %n", sv);
            if (vt.isTimeDependent()) {
                s = s.removeRange(0);
            }
            assert (s.equals((Object)sv));
        }
        finally {
            if (ds != null) {
                ds.close();
            }
        }
    }
}

